/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerActionAdapter
extends AbstractAction {
    private static final Internationalizer defaultI18N = Internationalizer.getInternationalizer(ManagerActionAdapter.class);
    private ManagerAction action;
    private ManagerView managerView;

    public ManagerActionAdapter(ManagerAction action, ManagerView managerView) {
        Internationalizer i18n = action.getI18n();
        String actionText = i18n != null && i18n.canTranslate(action.getName()) ? i18n.translateString(action.getName()) : defaultI18N.translateString(action.getName());
        this.putValue("Name", actionText);
        this.putValue("SmallIcon", action.getIcon());
        this.action = action;
        this.managerView = managerView;
    }

    public void selectionChanged() {
        this.selectionChanged(this.managerView.getSelection());
    }

    public void selectionChanged(List<Serializable> selection) {
        this.setEnabled(this.action.isEnabled(selection));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.action.performAction(this.managerView);
    }
}

