/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.manager.generic.EntityQueryStrategyBase;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class IterableQueryStrategy
extends EntityQueryStrategyBase {
    private static Logger logger = Logger.getLogger(IterableQueryStrategy.class);
    private String queryString;
    private int pageSize;
    private transient List<String> entityNames;
    private transient List<Serializable> entityIds;

    public EntityQueryResults performQuery(EntityQueryFilter filter, EntityQuerySort sort, int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.queryString = filter.getFilterQueryString();
        if (sort != null) {
            this.queryString = this.queryString + " " + sort.getSortQueryString();
        }
        this.rowCreator = filter.getEntityRowCreator();
        this.entityNames = null;
        return this.getPage(pageNumber);
    }

    public EntityQueryResults getPage(int pageNumber) {
        logger.debug((Object)("---- getPage: " + pageNumber + "   queryString: [" + this.queryString + "]   pageSize: " + this.pageSize));
        boolean queryPerformed = false;
        try {
            Session session = Datastore.session();
            if (null == this.entityNames) {
                long time1 = System.currentTimeMillis();
                Query query = Datastore.session().createQuery(this.queryString);
                Iterator queryIterator = query.iterate();
                queryPerformed = true;
                long time2 = System.currentTimeMillis();
                this.entityNames = new Vector<String>();
                this.entityIds = new Vector<Serializable>();
                while (queryIterator.hasNext()) {
                    Object obj = queryIterator.next();
                    if (obj instanceof HibernateProxy) {
                        LazyInitializer lazy = ((HibernateProxy)obj).getHibernateLazyInitializer();
                        this.entityNames.add(lazy.getEntityName());
                        this.entityIds.add(lazy.getIdentifier());
                        continue;
                    }
                    this.entityNames.add(session.getEntityName(obj));
                    this.entityIds.add(session.getIdentifier(obj));
                }
                long time3 = System.currentTimeMillis();
                logger.debug((Object)("---- QUERY - iterator: " + (time2 - time1) + " millis,  results: " + (time3 - time2) + " millis,  total: " + (time3 - time1) + " millis."));
            }
            long time = System.currentTimeMillis();
            ArrayList<EntityManagerRow> page = new ArrayList<EntityManagerRow>(this.pageSize);
            for (int idx = pageNumber * this.pageSize; page.size() < this.pageSize && idx < this.entityNames.size(); ++idx) {
                Object obj = session.get(this.entityNames.get(idx), this.entityIds.get(idx));
                if (null != obj) {
                    page.add(this.createRowFromEntityOrProxy(obj));
                    continue;
                }
                if (queryPerformed) continue;
                this.entityNames = null;
                this.entityIds = null;
                return this.getPage(pageNumber);
            }
            logger.debug((Object)("---- results size: " + this.entityNames.size() + ",  page size: " + page.size() + ",  page created in: " + (System.currentTimeMillis() - time) + " millis."));
            return new EntityQueryResults(this.entityNames.size(), this.pageSize, pageNumber, page);
        }
        catch (HibernateException he) {
            logger.error((Object)he.getMessage(), (Throwable)he);
            return null;
        }
    }

    public void closeQuery() {
    }
}

