/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.client.gui.fault.events.EventRowProvider;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.model.fault.Event;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerRowTableModel
extends EntityManagerRowTableModel {
    protected Map<Long, EntityManagerRow> map = new LinkedHashMap<Long, EntityManagerRow>();
    protected ArrayList<List<String>> visibleDisplayData = new ArrayList();
    protected ArrayList<EntityManagerRow> visibleRows = new ArrayList();
    private boolean isHistoryView;

    public EventManagerRowTableModel(EntityManagerRowProvider rowProvider, String[] columns, boolean isHistoryView) {
        super(rowProvider, columns);
        this.isHistoryView = isHistoryView;
    }

    public void fireSeveritySelectionChanged(List<EntityManagerRow> newRows) {
        this.visibleDisplayData.clear();
        this.visibleRows.clear();
        for (EntityManagerRow row : newRows) {
            List<String> displayData = this.rowProvider.getDisplayValues(row);
            if (displayData == null) continue;
            this.visibleDisplayData.add(displayData);
            this.visibleRows.add(row);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.visibleDisplayData != null) {
            return this.visibleDisplayData.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.visibleDisplayData.get(rowIndex).get(columnIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.visibleRows.clear();
        this.visibleDisplayData.clear();
        super.clear();
    }

    @Override
    public List<String> getDisplayValues(EntityManagerRow row) {
        List<String> display = this.rowProvider.getDisplayValues(row);
        if (row != null) {
            row.setDisplayValues(display);
        }
        return display;
    }

    @Override
    public void addData(EntityManagerRow row) {
        List<String> display = this.getDisplayValues(row);
        if (row != null) {
            this.map.put(((Event)row.getEntity()).getId(), row);
            if (this.isHistoryView) {
                this.displayData.add(display);
                this.rows.add(row);
                if (display != null) {
                    this.visibleDisplayData.add(display);
                    this.visibleRows.add(row);
                }
            } else {
                this.displayData.add(0, display);
                this.rows.add(0, row);
                if (display != null) {
                    this.visibleDisplayData.add(0, display);
                    this.visibleRows.add(0, row);
                }
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addData(List<EntityManagerRow> newRows) {
        for (EntityManagerRow row : newRows) {
            List<String> display = this.getDisplayValues(row);
            this.map.put(((Event)row.getEntity()).getId(), row);
            this.displayData.add(display);
            this.rows.add(row);
            if (display == null) continue;
            this.visibleDisplayData.add(display);
            this.visibleRows.add(row);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void replaceData(List<EntityManagerRow> newRows) {
        this.map.clear();
        this.displayData.clear();
        this.visibleDisplayData.clear();
        this.rows.clear();
        this.visibleRows.clear();
        this.addData(newRows);
    }

    @Override
    public EntityManagerRow findRow(Serializable entity) {
        for (EntityManagerRow row : this.visibleRows) {
            if (!row.getEntity().equals(entity)) continue;
            return row;
        }
        return null;
    }

    @Override
    public void removeRow(EntityManagerRow row) {
        int indexVisibleRows;
        int indexRows = this.rows.indexOf(row);
        if (indexRows >= 0 && this.displayData != null) {
            this.rows.remove(indexRows);
            this.map.remove(((Event)row.getEntity()).getId());
            this.displayData.remove(indexRows);
        }
        if ((indexVisibleRows = this.visibleRows.indexOf(row)) >= 0 && this.visibleDisplayData != null) {
            this.visibleRows.remove(indexVisibleRows);
            this.visibleDisplayData.remove(indexVisibleRows);
            this.fireTableRowsDeleted(indexVisibleRows, indexVisibleRows);
        }
    }

    @Override
    public EntityManagerRow getRowAt(int row) {
        try {
            return this.visibleRows.get(row);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void updateRowAt(int index, EntityManagerRow row) {
        int indexRows = this.rows.indexOf(row);
        List<String> display = this.getDisplayValues(row);
        if (display != null) {
            this.displayData.set(indexRows, this.getDisplayValues(row));
            this.rows.set(indexRows, row);
            this.map.put(((Event)row.getEntity()).getId(), row);
        }
        if (this.visibleDisplayData != null) {
            this.visibleDisplayData.set(index, this.getDisplayValues(row));
            this.visibleRows.set(index, row);
        }
    }

    public EntityManagerRow findRowByID(long id) {
        return this.map.get(id);
    }

    public Map<Long, EntityManagerRow> getMap() {
        return this.map;
    }

    public Color getRowColor(int row, int column) {
        try {
            return ((EventRowProvider)this.rowProvider).getRowColor(this.visibleRows.get(row), column);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getEventAdvisor(int row, int column) {
        try {
            return ((Event)this.visibleRows.get(row).getEntity()).getEventAdvisor();
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public ArrayList<EntityManagerRow> getVisibleRows() {
        return this.visibleRows;
    }

    public ArrayList<List<String>> getVisibleDisplayData() {
        return this.visibleDisplayData;
    }
}

