/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.impl.EventDAOHelper;
import com.bwanms.backend.services.impl.EventQueryHelper;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.client.gui.fault.events.EventHistoryEntityQuerySort;
import com.bwanms.client.gui.fault.events.EventHistoryQueryFilter;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.entitymanager.EventHistoryQueryResults;
import com.bwanms.gui.manager.generic.EntityQueryStrategyBase;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.util.fault.FilterUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EventHistoryJDBCQueryStrategy
extends EntityQueryStrategyBase {
    private static String STATIC_QUERY_MYSQL_COUNT = null;
    private static String STATIC_QUERY_ORACLE_COUNT = null;
    private static String STATIC_QUERY_ORACLE = null;
    private static String STATIC_QUERY_MYSQL = null;
    private String QUERY_MYSQL_COUNT = null;
    private String QUERY_ORACLE_COUNT = null;
    private String QUERY_ORACLE = null;
    private String QUERY_MYSQL = null;
    private static Logger logger = Logger.getLogger(EventHistoryJDBCQueryStrategy.class);
    protected String queryString;
    protected String countQueryString;
    protected int pageSize;
    private static final String selectCols = EventQueryHelper.sqlSelectColsExcluded(Arrays.asList(Event.Property.eventCause), null);

    public EventHistoryJDBCQueryStrategy() {
        if (STATIC_QUERY_ORACLE == null) {
            try {
                Properties props = new Properties();
                props.load(EventHistoryJDBCQueryStrategy.class.getResourceAsStream("EventHistoryJDBCQueryStrategy.properties"));
                STATIC_QUERY_MYSQL_COUNT = props.getProperty("query.mysql.count");
                STATIC_QUERY_ORACLE_COUNT = props.getProperty("query.oracle.count");
                STATIC_QUERY_MYSQL = props.getProperty("query.mysql");
                STATIC_QUERY_ORACLE = props.getProperty("query.oracle");
                String[] queries = new String[]{STATIC_QUERY_ORACLE, STATIC_QUERY_MYSQL, STATIC_QUERY_MYSQL_COUNT, STATIC_QUERY_ORACLE_COUNT};
                for (int i = 0; i < queries.length; ++i) {
                    String query = queries[i];
                    query = query.replace("${historical_table}", Event.Table.Historical.tableName());
                    query = query.replace("${historical_secondary_table}", Event.Table.Historical2.tableName());
                    query = query.replace("${col_id}", Event.Property.id.columnName());
                    query = query.replace("${col_secondaryId}", Event.Property.secondaryId.columnName());
                    queries[i] = query = query.replace("${col_severity}", Event.Property.eventSeverity.columnName());
                }
                STATIC_QUERY_ORACLE = queries[0];
                STATIC_QUERY_MYSQL = queries[1];
                STATIC_QUERY_MYSQL_COUNT = queries[2];
                STATIC_QUERY_ORACLE_COUNT = queries[3];
            }
            catch (Exception e) {
                throw new RuntimeException("cant initialize");
            }
        }
        this.QUERY_MYSQL_COUNT = STATIC_QUERY_MYSQL_COUNT;
        this.QUERY_ORACLE_COUNT = STATIC_QUERY_ORACLE_COUNT;
        this.QUERY_MYSQL = STATIC_QUERY_MYSQL;
        this.QUERY_ORACLE = STATIC_QUERY_ORACLE;
    }

    public EntityQueryResults performQuery(EntityQueryFilter filter, EntityQuerySort sort, int pageSize, int pageNumber) {
        String whereClauseReceiveTime;
        this.pageSize = pageSize;
        this.rowCreator = filter.getEntityRowCreator();
        EventHistoryQueryFilter entityQueryFilter = (EventHistoryQueryFilter)filter;
        EventFilter eventFilter = entityQueryFilter.getFilter();
        String whereClause = FilterUtil.formatFilter(eventFilter, true);
        if (whereClause == null) {
            whereClause = "1=1";
        }
        List<Event.Property> evtProps = ((EventHistoryEntityQuerySort)sort).getSortByEventProperties();
        Event.Property firstOrderByColProp = evtProps.get(0);
        StringBuilder secondaryOrderBy = new StringBuilder();
        StringBuilder primaryOrderBy = new StringBuilder();
        String secondaryOrderByCol = null;
        if (firstOrderByColProp != null) {
            List<Boolean> sortDesc = ((EventHistoryEntityQuerySort)sort).getSortByDesc();
            int i = 0;
            if (!firstOrderByColProp.equals((Object)Event.Property.receiveTime)) {
                secondaryOrderBy.append(firstOrderByColProp.columnName() + (sortDesc.get(0) != false ? " DESC" : " ASC"));
                secondaryOrderByCol = firstOrderByColProp.columnName();
                i = 1;
            } else {
                secondaryOrderByCol = "1";
                secondaryOrderBy.append("null");
            }
            primaryOrderBy.append(evtProps.get(i).columnName()).append(sortDesc.get(i) != false ? " DESC" : " ASC");
            ++i;
            while (i < evtProps.size()) {
                primaryOrderBy.append(", ").append(evtProps.get(i).columnName()).append(sortDesc.get(i) != false ? " DESC" : " ASC");
                ++i;
            }
        }
        if ((whereClauseReceiveTime = FilterUtil.getTimeCriteria(entityQueryFilter.getFromDate(), entityQueryFilter.getToDate())) == null) {
            whereClauseReceiveTime = "1=1";
        }
        if (EventDAO.Database.getDB(null).equals((Object)EventDAO.Database.MySQL)) {
            this.countQueryString = this.QUERY_MYSQL_COUNT.replace("${where_clause}", whereClause).replace("${where_clause_receiveTime}", whereClauseReceiveTime);
            this.queryString = this.QUERY_MYSQL.replace("${select_fields}", "a1." + selectCols).replace("${secondary_order_by_col}", secondaryOrderByCol).replace("${where_clause}", whereClause).replace("${secondary_order_by}", secondaryOrderBy).replace("${where_clause_receiveTime}", whereClauseReceiveTime).replace("${primary_order_by}", primaryOrderBy);
        } else if (EventDAO.Database.getDB(null).equals((Object)EventDAO.Database.Oracle)) {
            this.countQueryString = this.QUERY_ORACLE_COUNT.replace("${where_clause}", whereClause).replace("${where_clause_receiveTime}", whereClauseReceiveTime);
            this.queryString = this.QUERY_ORACLE.replace("${select_fields}", "a." + selectCols).replace("${secondary_order_by_col}", secondaryOrderByCol).replace("${where_clause}", whereClause).replace("${secondary_order_by}", secondaryOrderBy).replace("${where_clause_receiveTime}", whereClauseReceiveTime).replace("${primary_order_by}", primaryOrderBy);
        } else {
            logger.error((Object)"unknown database implementation... );");
            return null;
        }
        return this.getPage(pageNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityQueryResults getPage(int pageNumber) {
        ArrayList<EntityManagerRow> page;
        logger.info((Object)("---- getPage: " + pageNumber));
        int resultsSize = 0;
        int[] counters = new int[7];
        int[] countersTotal = new int[7];
        Statement stm = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            stm = con.createStatement();
            String queryStr = null;
            queryStr = EventDAO.Database.getDB(null).equals((Object)EventDAO.Database.MySQL) ? this.queryString.replace("${page_size}", this.pageSize + "").replace("${page_offset}", "" + this.pageSize * pageNumber) : this.queryString.replace("${firstRow}", this.pageSize * pageNumber + "").replace("${lastRow}", "" + (this.pageSize * pageNumber + this.pageSize));
            logger.info((Object)("---- QUERY - queryString: [" + queryStr + "]   pageSize: " + this.pageSize));
            long time1 = System.currentTimeMillis();
            rs = stm.executeQuery(queryStr);
            long time2 = System.currentTimeMillis();
            logger.info((Object)("---- QUERY - select: " + (time2 - time1) + " millis"));
            page = new ArrayList<EntityManagerRow>(this.pageSize);
            while (rs.next()) {
                page.add(this.rowCreator.createRow(EventDAOHelper.createEvent(rs)));
            }
            JDBCConnectionProvider.close(rs);
            rs = null;
            long time3 = System.currentTimeMillis();
            logger.info((Object)("---- QUERY - page: " + (time3 - time2) + " millis"));
            logger.info((Object)("---- QUERY - queryCount: [" + this.countQueryString + "] "));
            rs = stm.executeQuery(this.countQueryString);
            while (rs.next()) {
                int sev = rs.getInt(1);
                int cnt = rs.getInt(2);
                int cntTotal = rs.getInt(3);
                resultsSize += cnt;
                try {
                    int n = sev;
                    counters[n] = counters[n] + cnt;
                    int n2 = sev;
                    countersTotal[n2] = countersTotal[n2] + cntTotal;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    counters[0] = counters[0] + cnt;
                    countersTotal[0] = countersTotal[0] + cntTotal;
                }
            }
            JDBCConnectionProvider.close(rs);
            rs = null;
            long time4 = System.currentTimeMillis();
            logger.info((Object)("---- QUERY - count: " + (time4 - time3) + " millis."));
            JDBCConnectionProvider.close(rs);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            EntityQueryResults entityQueryResults = null;
            return entityQueryResults;
        }
        finally {
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
            JDBCConnectionProvider.close(con);
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        logger.info((Object)("---- QUERY - results size: " + resultsSize + ", page size: " + page.size()));
        return new EventHistoryQueryResults(resultsSize, this.pageSize, pageNumber, page, counters, countersTotal);
    }

    public void closeQuery() {
    }
}

