/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerMediator;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.NavigatorViewListener;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerForm;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerActionAdapter;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.model.Identifiable;
import com.bwanms.model.Settings;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.MessageBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerView
implements ManagerView,
EntityChangeListener<Serializable>,
ResultsViewListener,
NavigatorViewListener {
    private static Logger logger = Logger.getLogger(EntityManagerView.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(EntityManagerView.class);
    protected EntityManagerConfig config;
    protected ManagerFilterView filterView;
    protected ManagerResultsView resultView;
    protected SortView sortView;
    protected NavigatorView navigatorView;
    protected ManagerMediator mediator;
    protected EntityManagerForm form;
    protected List<JComponent> actionComponents;
    private HashMap<String, ManagerActionAdapter> declaredActions;
    private boolean initialQueryPerformed;
    private List<EntityManagerRow> resultData;
    private boolean refreshResultData;

    public EntityManagerView(EntityManagerConfig config) {
        this.config = config;
        this.resultView = config.getResultsView();
        this.resultView.addResultsAreaListener(this);
        this.filterView = config.getFilterView();
        this.sortView = config.getSortView();
        this.navigatorView = config.getNavigatorView();
        this.navigatorView.addNavigatorViewListener(this);
        this.mediator = new ManagerMediator(config.getQueryStrategy(), config.getManagerCacheStrategy(), this.resultView, this.filterView, this.navigatorView, this.sortView);
        this.refreshResultData = true;
        this.loadSettings();
    }

    @Override
    public void selectionChanged(List<EntityManagerRow> selection) {
        if (this.declaredActions != null) {
            ArrayList<Serializable> selectedEntities = null;
            if (null != selection) {
                selectedEntities = new ArrayList<Serializable>(selection.size());
                for (EntityManagerRow row : selection) {
                    selectedEntities.add(row.getEntity());
                }
            }
            for (ManagerActionAdapter action : this.declaredActions.values()) {
                action.selectionChanged(selectedEntities);
            }
        }
    }

    private void prepareActions() {
        List<ManagerAction> declaredManagerActions = this.config.getDeclaredActions();
        this.declaredActions = new HashMap();
        for (ManagerAction managerAction : declaredManagerActions) {
            this.declaredActions.put(managerAction.getName(), new ManagerActionAdapter(managerAction, this));
        }
        if (null != this.config.getDefaultAction()) {
            this.declaredActions.put("##Default##", new ManagerActionAdapter(this.config.getDefaultAction(), this));
        }
    }

    @Override
    public JComponent getUI() {
        if (null == this.form) {
            JButton button;
            this.actionComponents = new Vector<JComponent>();
            for (ManagerAction action : this.config.getDeclaredActions()) {
                if (action.isHidden()) continue;
                button = new JButton();
                button.setName(action.getName());
                this.actionComponents.add(button);
            }
            this.prepareActions();
            this.form = new EntityManagerForm(i18n, this.filterView.getUI(), this.resultView.getUI(), this.navigatorView.getUI(), this.actionComponents);
            this.form.getBtnRefresh().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    EntityManagerView.this.performQuery();
                }
            });
            this.form.getBtnSelectCriteria().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EntityManagerView.this.actionSelectCriteria();
                }
            });
            for (JComponent comp : this.actionComponents) {
                button = (JButton)comp;
                button.setAction(this.declaredActions.get(button.getName()));
            }
            Vector<JMenuItem> menuItems = new Vector<JMenuItem>();
            int category = 0;
            for (ManagerAction action : this.config.getDeclaredActions()) {
                if (0 == category) {
                    category = action.getCategory();
                } else if (category != action.getCategory()) {
                    category = action.getCategory();
                    menuItems.add(null);
                }
                menuItems.add(new JMenuItem(this.declaredActions.get(action.getName())));
            }
            this.resultView.updateContextMenu(menuItems);
            this.resultView.setDefaultActionListener(this.declaredActions.get("##Default##"));
            this.form.getBtnHelp().setVisible(true);
            this.form.getBtnHelp().setAction(new HelpAction(this.config.getHelpTopic()));
            this.form.getBtnHelp().setText("");
            this.performInitialQuery();
        }
        return this.form;
    }

    void performInitialQuery() {
        if (!this.initialQueryPerformed) {
            this.initialQueryPerformed = true;
            this.performQuery();
        }
    }

    @Override
    public void performQuery() {
        this.saveSettings();
        if (null != this.filterView) {
            try {
                this.filterView.prepareFilter();
            }
            catch (InvalidFilterValueException ifve) {
                String message = i18n.translateString("InvalidDate", ifve.getMessage());
                MessageBox.Error.quickShow(this.form, message);
                return;
            }
        }
        new UIBackgroundJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    EntityManagerView.this.form.getBtnRefresh().setEnabled(false);
                    EntityManagerView.this.mediator.performQuery();
                }
                catch (Throwable t) {
                    try {
                        logger.error((Object)t, t);
                        MessageBox.Error.quickShow(EntityManagerView.this.form, i18n.translateString("ErrorOccured.PleaseRefresh"));
                    }
                    catch (Throwable throwable) {
                        UIEventThread.asyncExec(new Runnable(){

                            public void run() {
                                EntityManagerView.this.form.getBtnRefresh().setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    UIEventThread.asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                UIEventThread.asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }.schedule();
    }

    private void actionSelectCriteria() {
        this.filterView.selectFilterCriteria(this);
    }

    private void loadSettings() {
        try {
            if (null != this.navigatorView) {
                Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
                String pageSizeStr = settings.getProperty("NavigatorPageSize:" + this.config.getManagerName(), null);
                this.navigatorView.setPageSize(null != pageSizeStr ? Integer.parseInt(pageSizeStr) : this.config.getPageSize());
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected void saveSettings() {
        try {
            if (null != this.navigatorView) {
                Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
                settings.setProperty("NavigatorPageSize:" + this.config.getManagerName(), String.valueOf(this.navigatorView.getPageSize()));
                ServiceRegistry.getSettingsService().updateSettings(settings);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
        if (null != this.mediator) {
            this.mediator.close();
        }
    }

    @Override
    public String getTitle() {
        return this.config.getTitle();
    }

    @Override
    public void entityChanged(Serializable entity) {
        this.resultView.entityChanged(this.mediator.fetchRow(entity.getClass(), Long.valueOf(((Identifiable)((Object)entity)).getId())));
        this.selectionChanged(this.getSelectionData());
        this.refreshResultData = true;
    }

    @Override
    public void entityAdded(Serializable entity) {
        this.resultView.entityAdded(this.mediator.fetchRow(entity.getClass(), Long.valueOf(((Identifiable)((Object)entity)).getId())));
        this.refreshResultData = true;
    }

    @Override
    public void entityRemoved(Serializable entity) {
        this.resultView.entityRemoved(entity);
        this.refreshResultData = true;
    }

    @Override
    public List<Serializable> getSelection() {
        List<EntityManagerRow> selectionRows = this.getSelectionData();
        if (null != selectionRows) {
            ArrayList<Serializable> selection = new ArrayList<Serializable>(selectionRows.size());
            for (EntityManagerRow row : selectionRows) {
                selection.add(row.getEntity());
            }
            return selection;
        }
        return null;
    }

    @Override
    public List<EntityManagerRow> getSelectionData() {
        return this.resultView.getSelection();
    }

    @Override
    public void pageSizeChanged(int pageSize) {
        this.mediator.setPageSize(pageSize);
        this.refreshResultData = true;
    }

    @Override
    public void pageChanged(int pageNumber) {
        try {
            this.mediator.pageChanged(pageNumber);
            this.refreshResultData = true;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            MessageBox.Error.quickShow(this.form, i18n.translateString("ErrorOccured.PleaseRefresh"));
        }
    }

    @Override
    public List<EntityManagerRow> getData() {
        if (this.refreshResultData) {
            this.resultData = this.resultView.getData();
            this.refreshResultData = false;
        }
        return this.resultData;
    }

    public EntityManagerConfig getConfig() {
        return this.config;
    }
}

