/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerRowTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4570860583142017324L;
    protected ArrayList<List<String>> displayData = new ArrayList();
    EntityManagerRowProviderBase rowProvider;
    private String[] columns;
    int iconColIdx;
    protected ArrayList<EntityManagerRow> rows = new ArrayList();

    public EntityManagerRowTableModel(EntityManagerRowProvider rowProvider, String[] columns, int iconColIdx) {
        this.rowProvider = (EntityManagerRowProviderBase)rowProvider;
        this.columns = columns;
        this.iconColIdx = iconColIdx;
    }

    public EntityManagerRowTableModel(EntityManagerRowProvider rowProvider, String[] columns) {
        this(rowProvider, columns, 0);
    }

    public void clear() {
        this.displayData.clear();
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public void addData(EntityManagerRow row) {
        if (row != null) {
            this.displayData.add(this.getDisplayValues(row));
            this.rows.add(row);
            this.fireTableDataChanged();
        }
    }

    public void addData(List<EntityManagerRow> newRows) {
        for (EntityManagerRow row : newRows) {
            this.displayData.add(this.getDisplayValues(row));
            this.rows.add(row);
        }
        this.fireTableDataChanged();
    }

    public void replaceData(List<EntityManagerRow> newRows) {
        this.displayData.clear();
        this.rows.clear();
        this.addData(newRows);
    }

    public void sortData(Comparator<EntityManagerRow> comparator) {
        ArrayList<EntityManagerRow> sortedRows = new ArrayList<EntityManagerRow>(this.rows);
        Collections.sort(sortedRows, comparator);
        this.replaceData(sortedRows);
    }

    public void removeRow(EntityManagerRow row) {
        int index = this.rows.indexOf(row);
        if (index >= 0 && this.displayData != null) {
            this.rows.remove(index);
            this.displayData.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public int getRowCount() {
        if (this.displayData != null) {
            return this.displayData.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.displayData.get(rowIndex).get(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    public EntityManagerRow getRowAt(int row) {
        return this.rows.get(row);
    }

    public void updateRowAt(int index, EntityManagerRow row) {
        this.displayData.set(index, this.getDisplayValues(row));
        this.rows.set(index, row);
    }

    public List<String> getDisplayValues(EntityManagerRow row) {
        List<String> display = row.getDisplayValues();
        if (display == null) {
            display = this.rowProvider.getDisplayValues(row);
            if (row != null) {
                row.setDisplayValues(display);
            }
        }
        return display;
    }

    public Serializable getEntity(int row) {
        EntityManagerRow entityManagerRow = this.rows.get(row);
        return entityManagerRow == null ? null : entityManagerRow.getEntity();
    }

    public EntityManagerRow findRow(Serializable entity) {
        for (EntityManagerRow row : this.rows) {
            if (!row.getEntity().equals(entity)) continue;
            return row;
        }
        return null;
    }

    public boolean isIconSupported() {
        return false;
    }

    public Icon getIcon(int row) {
        return null;
    }

    public ArrayList<EntityManagerRow> getRows() {
        return this.rows;
    }

    public String getIconColumn() {
        if (this.iconColIdx == -1) {
            return null;
        }
        return this.columns[this.iconColIdx];
    }

    public void setIconColIdx(int iconColIdx) {
        this.iconColIdx = iconColIdx;
    }

    public ArrayList<List<String>> getDisplayData() {
        return this.displayData;
    }
}

