/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.manager.generic.EntityManagerQueryJoinClass;
import com.bwanms.util.BeanUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityManagerRowProviderBase
implements EntityManagerRowProvider {
    protected List<String> attributes;

    public EntityManagerRowProviderBase(List<String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public EntityManagerRow createRow(Serializable entity) {
        List<Serializable> values = null;
        try {
            values = this.readAttributeValues(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            values = new ArrayList<Serializable>();
        }
        Serializable clientData = this.readClientData(entity);
        return new EntityManagerRow(entity, this.readEntityId(entity), this.attributes, values, clientData);
    }

    @Override
    public List<String> getDisplayValues(EntityManagerRow entityRow) {
        ArrayList<String> ret = new ArrayList<String>(this.attributes.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            Serializable val = entityRow.getAttributeValue(i);
            ret.add(null != val ? val.toString() : "");
        }
        return ret;
    }

    protected abstract String readEntityId(Serializable var1);

    protected List<Serializable> readAttributeValues(Serializable entity) {
        Vector<Serializable> ret = new Vector<Serializable>(this.attributes.size());
        for (String attribName : this.attributes) {
            if (!"".equals(attribName)) {
                ret.add(this.readEntityAttributeValue(entity, attribName));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    protected Serializable readClientData(Serializable entity) {
        return null;
    }

    protected Serializable readEntityAttributeValue(Serializable entity, String attributeName) {
        try {
            return (Serializable)EntityManagerRowProviderBase.readAttributeValue(entity, attributeName);
        }
        catch (NoSuchMethodException nsfe) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    protected static final Object readAttributeValue(Object object, String attribName) throws NoSuchMethodException, InvocationTargetException {
        Class<?> c = object.getClass();
        try {
            Method m = c.getMethod(BeanUtils.getGetterName(attribName), new Class[0]);
            return m.invoke(object, new Object[0]);
        }
        catch (SecurityException se) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<EntityManagerQueryJoinClass> getEntityQueryJoinClasses() {
        return null;
    }
}

