/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerResultForm;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerResultView
implements ManagerResultsView {
    protected static Internationalizer i18n = Internationalizer.getInternationalizer(EntityManagerResultView.class);
    protected EntityManagerResultForm form;
    protected EntityManagerRowTableModel tableModel;
    private Vector<ResultsViewListener> listeners = new Vector();
    private Action defaultAction;
    private List<EntityManagerColumn> columns;
    private boolean sortEnabled = false;
    protected int sortedColumn = -1;
    protected boolean sortedAscending = false;

    public EntityManagerResultView(EntityManagerRowTableModel tableModel, List<EntityManagerColumn> columns) {
        this.tableModel = tableModel;
        this.columns = columns;
    }

    @Override
    public EntityQuerySort getEntityQuerySort() {
        return null;
    }

    @Override
    public void setEntityQueryResults(EntityQueryResults data) {
        int totalResultCount = 0;
        if (null == data) {
            this.tableModel.clear();
            this.sortedColumn = -1;
        } else {
            this.replaceData(data);
            totalResultCount = data.getResultSetSize();
        }
        this.fireSelectionChanged();
        this.updateResultsDescription(totalResultCount);
    }

    protected void replaceData(EntityQueryResults data) {
        this.tableModel.replaceData(data.getData());
        this.sortedColumn = -1;
    }

    @Override
    public List<EntityManagerRow> getSelection() {
        int[] selectedRows = this.form.getResultTable().getSelectedRows();
        if (null == selectedRows) {
            return null;
        }
        Vector<EntityManagerRow> selection = new Vector<EntityManagerRow>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            selection.add(this.tableModel.getRowAt(selectedRows[i]));
        }
        return selection;
    }

    @Override
    public void addResultsAreaListener(ResultsViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeResultsAreaListener(ResultsViewListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public JComponent getUI() {
        if (null == this.form) {
            this.form = new EntityManagerResultForm(this.tableModel);
            this.configure();
        }
        this.fireSelectionChanged();
        return this.form;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return "Results";
    }

    @Override
    public void updateContextMenu(List<JMenuItem> menuItems) {
        this.form.getPopup().removeAll();
        for (JMenuItem item : menuItems) {
            if (null != item) {
                this.form.getPopup().add(item);
                continue;
            }
            this.form.getPopup().addSeparator();
        }
    }

    @Override
    public void setDefaultActionListener(Action listener) {
        this.defaultAction = listener;
    }

    @Override
    public void entityChanged(EntityManagerRow entity) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            EntityManagerRow row = this.tableModel.getRowAt(i);
            if (!entity.getId().equals(row.getId())) continue;
            this.tableModel.updateRowAt(i, entity);
            this.tableModel.fireTableRowsUpdated(i, i);
            this.sortedColumn = -1;
            break;
        }
    }

    @Override
    public void entityAdded(EntityManagerRow entity) {
        this.tableModel.addData(entity);
        this.sortedColumn = -1;
        this.updateResultsDescription(null);
    }

    @Override
    public void entityRemoved(Serializable entity) {
        EntityManagerRow row = this.tableModel.findRow(entity);
        if (null != row) {
            this.tableModel.removeRow(row);
        }
        this.updateResultsDescription(null);
    }

    protected void configure() {
        this.form.getResultTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                EntityManagerResultView.this.fireSelectionChanged();
            }
        });
        this.form.getResultTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (2 <= arg0.getClickCount() && null != EntityManagerResultView.this.defaultAction && EntityManagerResultView.this.defaultAction.isEnabled()) {
                    EntityManagerResultView.this.defaultAction.actionPerformed(new ActionEvent(arg0.getSource(), arg0.getID(), null));
                }
            }
        });
        if (this.sortEnabled) {
            this.form.getResultTable().getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent arg0) {
                    int column = EntityManagerResultView.this.form.getResultTable().getTableHeader().columnAtPoint(new Point(arg0.getX(), arg0.getY()));
                    TableColumn tblColumn = EntityManagerResultView.this.form.getResultTable().getTableHeader().getColumnModel().getColumn(column);
                    EntityManagerResultView.this.sortByColumn(tblColumn.getModelIndex());
                }
            });
        }
    }

    protected void sortByColumn(int column) {
        Comparator<EntityManagerRow> comparator = this.columns.get(column).getComparator();
        if (null != comparator) {
            if (column != this.sortedColumn) {
                this.sortData(comparator);
                this.sortedColumn = column;
                this.sortedAscending = true;
            } else {
                this.sortData(this.sortedAscending ? Collections.reverseOrder(comparator) : comparator);
                this.sortedColumn = column;
                this.sortedAscending = !this.sortedAscending;
            }
        }
    }

    protected void sortData(Comparator<EntityManagerRow> comparator) {
        this.tableModel.sortData(comparator);
    }

    protected void fireSelectionChanged() {
        for (ResultsViewListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    @Override
    public List<EntityManagerRow> getData() {
        ArrayList<EntityManagerRow> rows = new ArrayList<EntityManagerRow>(this.tableModel.getRowCount());
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            rows.add(this.tableModel.getRowAt(i));
        }
        return rows;
    }

    protected void updateResultsDescription(Integer totalResultCount) {
        if (null != totalResultCount) {
            this.form.getLblResultDescription().setText(i18n.translateString("ResultsDescriptionCurrentTotal", this.tableModel.getRowCount(), totalResultCount));
        } else {
            this.form.getLblResultDescription().setText(i18n.translateString("ResultsDescriptionCurrent", this.tableModel.getRowCount()));
        }
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
    }

    public EntityManagerRowTableModel getTableModel() {
        return this.tableModel;
    }

    public EntityManagerResultForm getForm() {
        return this.form;
    }
}

