/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.gui.manager.generic.ComboEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.ui.components.ComboItem;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class EntityManagerResultForm
extends JPanel {
    private static final long serialVersionUID = -5459684223591210776L;
    private JScrollPane scrollPane;
    private JTable resultTable;
    private JLabel lblResultDescription;
    private JPopupMenu popup;

    public EntityManagerResultForm(EntityManagerRowTableModel model) {
        this.initComponents();
        this.postInitComponents(model);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.resultTable = new JTable();
        this.lblResultDescription = new JLabel();
        this.popup = new JPopupMenu();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.resultTable.setModel(new DefaultTableModel());
        this.resultTable.setComponentPopupMenu(null);
        this.resultTable.setPreferredScrollableViewportSize(new Dimension(320, 320));
        this.resultTable.setInheritsPopupMenu(true);
        this.resultTable.setDoubleBuffered(true);
        this.resultTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EntityManagerResultForm.this.resultTableMouseClicked(e);
            }
        });
        this.scrollPane.setViewportView(this.resultTable);
        this.add((Component)this.scrollPane, cc.xy(1, 1));
        this.add((Component)this.lblResultDescription, cc.xy(1, 3));
    }

    private void postInitComponents(EntityManagerRowTableModel model) {
        this.resultTable.setModel(model);
        if (model.isIconSupported() && model.getIconColumn() != null) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                if (!model.getColumnName(i).equals(model.getIconColumn())) continue;
                this.resultTable.getColumnModel().getColumn(i).setCellRenderer(new IconTableCellRenderer());
                break;
            }
        }
        if (model instanceof ComboEntityManagerRowTableModel) {
            this.resultTable.getTableHeader().setReorderingAllowed(false);
            ComboEntityManagerRowTableModel model2 = (ComboEntityManagerRowTableModel)model;
            for (int i = 0; i < model.getColumnCount(); ++i) {
                if (i != model2.getComboColumn()) continue;
                this.resultTable.getColumnModel().getColumn(i).setCellEditor(new RowTableCellEditor(new JComboBox(), i));
                this.resultTable.getColumnModel().getColumn(i).setCellRenderer(new ComboRenderer());
                break;
            }
        }
    }

    private void resultTableMouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            int row = this.resultTable.rowAtPoint(e.getPoint());
            if (this.resultTable.isRowSelected(row)) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this.resultTable.setRowSelectionInterval(row, row);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public JTable getResultTable() {
        return this.resultTable;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public JLabel getLblResultDescription() {
        return this.lblResultDescription;
    }

    public static class RowTableCellEditor
    extends DefaultCellEditor {
        private int column;

        public RowTableCellEditor(JTextField textField) {
            super(textField);
        }

        public RowTableCellEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        public RowTableCellEditor(final JComboBox comboBox, int column) {
            super(comboBox);
            this.clickCountToStart = 2;
            this.column = column;
            comboBox.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    if (value instanceof ComboItem) {
                        comboBox.setSelectedItem(value);
                    } else {
                        int count = comboBox.getItemCount();
                        for (int i = 0; i < count; ++i) {
                            ComboItem item = (ComboItem)comboBox.getItemAt(i);
                            if (!item.getValue().equals(value)) continue;
                            comboBox.setSelectedItem(item);
                            return;
                        }
                    }
                }

                public Object getCellEditorValue() {
                    Object selectedItem = comboBox.getSelectedItem();
                    if (selectedItem instanceof ComboItem) {
                        return ((ComboItem)selectedItem).getValue();
                    }
                    return selectedItem;
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                public boolean stopCellEditing() {
                    if (comboBox.isEditable()) {
                        comboBox.actionPerformed(new ActionEvent(RowTableCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            comboBox.addActionListener(this.delegate);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EntityManagerRowTableModel model = (EntityManagerRowTableModel)table.getModel();
            if (this.editorComponent instanceof JComboBox) {
                JComboBox editor = (JComboBox)this.editorComponent;
                editor.removeAllItems();
                Serializable v = model.getRowAt(row).getAttributeValue(column);
                if (v instanceof List) {
                    List valueSet = (List)((Object)v);
                    for (ComboItem item : valueSet) {
                        editor.addItem(item);
                    }
                    ComboItem selectedItem = ComboItem.searchByValue(valueSet, value);
                    if (selectedItem != null) {
                        editor.setSelectedItem(selectedItem);
                    }
                } else {
                    if (value instanceof String) {
                        String[] arr = ((String)value).split(",");
                        for (int i = 0; i < arr.length; ++i) {
                            if (i == 0 && "[".equals(arr[i].substring(0, 1))) {
                                editor.addItem(arr[i].substring(1));
                                continue;
                            }
                            if (i == arr.length - 1 && "]".equals(arr[i].substring(arr[i].length() - 1, arr[i].length()))) {
                                editor.addItem(arr[i].subSequence(0, arr[i].length() - 1));
                                continue;
                            }
                            editor.addItem(arr[i]);
                        }
                    }
                    editor.setSelectedItem(v);
                }
                return editor;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    static class ComboRenderer
    implements TableCellRenderer {
        JComponent renderer = null;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Serializable model = ((EntityManagerRowTableModel)table.getModel()).getRowAt(row).getAttributeValue(column);
            if (model instanceof String) {
                String[] arr = ((String)((Object)model)).split(",");
                if (arr.length > 1) {
                    this.renderer = new JComboBox();
                    for (int i = 0; i < arr.length; ++i) {
                        if (i == 0 && "[".equals(arr[i].substring(0, 1))) {
                            ((JComboBox)this.renderer).addItem(arr[i].substring(1));
                            continue;
                        }
                        if (i == arr.length - 1 && "]".equals(arr[i].substring(arr[i].length() - 1, arr[i].length()))) {
                            ((JComboBox)this.renderer).addItem(arr[i].subSequence(0, arr[i].length() - 1));
                            continue;
                        }
                        ((JComboBox)this.renderer).addItem(arr[i]);
                    }
                } else {
                    this.renderer = new JLabel();
                    ((JLabel)this.renderer).setText((String)((Object)model));
                    ((JLabel)this.renderer).setOpaque(true);
                }
            } else if (model instanceof List) {
                this.renderer = new JComboBox();
                for (Object s : (List)((Object)model)) {
                    if (!(s instanceof ComboItem)) continue;
                    ((JComboBox)this.renderer).addItem(((ComboItem)s).getValue());
                }
            }
            if (isSelected) {
                this.renderer.setForeground(table.getSelectionForeground());
                this.renderer.setBackground(table.getSelectionBackground());
            } else {
                this.renderer.setForeground(table.getForeground());
                this.renderer.setBackground(table.getBackground());
            }
            return this.renderer;
        }
    }

    private class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        private IconTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel ret = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ret.setIcon(((EntityManagerRowTableModel)table.getModel()).getIcon(row));
            return ret;
        }
    }
}

