/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.NavigatorViewListener;
import com.bwanms.gui.manager.generic.EntityManagerNavigatorForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

public class EntityManagerNavigatorView
implements NavigatorView {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(EntityManagerNavigatorView.class);
    private int pageSize;
    private int pageNumber;
    private int pageCount;
    private EntityManagerNavigatorForm form;
    private List<NavigatorViewListener> listeners;

    public EntityManagerNavigatorView(int pageSize) {
        this.pageSize = pageSize;
        this.listeners = new Vector<NavigatorViewListener>();
        this.initUI();
        this.updateComponentsStatus();
    }

    private void initUI() {
        this.form = new EntityManagerNavigatorForm();
        this.form.getBtnNext().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerNavigatorView.this.actionNextPerformed();
            }
        });
        this.form.getBtnPrev().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerNavigatorView.this.actionPrevPerformed();
            }
        });
        this.form.getBtnFirst().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerNavigatorView.this.actionFirstPerformed();
            }
        });
        this.form.getBtnLast().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerNavigatorView.this.actionLastPerformed();
            }
        });
        this.form.getBtnGoToPage().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerNavigatorView.this.actionGoToPagePerformed();
            }
        });
        i18n.getSwingInternationalizer().translateComponent(this.form);
    }

    public void addNavigatorViewListener(NavigatorViewListener listener) {
        this.listeners.add(listener);
    }

    public void removeNavigatorViewListener(NavigatorViewListener listener) {
        this.listeners.remove(listener);
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return null;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        this.updateComponentsStatus();
    }

    public void updateComponentsStatus() {
        this.form.getBtnPrev().setEnabled(0 < this.pageCount && this.pageNumber > 0);
        this.form.getBtnNext().setEnabled(0 < this.pageCount && this.pageNumber < this.pageCount - 1);
        this.form.getBtnFirst().setEnabled(this.form.getBtnPrev().isEnabled());
        this.form.getBtnLast().setEnabled(this.form.getBtnNext().isEnabled());
        this.form.getBtnGoToPage().setEnabled(0 < this.pageCount);
        this.form.getSpinnerPage().setEnabled(0 < this.pageCount);
        try {
            this.form.setPageSpinnerValues(this.pageNumber + 1, Integer.valueOf(1), Integer.valueOf(0 < this.pageCount ? this.pageCount : 1), 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.form.getLblPageDescription().setText(0 < this.pageCount ? "page " + (this.pageNumber + 1) + " of " + this.pageCount : "");
    }

    public void enableButtons(boolean value) {
        this.form.getBtnFirst().setEnabled(value);
        this.form.getBtnPrev().setEnabled(value);
        this.form.getBtnNext().setEnabled(value);
        this.form.getBtnLast().setEnabled(value);
        this.form.getBtnGoToPage().setEnabled(value);
        if (value) {
            this.updateComponentsStatus();
        }
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        int uiPageSize = (Integer)this.form.getSpinnerPageSize().getValue();
        if (uiPageSize != this.pageSize) {
            this.pageSize = (Integer)this.form.getSpinnerPageSize().getValue();
            this.pageSizeChanged();
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.form.setPageSizeSpinnerValue(pageSize);
        this.pageSizeChanged();
    }

    public void setEntityQueryResults(EntityQueryResults results) {
        this.setPageSize(results.getPageSize());
        if (0 == this.pageSize) {
            return;
        }
        int totalResultsSize = results.getResultSetSize();
        this.pageCount = totalResultsSize / this.pageSize + (0 != totalResultsSize % this.pageSize ? 1 : 0);
        this.pageNumber = results.getPageNumber();
        if (0 == this.pageCount) {
            this.pageNumber = 0;
        } else if (this.pageNumber >= this.pageCount) {
            this.pageNumber = this.pageCount - 1;
        }
        this.updateComponentsStatus();
    }

    private void actionNextPerformed() {
        ++this.pageNumber;
        this.pageChanged();
    }

    private void actionPrevPerformed() {
        --this.pageNumber;
        this.pageChanged();
    }

    private void actionFirstPerformed() {
        this.pageNumber = 0;
        this.pageChanged();
    }

    private void actionLastPerformed() {
        this.pageNumber = this.pageCount - 1;
        this.pageChanged();
    }

    private void actionGoToPagePerformed() {
        int oldPageNumber = this.pageNumber;
        this.pageNumber = (Integer)this.form.getSpinnerPage().getValue() - 1;
        if (this.pageNumber != oldPageNumber) {
            this.pageChanged();
        }
    }

    private void pageChanged() {
        for (NavigatorViewListener listener : this.listeners) {
            listener.pageChanged(this.pageNumber);
        }
        this.updateComponentsStatus();
    }

    private void pageSizeChanged() {
        for (NavigatorViewListener listener : this.listeners) {
            listener.pageSizeChanged(this.pageSize);
        }
    }
}

