/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerFilter;
import com.bwanms.gui.manager.generic.EntityManagerFilterForm;
import com.bwanms.gui.manager.generic.EntityManagerFilterSelectorDialog;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.model.Settings;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFilterView
implements ManagerFilterView {
    private static Logger logger = Logger.getLogger(EntityManagerFilterView.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(EntityManagerFilterView.class);
    private String managerName;
    private String entityBaseName;
    private List<ManagerFilterCriteria> criteriaList;
    private EntityManagerRowProvider rowCreator;
    private EntityManagerFilterForm form;
    private EntityQueryFilter filter;
    private String defaultQueryString;
    private List<ManagerFilterCriteriaView> selectedCriteriaViewList;
    private Map<String, ManagerFilterCriteriaView> selectedCriteriaMap;

    public EntityManagerFilterView(String managerName, String entityBaseName, List<ManagerFilterCriteria> criteriaList, EntityManagerRowProvider rowCreator, String defaultQueryString) {
        this(managerName, entityBaseName, criteriaList, rowCreator);
        this.defaultQueryString = defaultQueryString;
    }

    public EntityManagerFilterView(String managerName, String entityBaseName, List<ManagerFilterCriteria> criteriaList, EntityManagerRowProvider rowCreator) {
        this.managerName = managerName;
        this.criteriaList = criteriaList;
        this.entityBaseName = entityBaseName;
        this.rowCreator = rowCreator;
        this.initUI();
    }

    @Override
    public void prepareFilter() throws InvalidFilterValueException {
        this.filter = new EntityManagerFilter(this.entityBaseName, this.selectedCriteriaViewList, this.rowCreator, this.defaultQueryString);
        try {
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            this.saveFilterValueSettings(settings, this.selectedCriteriaMap);
            ServiceRegistry.getSettingsService().updateSettings(settings);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public EntityQueryFilter getFilter() {
        return this.filter;
    }

    @Override
    public JComponent getUI() {
        return this.form;
    }

    @Override
    public boolean close() {
        if (null != this.selectedCriteriaViewList) {
            for (ManagerFilterCriteriaView view : this.selectedCriteriaViewList) {
                if (view.close()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void cleanup() {
        if (null != this.selectedCriteriaViewList) {
            for (ManagerFilterCriteriaView view : this.selectedCriteriaViewList) {
                view.cleanup();
            }
        }
    }

    @Override
    public String getTitle() {
        return null;
    }

    private void initUI() {
        if (null == this.criteriaList || this.criteriaList.isEmpty()) {
            return;
        }
        this.form = new EntityManagerFilterForm();
        Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
        this.setFormCriteriaList(settings);
    }

    private void setFormCriteriaList(Settings settings) {
        String selectedCriteriaProperty = settings.getProperty("ActiveFilters:" + this.managerName, "");
        List<String> criteriaNameList = EntityManagerFilterView.stringListToList(selectedCriteriaProperty);
        this.selectedCriteriaViewList = new Vector<ManagerFilterCriteriaView>();
        this.selectedCriteriaMap = new TreeMap<String, ManagerFilterCriteriaView>();
        String prefix = "SelectedFilterValues:" + this.managerName + ":";
        for (ManagerFilterCriteria criteriaItem : this.criteriaList) {
            if (!criteriaNameList.contains(criteriaItem.getName())) continue;
            ManagerFilterCriteriaView view = criteriaItem.createView();
            this.selectedCriteriaViewList.add(view);
            this.selectedCriteriaMap.put(criteriaItem.getName(), view);
            String valuesAsString = settings.getProperty(prefix + criteriaItem.getName(), null);
            if (null == valuesAsString) continue;
            view.setValuesFromString(valuesAsString);
        }
        this.form.setCriteriaViewList(this.selectedCriteriaViewList);
    }

    @Override
    public void selectFilterCriteria(ManagerView managerView) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this.form);
        EntityManagerFilterSelectorDialog dlg = parentWindow instanceof Dialog ? new EntityManagerFilterSelectorDialog((Dialog)parentWindow) : new EntityManagerFilterSelectorDialog((Frame)parentWindow);
        Vector<String> nameList = new Vector<String>(this.criteriaList.size());
        HashMap<String, ManagerFilterCriteriaView> viewMap = new HashMap<String, ManagerFilterCriteriaView>(this.criteriaList.size());
        Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
        String prefix = "SelectedFilterValues:" + this.managerName + ":";
        for (ManagerFilterCriteria criteriaItem : this.criteriaList) {
            nameList.add(criteriaItem.getName());
            ManagerFilterCriteriaView view = criteriaItem.createView();
            viewMap.put(criteriaItem.getName(), view);
            ManagerFilterCriteriaView selectedView = this.selectedCriteriaMap.get(criteriaItem.getName());
            String valuesAsString = null != selectedView ? selectedView.getValuesAsString() : settings.getProperty(prefix + criteriaItem.getName(), null);
            if (null == valuesAsString) continue;
            view.setValuesFromString(valuesAsString);
        }
        dlg.setCriteriaList(nameList, viewMap, EntityManagerFilterView.stringListToList(settings.getProperty("ActiveFilters:" + this.managerName, null)));
        dlg.setTitle(i18n.translateString("FiltersSelector"));
        dlg.setModal(true);
        dlg.pack();
        dlg.setLocationRelativeTo(parentWindow);
        dlg.setDefaultCloseOperation(2);
        dlg.resetResult();
        dlg.setVisible(true);
        if (dlg.isResultOK()) {
            List<String> activeCriteriaNames = dlg.getSelectedCriteriaNames();
            settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            settings.setProperty("ActiveFilters:" + this.managerName, EntityManagerFilterView.stringListToString(activeCriteriaNames));
            this.saveFilterValueSettings(settings, viewMap);
            ServiceRegistry.getSettingsService().updateSettings(settings);
            this.setFormCriteriaList(settings);
            managerView.getUI().revalidate();
            managerView.getUI().repaint();
            managerView.performQuery();
        }
    }

    private void saveFilterValueSettings(Settings settings, Map<String, ManagerFilterCriteriaView> criteriaMap) {
        if (null == criteriaMap) {
            return;
        }
        String prefix = "SelectedFilterValues:" + this.managerName + ":";
        for (String criteriaName : criteriaMap.keySet()) {
            settings.setProperty(prefix + criteriaName, criteriaMap.get(criteriaName).getValuesAsString());
        }
    }

    private static List<String> stringListToList(String listStr) {
        Vector<String> ret = new Vector<String>();
        if (null != listStr && listStr.length() > 0) {
            for (String token : listStr.split(":")) {
                ret.add(token);
            }
        }
        return ret;
    }

    private static String stringListToString(List<String> strList) {
        StringBuffer sb = new StringBuffer();
        for (String itemName : strList) {
            if (0 < sb.length()) {
                sb.append(":");
            }
            sb.append(itemName);
        }
        return sb.toString();
    }
}

