/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFilterSelectorDialog
extends JDialog {
    private JScrollPane scrollPane1;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel contentPane;
    private boolean resultOK;
    private Map<String, JCheckBox> criteriaCheckBoxes;
    private List<String> criteriaNameList;
    private Map<String, ManagerFilterCriteriaView> criteriaViewMap;

    public EntityManagerFilterSelectorDialog(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public EntityManagerFilterSelectorDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    public void setCriteriaList(List<String> criteriaNameList, Map<String, ManagerFilterCriteriaView> criteriaViewMap, List<String> selectedCriteriaNames) {
        this.criteriaNameList = criteriaNameList;
        this.criteriaViewMap = criteriaViewMap;
        this.initCriteriaComponents(selectedCriteriaNames);
    }

    public void resetResult() {
        this.resultOK = false;
    }

    public boolean isResultOK() {
        return this.resultOK;
    }

    public List<String> getSelectedCriteriaNames() {
        Vector<String> selectedCriteriaNames = new Vector<String>();
        for (String criteriaName : this.criteriaNameList) {
            if (!this.criteriaCheckBoxes.get(criteriaName).isSelected()) continue;
            selectedCriteriaNames.add(criteriaName);
        }
        return selectedCriteriaNames;
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.contentPane = new JPanel();
        CellConstraints cc = new CellConstraints();
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.scrollPane1.setViewportBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setBorder(null);
        this.dialogPane.setLayout((LayoutManager)new FormLayout("10dlu, default:grow, 10dlu", "10dlu, fill:default:grow, 12dlu, fill:default, 6dlu"));
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.GLUE_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerFilterSelectorDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityManagerFilterSelectorDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, cc.xy(2, 4));
        this.contentPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec("max(default;60dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded((Size)Sizes.DEFAULT, (Size)Sizes.dluX((int)180), (Size)Sizes.dluX((int)200)), 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.dialogPane.add((Component)this.contentPane, cc.xy(2, 2));
        this.scrollPane1.setViewportView(this.dialogPane);
        contentPane2.add((Component)this.scrollPane1, "Center");
    }

    private void initCriteriaComponents(List<String> selectedCriteriaNames) {
        if (null == this.criteriaViewMap || this.criteriaViewMap.isEmpty()) {
            return;
        }
        RowSpec rowspec = ((FormLayout)this.contentPane.getLayout()).getRowSpec(1);
        int rowSpecsToAdd = this.criteriaViewMap.size() - 1;
        for (int i = 0; i < rowSpecsToAdd; ++i) {
            ((FormLayout)this.contentPane.getLayout()).appendRow(rowspec);
        }
        this.criteriaCheckBoxes = new HashMap<String, JCheckBox>(this.criteriaViewMap.size());
        CellConstraints cc = new CellConstraints();
        for (int i = 0; i < this.criteriaNameList.size(); ++i) {
            String name = this.criteriaNameList.get(i);
            ManagerFilterCriteriaView view = this.criteriaViewMap.get(name);
            JCheckBox chkBox = new JCheckBox(view.getTitle());
            chkBox.setSelected(selectedCriteriaNames.contains(name));
            this.criteriaCheckBoxes.put(name, chkBox);
            this.contentPane.add((Component)chkBox, cc.xy(1, i + 1));
            this.contentPane.add((Component)view.getUI(), cc.xy(3, i + 1));
        }
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.resultOK = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

