/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.gui.manager.generic.FilterCriteriaBetweenDatesForm;
import com.bwanms.gui.manager.generic.FilterCriteriaBetweenValuesForm;
import com.bwanms.gui.manager.generic.FilterCriteriaCheckBoxForm;
import com.bwanms.gui.manager.generic.FilterCriteriaMultipleValuesForm;
import com.bwanms.gui.manager.generic.FilterCriteriaSingleValueForm;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaJoinClass;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.bwanms.ui.components.ComboItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFilterCriteriaView
implements ManagerFilterCriteriaView {
    public static final int CRITERIA_TYPE_LIKE = 1;
    public static final int CRITERIA_TYPE_EQUALS = 2;
    public static final int CRITERIA_TYPE_BETWEEN = 3;
    public static final int CRITERIA_TYPE_BETWEEN_DATES = 4;
    public static final int UI_TYPE_TEXT = 1;
    public static final int UI_TYPE_BETWEEN_TEXT = 2;
    public static final int UI_TYPE_COMBO = 3;
    public static final int UI_TYPE_SPINNER = 4;
    public static final int UI_TYPE_CHECKBOX = 5;
    public static final int UI_TYPE_TEXT_NONE = 6;
    public static final int UI_TYPE_BETWEEN_DATES = 7;
    public static final String filterDateFormat = "MM/dd/yyyy HH:mm:ss";
    private String name;
    private String title;
    private ManagerFilterCriteriaJoinClass joinClass;
    private String attribute;
    private int type;
    private int uiType;
    private List<Object> values;
    private boolean numeric;
    private boolean negation;
    private JComponent form = null;
    private ManagerFilterCriteriaTranslator translator;

    public EntityManagerFilterCriteriaView(String name, String title, ManagerFilterCriteriaJoinClass joinClass, String attribute, int type, int uiType, List<Object> values, boolean numeric, boolean negation) {
        this.name = name;
        this.title = title;
        this.joinClass = joinClass;
        this.attribute = attribute;
        this.type = type;
        this.uiType = uiType;
        this.values = values;
        this.numeric = numeric;
        this.negation = negation;
        this.createUI();
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public boolean isNegation() {
        return this.negation;
    }

    public int getType() {
        return this.type;
    }

    public List<Object> getSelectedValues() {
        Vector<Object> ret = new Vector<Object>();
        ret.addAll(this.getSelectedValuesAsStringList());
        return ret;
    }

    public Vector<String> getSelectedValuesAsStringList() {
        Vector<String> ret = new Vector<String>();
        switch (this.uiType) {
            case 1: {
                ret.add(((FilterCriteriaSingleValueForm)this.form).getTxtValue().getText());
                break;
            }
            case 6: {
                if (((FilterCriteriaSingleValueForm)this.form).getCheckBoxNone().isSelected()) {
                    ret.add(null);
                    break;
                }
                ret.add(((FilterCriteriaSingleValueForm)this.form).getTxtValue().getText());
                break;
            }
            case 3: {
                ComboItem selectedItem = (ComboItem)((FilterCriteriaMultipleValuesForm)this.form).getComboBoxValues().getSelectedItem();
                ret.add(selectedItem.getValue().toString());
                break;
            }
            case 2: {
                ret.add(((FilterCriteriaBetweenValuesForm)this.form).getTextValue1().getText());
                if (((FilterCriteriaBetweenValuesForm)this.form).getTextValue2().getText().equals("")) {
                    ((FilterCriteriaBetweenValuesForm)this.form).getTextValue2().setText(((FilterCriteriaBetweenValuesForm)this.form).getTextValue1().getText());
                }
                ret.add(((FilterCriteriaBetweenValuesForm)this.form).getTextValue2().getText());
                break;
            }
            case 7: {
                SimpleDateFormat dateFrom = new SimpleDateFormat(filterDateFormat);
                ret.add(dateFrom.format(((FilterCriteriaBetweenDatesForm)this.form).getDateChooserFrom().getDate()));
                ret.add(dateFrom.format(((FilterCriteriaBetweenDatesForm)this.form).getDateChooserTo().getDate()));
                break;
            }
            case 5: {
                if (((FilterCriteriaCheckBoxForm)this.form).getCheckBox().isSelected()) {
                    ret.add("1");
                    break;
                }
                ret.add("0");
                break;
            }
            default: {
                throw new RuntimeException("UI TYPE " + this.uiType + " NOT YET IMPLEMENTED!");
            }
        }
        return ret;
    }

    @Override
    public JComponent getUI() {
        return this.form;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getConditionToken(String alias) throws InvalidFilterValueException {
        List<Object> selectedValues = this.getSelectedValues();
        if (null != this.translator) {
            selectedValues = this.translator.translateFilterValues(selectedValues);
        }
        String condition = null;
        String attrib = alias + "." + this.attribute;
        switch (this.type) {
            case 2: {
                String text = selectedValues.get(0).toString();
                if (this.numeric) {
                    condition = attrib + (this.negation ? " <> " : " = ") + text.trim();
                    break;
                }
                text = text.replace("'", "''");
                condition = " upper(" + attrib + ")" + (this.negation ? " <> " : " = ") + "upper(" + "'" + text + "'" + ")";
                if (!"".equals(text.trim())) break;
                condition = condition + (this.negation ? " and " : " or ") + attrib + (this.negation ? " is not null" : " is null");
                break;
            }
            case 1: {
                if (null != selectedValues.get(0)) {
                    String text = selectedValues.get(0).toString();
                    text = text.replace("/", "//");
                    text = text.replace("%", "/%");
                    text = text.replace("_", "/_");
                    text = text.replace("'", "''");
                    condition = " upper(" + attrib + ")" + (this.negation ? " not like " : " like ") + "upper(" + "'" + text.replace('*', '%') + "'" + ")" + " escape '/'";
                    break;
                }
                String baseAttribute = this.attribute;
                int idxOfDot = baseAttribute.indexOf(".");
                if (idxOfDot != -1) {
                    baseAttribute = this.attribute.substring(0, idxOfDot);
                }
                condition = alias + '.' + baseAttribute + (this.negation ? " is not null" : " is null");
                break;
            }
            case 3: {
                String t1 = selectedValues.get(0).toString();
                String t2 = selectedValues.get(1).toString();
                if (this.numeric) {
                    t1 = t1.trim();
                    t2 = t2.trim();
                    if ("".equals(t1)) {
                        condition = "".equals(t2) ? attrib + " is null" : attrib + " <= " + t2;
                        break;
                    }
                    condition = "".equals(t2) ? attrib + " >= " + t1 : attrib + " between " + t1 + " and " + t2;
                    break;
                }
                if ("".equals(t1)) {
                    condition = "".equals(t2) ? attrib + " is null" : "upper(" + attrib + ") " + "<=" + " upper('" + t2 + "')";
                    break;
                }
                condition = "".equals(t2) ? "upper(" + attrib + ")" + " >= " + "upper('" + t1 + "')" : "upper(" + attrib + ")" + " between " + "upper('" + t1 + "')" + " and " + "upper( '" + t2 + "')";
                break;
            }
            case 4: {
                String d1 = selectedValues.get(0).toString().trim();
                String d2 = selectedValues.get(1).toString().trim();
                condition = "".equals(d1) ? ("".equals(d2) ? attrib + " is null" : attrib + " <= " + this.lastMilli(d2)) : ("".equals(d2) ? attrib + " >= " + d1 : attrib + " between " + d1 + " and " + this.lastMilli(d2));
            }
        }
        return condition;
    }

    private String lastMilli(String timestamp) {
        return timestamp.substring(0, timestamp.length() - 3) + "999";
    }

    @Override
    public String getValuesAsString() {
        Vector<String> selectedValues = this.getSelectedValuesAsStringList();
        StringBuffer sb = new StringBuffer();
        for (String value : selectedValues) {
            sb.append(null != value ? Integer.valueOf(value.length()) : "-1");
            sb.append(':');
            if (null == value) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public void setValuesFromString(String valuesAsString) {
        Vector<String> selectedValues = new Vector<String>();
        int i = 0;
        while (i < valuesAsString.length()) {
            int semiColonIdx = valuesAsString.indexOf(58, i);
            int len = new Integer(valuesAsString.substring(i, semiColonIdx));
            i = semiColonIdx + 1;
            if (len >= 0) {
                selectedValues.add(valuesAsString.substring(i, i + len));
                i += len;
                continue;
            }
            selectedValues.add(null);
        }
        this.updateUI(selectedValues);
    }

    private void createUI() {
        switch (this.uiType) {
            case 1: {
                this.form = new FilterCriteriaSingleValueForm("");
                break;
            }
            case 6: {
                this.form = new FilterCriteriaSingleValueForm("", true);
                break;
            }
            case 2: {
                this.form = new FilterCriteriaBetweenValuesForm("", "");
                break;
            }
            case 7: {
                long date = System.currentTimeMillis();
                this.form = new FilterCriteriaBetweenDatesForm(date, date);
                break;
            }
            case 3: {
                this.form = new FilterCriteriaMultipleValuesForm(this.values);
                break;
            }
            case 5: {
                this.form = new FilterCriteriaCheckBoxForm();
                break;
            }
            default: {
                throw new RuntimeException("UI TYPE " + this.uiType + " NOT YET IMPLEMENTED!");
            }
        }
    }

    private void updateUI(List<String> selectedValues) {
        switch (this.uiType) {
            case 1: 
            case 6: {
                String val = selectedValues.get(0);
                if (null != val) {
                    ((FilterCriteriaSingleValueForm)this.form).getTxtValue().setText(val);
                    break;
                }
                ((FilterCriteriaSingleValueForm)this.form).getCheckBoxNone().setSelected(true);
                break;
            }
            case 2: {
                if (2 != selectedValues.size()) break;
                ((FilterCriteriaBetweenValuesForm)this.form).getTextValue1().setText(selectedValues.get(0));
                if (selectedValues.get(1).equals("")) {
                    ((FilterCriteriaBetweenValuesForm)this.form).getTextValue2().setText(selectedValues.get(0));
                    break;
                }
                ((FilterCriteriaBetweenValuesForm)this.form).getTextValue2().setText(selectedValues.get(1));
                break;
            }
            case 7: {
                if (2 != selectedValues.size()) break;
                ((FilterCriteriaBetweenDatesForm)this.form).getDateChooserFrom().setDate(new Date(selectedValues.get(0)));
                if (selectedValues.get(1).equals("")) {
                    ((FilterCriteriaBetweenDatesForm)this.form).getDateChooserTo().setDate(new Date(selectedValues.get(0)));
                    break;
                }
                ((FilterCriteriaBetweenDatesForm)this.form).getDateChooserTo().setDate(new Date(selectedValues.get(1)));
                break;
            }
            case 3: {
                ComboItem selectedItem = ComboItem.findItemByStringValue(((FilterCriteriaMultipleValuesForm)this.form).getComboBoxValues(), selectedValues.get(0));
                if (null == selectedItem) break;
                ((FilterCriteriaMultipleValuesForm)this.form).getComboBoxValues().setSelectedItem(selectedItem);
                break;
            }
            case 5: {
                boolean checked = "1".equals(selectedValues.get(0));
                ((FilterCriteriaCheckBoxForm)this.form).getCheckBox().setSelected(checked);
                break;
            }
            default: {
                throw new RuntimeException("UI TYPE " + this.uiType + " NOT YET IMPLEMENTED!");
            }
        }
    }

    public ManagerFilterCriteriaTranslator getTranslator() {
        return this.translator;
    }

    public void setTranslator(ManagerFilterCriteriaTranslator translator) {
        this.translator = translator;
    }

    @Override
    public ManagerFilterCriteriaJoinClass getConditionClass() {
        return this.joinClass;
    }
}

