/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager.generic;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.manager.ManagerCacheStrategy;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerCacheStrategy;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerFilterView;
import com.bwanms.gui.manager.generic.EntityManagerNavigatorView;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.ui.components.ComboItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityManagerConfig {
    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    public ManagerCacheStrategy getManagerCacheStrategy() {
        return new EntityManagerCacheStrategy();
    }

    public ManagerFilterView getFilterView() {
        return new EntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider());
    }

    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView(new EntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles()), this.getColumns());
    }

    public NavigatorView getNavigatorView() {
        return new EntityManagerNavigatorView(this.getPageSize());
    }

    public SortView getSortView() {
        return null;
    }

    public String[] getColumnTitles() {
        String[] ret = new String[this.getColumns().size()];
        int i = 0;
        for (EntityManagerColumn column : this.getColumns()) {
            ret[i++] = column.getTitle();
        }
        return ret;
    }

    protected String getManagerName() {
        return this.getBaseName();
    }

    public int getPageSize() {
        return 100;
    }

    protected abstract String getBaseName();

    public abstract List<EntityManagerColumn> getColumns();

    public abstract EntityManagerRowProvider getEntityRowProvider();

    protected abstract List<ManagerFilterCriteria> getFilterCriteria();

    public abstract List<ManagerAction> getDeclaredActions();

    public abstract ManagerAction getDefaultAction();

    public static List<String> getColumnAttributeNames(List<EntityManagerColumn> columns) {
        ArrayList<String> ret = new ArrayList<String>(columns.size());
        for (EntityManagerColumn column : columns) {
            ret.add(column.getAttribute());
        }
        return ret;
    }

    public abstract String getTitle();

    public abstract String getHelpTopic();

    protected Vector<Object> sortComboItems(Vector<Object> items) {
        if (null == items) {
            return null;
        }
        Vector<ComboItem> ciItems = new Vector<ComboItem>(items.size());
        for (Object object : items) {
            ciItems.add((ComboItem)object);
        }
        Collections.sort(ciItems, ComboItem.getTextComparator());
        items.clear();
        for (ComboItem comboItem : ciItems) {
            items.add(comboItem);
        }
        return items;
    }
}

