/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.manager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySession;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.manager.FilterView;
import com.bwanms.gui.manager.ManagerCacheStrategy;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.ResultsView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.platform.UIEventThread;
import java.io.Serializable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerMediator {
    private static Logger logger = Logger.getLogger(ManagerMediator.class);
    private ResultsView resultsView;
    private FilterView filterView;
    private NavigatorView navigatorView;
    private SortView sortView;
    private EntityQuerySession session;
    private ManagerCacheStrategy cacheStrategy;
    private EntityQueryStrategy queryStrategy;
    private boolean refreshQuery;

    public ManagerMediator(EntityQueryStrategy queryStrategy, ManagerCacheStrategy cacheStrategy, ResultsView resultsView, FilterView filterView, NavigatorView navigatorView, SortView sortView) {
        this.queryStrategy = queryStrategy;
        this.cacheStrategy = cacheStrategy;
        this.resultsView = resultsView;
        this.filterView = filterView;
        this.navigatorView = navigatorView;
        this.sortView = sortView;
        this.refreshSession();
    }

    private void refreshSession() {
        this.session = ServiceRegistry.getEntityQuerySession();
        this.session.setQueryStrategy(this.queryStrategy);
        this.refreshQuery = true;
    }

    public void close() {
        this.session.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"EntityQuerySession closed.");
        }
    }

    public void setPageSize(int pageSize) {
    }

    public synchronized void pageChanged(int pageNumber) {
        if (this.refreshQuery) {
            this.performQuery(pageNumber);
        } else {
            EntityQueryResults results;
            EntityQueryResults entityQueryResults = results = null != this.cacheStrategy ? this.cacheStrategy.getPage(pageNumber) : null;
            if (null == results) {
                try {
                    results = this.session.getPage(pageNumber);
                }
                catch (Throwable t) {
                    this.refreshSession();
                    logger.debug((Object)("Query session refreshed !!!  performing new query.    - message: " + t.getMessage()));
                    this.performQuery(pageNumber);
                    return;
                }
            }
            this.updateFromResults(results);
        }
    }

    public synchronized void performQuery() {
        this.performQuery(0);
    }

    private void performQuery(int pageNumber) {
        EntityQueryFilter filter = null != this.filterView ? this.filterView.getFilter() : null;
        EntityQuerySort sort = null != this.sortView ? this.sortView.getSort() : null;
        int pageSize = null != this.navigatorView ? this.navigatorView.getPageSize() : 0;
        EntityQueryResults results = null;
        try {
            results = this.session.performQuery(filter, sort, pageSize, pageNumber);
            this.refreshQuery = false;
        }
        catch (Throwable t) {
            boolean performNewQuery = !this.refreshQuery;
            this.refreshSession();
            logger.debug((Object)("Query session refreshed !!!  performing new query.    - message: " + t.getMessage()));
            if (performNewQuery) {
                this.performQuery(pageNumber);
                return;
            }
            logger.error((Object)t, t);
        }
        this.updateFromResults(results);
    }

    private void updateFromResults(final EntityQueryResults results) {
        if (null != results) {
            if (null != this.cacheStrategy) {
                this.cacheStrategy.queryPerformed(results);
            }
        } else {
            throw new RuntimeException("Query error occured!");
        }
        UIEventThread.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ResultsView resultsView = ManagerMediator.this.resultsView;
                synchronized (resultsView) {
                    ManagerMediator.this.resultsView.setEntityQueryResults(results);
                    ManagerMediator.this.navigatorView.setEntityQueryResults(results);
                }
            }
        });
    }

    public EntityManagerRow fetchRow(Class<? extends Serializable> clazz, Serializable id) {
        EntityManagerRow ret = null;
        try {
            ret = this.session.getRow(clazz, id);
            this.refreshQuery = false;
        }
        catch (Throwable t) {
            boolean performNewQuery = !this.refreshQuery;
            this.refreshSession();
            logger.debug((Object)("Query session refreshed !!!  performing new query.    - message: " + t.getMessage()));
            if (performNewQuery) {
                return this.fetchRow(clazz, id);
            }
            logger.error((Object)t, t);
        }
        return ret;
    }
}

