/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.EntityListView;
import com.bwanms.gui.managednetwork.NetworkIpAddressRangesPanel;
import com.bwanms.model.Location;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FormUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkIpAddressRangesView
implements EntityListView<NetworkIpAddressRange> {
    private NetworkIpAddressRangesPanel component = new NetworkIpAddressRangesPanel();

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return "IpAddressRanges";
    }

    @Override
    public void updateList(List<NetworkIpAddressRange> list) {
        EntityManagerTableModel<NetworkIpAddressRange> tableModel = this.component.getTableModel();
        FormUtil.stopTableEditing(this.component.getTable());
        tableModel.clearTable();
        for (NetworkIpAddressRange community : list) {
            tableModel.addRow(community, String.valueOf(community.getId()));
        }
        this.component.getController().controlTableButtons();
    }

    @Override
    public List<NetworkIpAddressRange> addListToMap(Map<Serializable, Boolean> map) {
        EntityManagerTableModel<NetworkIpAddressRange> model = this.component.getTableModel();
        FormUtil.stopTableEditing(this.component.getTable());
        ArrayList<NetworkIpAddressRange> list = new ArrayList<NetworkIpAddressRange>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            NetworkIpAddressRange entry = new NetworkIpAddressRange();
            switch (model.getRowState(i)) {
                case 3: {
                    entry = model.getEntity(i);
                    this.setValuesForEntry(i, entry);
                    map.put(entry, false);
                    break;
                }
                case 2: {
                    entry = new NetworkIpAddressRange();
                    this.setValuesForEntry(i, entry);
                    map.put(entry, false);
                    break;
                }
                case 1: {
                    entry = model.getEntity(i);
                    map.put(entry, true);
                    break;
                }
                case 0: {
                    entry = model.getEntity(i);
                }
            }
            list.add(entry);
        }
        return list;
    }

    private void setValuesForEntry(int row, NetworkIpAddressRange entry) {
        EntityManagerTableModel<NetworkIpAddressRange> model = this.component.getTableModel();
        int col = 0;
        entry.setType((Integer)model.getValueAt(row, col++));
        entry.setStartIp((String)model.getValueAt(row, col++));
        entry.setEndIp((String)model.getValueAt(row, col++));
        entry.setEnableDiscovery((Boolean)model.getValueAt(row, col++));
        entry.setEnableAutoDiscovery((Boolean)model.getValueAt(row, col++));
        entry.setReadCommunity((String)model.getValueAt(row, col++));
        entry.setWriteCommunity((String)model.getValueAt(row, col++));
        entry.setLocation((Location)model.getValueAt(row, col++));
    }

    public boolean isEmpty() {
        return this.component.getController().isEmpty();
    }

    public boolean isChanged() {
        return this.component.getController().isChanged();
    }
}

