/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.managednetwork.ManagedNetworkApplication;
import com.bwanms.gui.managednetwork.NetworkIpAddressRangesPanel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TableUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class NetworkIpAddressRangesPanelController
extends SimpleRowTableModelPanelController {
    private NetworkIpAddressRangesPanel panel;
    private static final Logger log = Logger.getLogger(NetworkIpAddressRangesPanelController.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NetworkIpAddressRangesPanelController.class);

    public NetworkIpAddressRangesPanelController(NetworkIpAddressRangesPanel panel) {
        this.panel = panel;
    }

    public void importFromFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new ManagedNetworkApplication.PrivateFileFilter());
        int returnVal = chooser.showOpenDialog(this.panel);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            StringBuffer contentBuffer = new StringBuffer();
            try {
                FileReader reader = new FileReader(file);
                int count = 0;
                char[] set = new char[256];
                while ((count = reader.read(set)) >= 0) {
                    contentBuffer.append(set, 0, count);
                }
            }
            catch (IOException e) {
                log.debug((Object)"", (Throwable)e);
                String message = ExceptionUtil.getMessage(e);
                message = message == null ? i18n.translateString("ImportError", file.getAbsolutePath()) : i18n.translateString("IOError", message);
                MessageBox.Error.quickShow(this.panel, message);
                return;
            }
            ManagedNetworkApplication.importData(contentBuffer.toString());
        }
    }

    public void exportToFile() {
        ManagedNetworkApplication.exportToFile();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.panel.getTableModel().getRowCount(); ++i) {
            if (this.panel.getTableModel().getRowState(i) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        for (int i = 0; i < this.panel.getTableModel().getRowCount(); ++i) {
            if (this.panel.getTableModel().getRowState(i) == 0) continue;
            return true;
        }
        return false;
    }

    protected SimpleRowTableModel getTableModel() {
        return this.panel.getTableModel();
    }

    protected JTable getTable() {
        return this.panel.getTable();
    }

    protected JButton getDeleteButton() {
        return this.panel.getBtnDelete();
    }

    protected JButton getRevertButton() {
        return this.panel.getBtnRevert();
    }

    public void controlTableButtons() {
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length > 0) {
            this.panel.getBtnExport().setEnabled(true);
        } else {
            this.panel.getBtnExport().setEnabled(false);
        }
        super.controlTableButtons();
    }

    public void btnAddMouseClicked() {
        super.btnAddMouseClicked();
        TableUtil.selectAndScrollToRow(this.getTable(), this.getTableModel().getRowCount() - 1);
    }
}

