/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.managednetwork.NetworkIpAddressRangesPanelController;
import com.bwanms.model.Location;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IpAddress;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkIpAddressRangesPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NetworkIpAddressRangesPanel.class);
    private NetworkIpAddressRangesPanelController controller;
    private EntityManagerTableModel<NetworkIpAddressRange> tableModel;
    private JButton btnAdd;
    private JButton btnRevert;
    private JButton btnDelete;
    private JButton btnImport;
    private JButton btnExport;
    private JScrollPane scrollPane2;
    private JTable table;

    public NetworkIpAddressRangesPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent(this);
        this.controller = new NetworkIpAddressRangesPanelController(this);
        ComboItem[] items = new ComboItem[]{new ComboItem(0, i18n.translateString("IpRange")), new ComboItem(1, i18n.translateString("Subnet"))};
        this.tableModel = new EntityManagerTableModel<NetworkIpAddressRange>(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), Integer.class, items), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Start"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("End/Subnet"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Discovery"), Boolean.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AutoDiscovery"), Boolean.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ReadCommunity"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("WriteCommunity"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Location"), Location.class)}){
            private int lastSorted;
            private int dir;

            @Override
            public void setRowValues(int row, NetworkIpAddressRange entity) {
                int col = 0;
                this.setInitialValueAt(entity.getType(), row, col++);
                this.setInitialValueAt(entity.getStartIp(), row, col++);
                this.setInitialValueAt(entity.getEndIp(), row, col++);
                this.setInitialValueAt(entity.getEnableDiscovery(), row, col++);
                this.setInitialValueAt(entity.getEnableAutoDiscovery(), row, col++);
                this.setInitialValueAt(entity.getReadCommunity(), row, col++);
                this.setInitialValueAt(entity.getWriteCommunity(), row, col++);
                this.setInitialValueAt(entity.getLocation(), row, col++);
            }

            @Override
            public void sortByColumn(final int modelIndex) {
                if (this.lastSorted == modelIndex) {
                    this.dir *= -1;
                } else {
                    this.dir = 1;
                    this.lastSorted = modelIndex;
                }
                ArrayList temp = new ArrayList();
                temp.addAll(this.getEntities());
                Collections.sort(temp, new Comparator<NetworkIpAddressRange>(){

                    @Override
                    public int compare(NetworkIpAddressRange o1, NetworkIpAddressRange o2) {
                        switch (modelIndex) {
                            case 0: {
                                return dir * o1.getType().compareTo(o2.getType());
                            }
                            case 1: {
                                return dir * this.getIpLongFromString(o1.getStartIp()).compareTo(this.getIpLongFromString(o2.getStartIp()));
                            }
                            case 2: {
                                return dir * this.getIpLongFromString(o1.getEndIp()).compareTo(this.getIpLongFromString(o2.getEndIp()));
                            }
                            case 3: {
                                if (o1.getEnableDiscovery() == null && o2.getEnableDiscovery() == null) {
                                    return 0;
                                }
                                if (o1.getEnableDiscovery() == null && o2.getEnableDiscovery() != null) {
                                    return dir;
                                }
                                if (o1.getEnableDiscovery() != null && o2.getEnableDiscovery() == null) {
                                    return dir * -1;
                                }
                                return dir * o1.getEnableDiscovery().compareTo(o2.getEnableDiscovery());
                            }
                            case 4: {
                                if (o1.getEnableAutoDiscovery() == null && o2.getEnableAutoDiscovery() == null) {
                                    return 0;
                                }
                                if (o1.getEnableAutoDiscovery() == null && o2.getEnableAutoDiscovery() != null) {
                                    return dir;
                                }
                                if (o1.getEnableAutoDiscovery() != null && o2.getEnableAutoDiscovery() == null) {
                                    return dir * -1;
                                }
                                return dir * o1.getEnableAutoDiscovery().compareTo(o2.getEnableAutoDiscovery());
                            }
                            case 5: {
                                return dir * o1.getReadCommunity().compareTo(o2.getReadCommunity());
                            }
                            case 6: {
                                return dir * o1.getWriteCommunity().compareTo(o2.getWriteCommunity());
                            }
                            case 7: {
                                if (o1.getLocation() == null && o2.getLocation() == null) {
                                    return 0;
                                }
                                if (o1.getLocation() == null && o2.getLocation() != null) {
                                    return dir;
                                }
                                if (o1.getLocation() != null && o2.getLocation() == null) {
                                    return dir * -1;
                                }
                                return dir * o1.getLocation().getName().compareTo(o2.getLocation().getName());
                            }
                        }
                        return 0;
                    }

                    private Long getIpLongFromString(String ip) {
                        return new IpAddress(ip).getIpAddress();
                    }
                });
                ArrayList<SimpleRowTableModel.TableRow> newRows = new ArrayList<SimpleRowTableModel.TableRow>();
                for (int i = this.getEntities().size(); i < this.rows.size(); ++i) {
                    newRows.add(this.getTableRow(i));
                }
                this.clearTable();
                for (NetworkIpAddressRange range : temp) {
                    this.addRow(range, String.valueOf(range.getId()));
                }
                for (SimpleRowTableModel.TableRow row : newRows) {
                    this.addTableRow(row);
                }
            }
        };
        SimpleRowTable srTable = new SimpleRowTable(this.table, this.tableModel);
        srTable.setComboCellEditor(0);
        srTable.setSelectorCellEditor(7);
        this.btnRevert.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnExport.setEnabled(false);
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnRevert = new JButton();
        this.btnDelete = new JButton();
        this.btnImport = new JButton();
        this.btnExport = new JButton();
        this.scrollPane2 = new JScrollPane();
        this.table = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45))}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.MINIMUM, 1.0)}));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkIpAddressRangesPanel.this.btnAddActionPerformed(e);
            }
        });
        this.add((Component)this.btnAdd, cc.xy(3, 1));
        this.btnRevert.setText("Revert");
        this.btnRevert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkIpAddressRangesPanel.this.btnRevertActionPerformed(e);
            }
        });
        this.add((Component)this.btnRevert, cc.xy(5, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkIpAddressRangesPanel.this.btnDeleteActionPerformed(e);
            }
        });
        this.add((Component)this.btnDelete, cc.xy(7, 1));
        this.btnImport.setText("Import");
        this.btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkIpAddressRangesPanel.this.btnImportActionPerformed(e);
            }
        });
        this.add((Component)this.btnImport, cc.xy(9, 1));
        this.btnExport.setText("Export");
        this.btnExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkIpAddressRangesPanel.this.btnExportActionPerformed(e);
            }
        });
        this.add((Component)this.btnExport, cc.xy(11, 1));
        this.table.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NetworkIpAddressRangesPanel.this.tableKeyReleased(e);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                NetworkIpAddressRangesPanel.this.tableMouseReleased(e);
            }
        });
        this.scrollPane2.setViewportView(this.table);
        this.add((Component)this.scrollPane2, cc.xywh(1, 3, 11, 1));
    }

    private void tableKeyReleased(KeyEvent e) {
        this.controller.controlTableButtons();
    }

    private void btnAddActionPerformed(ActionEvent e) {
        this.controller.btnAddMouseClicked();
    }

    private void btnDeleteActionPerformed(ActionEvent e) {
        this.controller.btnDeleteMouseClicked();
    }

    private void btnImportActionPerformed(ActionEvent e) {
        this.controller.importFromFile();
    }

    private void btnExportActionPerformed(ActionEvent e) {
        this.controller.exportToFile();
    }

    private void btnRevertActionPerformed(ActionEvent e) {
        this.controller.btnRevertMouseClicked();
    }

    private void tableMouseReleased(MouseEvent e) {
        this.controller.controlTableButtons();
    }

    public EntityManagerTableModel<NetworkIpAddressRange> getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getBtnDelete() {
        return this.btnDelete;
    }

    public JButton getBtnRevert() {
        return this.btnRevert;
    }

    public JButton getBtnExport() {
        return this.btnExport;
    }

    public NetworkIpAddressRangesPanelController getController() {
        return this.controller;
    }
}

