/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.EntityListView;
import com.bwanms.gui.managednetwork.NetworkCommunitiesPanel;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FormUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkCommunitiesView
implements EntityListView<NetworkSNMPCommunity> {
    private NetworkCommunitiesPanel component = new NetworkCommunitiesPanel();

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return "NetworkCommunities";
    }

    @Override
    public void updateList(List<NetworkSNMPCommunity> list) {
        EntityManagerTableModel<NetworkSNMPCommunity> tableModel = this.component.getTableModel();
        FormUtil.stopTableEditing(this.component.getTable());
        tableModel.clearTable();
        for (NetworkSNMPCommunity community : list) {
            tableModel.addRow(community, String.valueOf(community.getId()));
        }
    }

    @Override
    public List<NetworkSNMPCommunity> addListToMap(Map<Serializable, Boolean> map) {
        ArrayList<NetworkSNMPCommunity> list = new ArrayList<NetworkSNMPCommunity>();
        EntityManagerTableModel<NetworkSNMPCommunity> model = this.component.getTableModel();
        FormUtil.stopTableEditing(this.component.getTable());
        for (int i = 0; i < model.getRowCount(); ++i) {
            NetworkSNMPCommunity entry = new NetworkSNMPCommunity();
            switch (model.getRowState(i)) {
                case 3: {
                    entry = model.getEntity(i);
                    entry.setReadCommunity((String)model.getValueAt(i, 0));
                    entry.setWriteCommunity((String)model.getValueAt(i, 1));
                    map.put(entry, false);
                    break;
                }
                case 2: {
                    entry = new NetworkSNMPCommunity();
                    entry.setReadCommunity((String)model.getValueAt(i, 0));
                    entry.setWriteCommunity((String)model.getValueAt(i, 1));
                    map.put(entry, false);
                    break;
                }
                case 1: {
                    entry = model.getEntity(i);
                    map.put(entry, true);
                    break;
                }
                case 0: {
                    entry = model.getEntity(i);
                }
            }
            list.add(entry);
        }
        return list;
    }

    public boolean isChanged() {
        return this.component.getController().isChanged();
    }
}

