/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.managednetwork.NetworkCommunitiesPanelController;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkCommunitiesPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NetworkCommunitiesPanel.class);
    private NetworkCommunitiesPanelController controller;
    private EntityManagerTableModel<NetworkSNMPCommunity> tableModel;
    private JButton btnAdd;
    private JButton btnRevert;
    private JButton btnDelete;
    private JScrollPane scrollPane2;
    private JTable table;

    public NetworkCommunitiesPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent(this);
        this.controller = new NetworkCommunitiesPanelController(this);
        this.tableModel = new EntityManagerTableModel<NetworkSNMPCommunity>(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ReadCommunity"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("WriteCommunity"), String.class)}){
            private int lastSorted;
            private int dir;

            @Override
            public void setRowValues(int row, NetworkSNMPCommunity entity) {
                int col = 0;
                this.setInitialValueAt(entity.getReadCommunity(), row, col++);
                this.setInitialValueAt(entity.getWriteCommunity(), row, col++);
            }

            @Override
            public void sortByColumn(final int modelIndex) {
                if (this.lastSorted == modelIndex) {
                    this.dir *= -1;
                } else {
                    this.dir = 1;
                    this.lastSorted = modelIndex;
                }
                ArrayList temp = new ArrayList();
                temp.addAll(this.getEntities());
                Collections.sort(temp, new Comparator<NetworkSNMPCommunity>(){

                    @Override
                    public int compare(NetworkSNMPCommunity o1, NetworkSNMPCommunity o2) {
                        switch (modelIndex) {
                            case 0: {
                                return dir * o1.getReadCommunity().compareTo(o2.getReadCommunity());
                            }
                            case 1: {
                                return dir * o1.getWriteCommunity().compareTo(o2.getWriteCommunity());
                            }
                        }
                        return 0;
                    }
                });
                ArrayList<SimpleRowTableModel.TableRow> newRows = new ArrayList<SimpleRowTableModel.TableRow>();
                for (int i = this.getEntities().size(); i < this.rows.size(); ++i) {
                    newRows.add(this.getTableRow(i));
                }
                this.clearTable();
                for (NetworkSNMPCommunity range : temp) {
                    this.addRow(range, String.valueOf(range.getId()));
                }
                for (SimpleRowTableModel.TableRow row : newRows) {
                    this.addTableRow(row);
                }
            }
        };
        SimpleRowTable srTable = new SimpleRowTable(this.table, this.tableModel);
        this.table.setSelectionMode(2);
        this.btnRevert.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnRevert = new JButton();
        this.btnDelete = new JButton();
        this.scrollPane2 = new JScrollPane();
        this.table = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45))}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.MINIMUM, 1.0)}));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkCommunitiesPanel.this.btnAddActionPerformed(e);
            }
        });
        this.add((Component)this.btnAdd, cc.xy(5, 1));
        this.btnRevert.setText("Revert");
        this.btnRevert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkCommunitiesPanel.this.btnRevertActionPerformed(e);
            }
        });
        this.add((Component)this.btnRevert, cc.xy(7, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkCommunitiesPanel.this.btnDeleteActionPerformed(e);
            }
        });
        this.add((Component)this.btnDelete, cc.xy(9, 1));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                NetworkCommunitiesPanel.this.tableMouseReleased(e);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NetworkCommunitiesPanel.this.tableKeyReleased(e);
            }
        });
        this.scrollPane2.setViewportView(this.table);
        this.add((Component)this.scrollPane2, cc.xywh(1, 3, 9, 1));
    }

    private void tableKeyReleased(KeyEvent e) {
        this.controller.controlTableButtons();
    }

    private void btnAddActionPerformed(ActionEvent e) {
        this.controller.btnAddMouseClicked();
    }

    private void btnDeleteActionPerformed(ActionEvent e) {
        this.controller.btnDeleteMouseClicked();
    }

    private void btnRevertActionPerformed(ActionEvent e) {
        this.controller.btnRevertMouseClicked();
    }

    private void tableMouseReleased(MouseEvent e) {
        this.controller.controlTableButtons();
    }

    public EntityManagerTableModel<NetworkSNMPCommunity> getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getBtnDelete() {
        return this.btnDelete;
    }

    public JButton getBtnRevert() {
        return this.btnRevert;
    }

    public NetworkCommunitiesPanelController getController() {
        return this.controller;
    }
}

