/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.managednetwork;

import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.gui.locationmanager.LocationMapAssembly;
import com.bwanms.gui.managednetwork.GenericTabbedPanel;
import com.bwanms.gui.managednetwork.NetworkCommunitiesPanel;
import com.bwanms.gui.managednetwork.NetworkCommunitiesView;
import com.bwanms.gui.managednetwork.NetworkIpAddressRangesPanel;
import com.bwanms.gui.managednetwork.NetworkIpAddressRangesView;
import com.bwanms.model.EditorContainer;
import com.bwanms.model.Location;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.NetworkSNMPCommunity;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.MessageBox;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedNetworkApplication
implements EditorContainer,
View {
    private static final Logger log = Logger.getLogger(ManagedNetworkApplication.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ManagedNetworkApplication.class);
    private static GenericTabbedPanel mainPanel;
    private static NetworkIpAddressRangesView rangesView;
    private static NetworkCommunitiesView communitiesView;
    private static JFrame frame;
    private static InvalidValuesUtil invalidValuesUtil;
    private static List<InvalidValue> invalidValues;
    private static Set<Integer> invalidRows;

    public ManagedNetworkApplication() {
        JFrame frame = FrameUtil.createFrame();
        if (ManagedNetworkApplication.frame == null) {
            ManagedNetworkApplication.frame = frame;
            mainPanel = new GenericTabbedPanel(this);
            mainPanel.addTab(i18n.translateString("NetworkIpAddressRanges"), rangesView.getUI());
            mainPanel.addTab(i18n.translateString("NetworkCommunities"), communitiesView.getUI());
            mainPanel.getErrorReportEditorPane1().setTitle(i18n.translateString("ManagedNetworkApplication"));
            this.addTableSorting();
            mainPanel.getBtnHelp().setAction(new HelpAction(this.getHelpTopic()));
            mainPanel.getBtnHelp().setText("");
            if (!Security.getSecurity().checkPermissions("Av:ManagedNetwork", "delete")) {
                mainPanel.getBtnOK().setEnabled(false);
            }
            ManagedNetworkApplication.refresh();
        } else {
            frame = ManagedNetworkApplication.frame;
            ManagedNetworkApplication.refresh();
        }
    }

    private void addTableSorting() {
        final NetworkIpAddressRangesPanel ui = (NetworkIpAddressRangesPanel)rangesView.getUI();
        ui.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                int column = ui.getTable().getTableHeader().columnAtPoint(new Point(arg0.getX(), arg0.getY()));
                TableColumn tblColumn = ui.getTable().getTableHeader().getColumnModel().getColumn(column);
                ui.getTableModel().sortByColumn(tblColumn.getModelIndex());
            }
        });
        final NetworkCommunitiesPanel ui2 = (NetworkCommunitiesPanel)communitiesView.getUI();
        ui2.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                int column = ui2.getTable().getTableHeader().columnAtPoint(new Point(arg0.getX(), arg0.getY()));
                TableColumn tblColumn = ui2.getTable().getTableHeader().getColumnModel().getColumn(column);
                ui2.getTableModel().sortByColumn(tblColumn.getModelIndex());
            }
        });
    }

    private static void updateCommunities() {
        List<NetworkSNMPCommunity> communities = ServiceRegistry.getEntityManagerService().retrieveAll(NetworkSNMPCommunity.class);
        communitiesView.updateList(communities);
    }

    private static void updateRanges() {
        List<NetworkIpAddressRange> ranges = ServiceRegistry.getEntityManagerService().retrieveAll(NetworkIpAddressRange.class);
        rangesView.updateList(ranges);
    }

    @Override
    public JPanel getUI() {
        return mainPanel;
    }

    @Override
    public void okActionPerformed() {
        try {
            HashMap<Serializable, Boolean> map = new HashMap<Serializable, Boolean>();
            if (ManagedNetworkApplication.save(map, true)) {
                ServiceRegistry.getEntityManagerService().saveOrDeleteAll(map);
                ManagedNetworkApplication.refresh();
            }
        }
        catch (ServiceException e) {
            log.error((Object)"Failed to save or delete entities.", (Throwable)e);
        }
    }

    private static boolean save(Map<Serializable, Boolean> map, boolean useCommunities) {
        invalidValuesUtil.clearReportedInvalidValues(invalidValues);
        int i = 0;
        for (NetworkIpAddressRange range : rangesView.addListToMap(map)) {
            ManagedNetworkApplication.validateNetworkIpAddressRange(range, invalidValues, ++i);
        }
        if (useCommunities) {
            i = 0;
            for (NetworkSNMPCommunity community : communitiesView.addListToMap(map)) {
                ManagedNetworkApplication.validateNetworkSNMPCommunity(community, invalidValues, ++i);
            }
        }
        if (invalidValues.isEmpty()) {
            return true;
        }
        ManagedNetworkApplication.reportErrors();
        return false;
    }

    private static void clearErrors() {
        invalidValuesUtil.clearReportedInvalidValues(invalidValues);
        mainPanel.getErrorReportEditorPane1().setMessages(invalidValues);
    }

    @Override
    public void cancelActionPerformed() {
        ManagedNetworkApplication.refresh();
    }

    public static void refresh() {
        ManagedNetworkApplication.clearErrors();
        ManagedNetworkApplication.updateRanges();
        ManagedNetworkApplication.updateCommunities();
    }

    private static void reportErrors() {
        mainPanel.getErrorReportEditorPane1().setMessages(invalidValues);
        invalidValuesUtil.reportInvalidValues(invalidValues);
    }

    private static void importRanges(List<NetworkIpAddressRange> ranges) {
        int i = 0;
        for (NetworkIpAddressRange range : ranges) {
            ++i;
            while (invalidRows.contains(i)) {
                ++i;
            }
            ManagedNetworkApplication.validateNetworkIpAddressRange(range, invalidValues, i);
        }
        if (invalidValues.isEmpty() && (!rangesView.isEmpty() && ManagedNetworkApplication.appendOrOverwrite() || rangesView.isEmpty() && !rangesView.isChanged() || rangesView.isEmpty() && rangesView.isChanged() && MessageBox.Confirm.showResult(frame, i18n.translateString("warnChanges")))) {
            try {
                ServiceRegistry.getEntityManagerService().saveAll(ranges);
                ManagedNetworkApplication.refresh();
                return;
            }
            catch (ServiceException e) {
                log.error((Object)"Failed to save network IP range.", (Throwable)e);
            }
        }
        ManagedNetworkApplication.reportErrors();
    }

    private static boolean appendOrOverwrite() {
        StringBuilder message = new StringBuilder();
        message.append(i18n.translateString("AppendOrOverwrite"));
        if (rangesView.isChanged()) {
            message.append(" ");
            message.append(i18n.translateString("warnChanges"));
        }
        Object[] options = new Object[]{i18n.translateString("overwrite"), i18n.translateString("append"), i18n.translateString("cancel")};
        int result = JOptionPane.showOptionDialog(frame, message.toString(), i18n.translateString("AppendOrOverwriteTitle"), -1, 3, null, options, options[0]);
        if (result == -1 || result == 2) {
            return false;
        }
        if (result == 0) {
            ServiceRegistry.getEntityManagerService().deleteAll(NetworkIpAddressRange.class);
        }
        return true;
    }

    private static List<NetworkIpAddressRange> importFromString(String content) {
        ManagedNetworkApplication.clearErrors();
        invalidRows.clear();
        ArrayList<NetworkIpAddressRange> list = new ArrayList<NetworkIpAddressRange>();
        StringTokenizer lineTokenizer = new StringTokenizer(content, "\n");
        lineTokenizer.nextElement();
        int i = 0;
        while (lineTokenizer.hasMoreElements()) {
            ++i;
            StringTokenizer elementTokenizer = new StringTokenizer((String)lineTokenizer.nextElement(), ",");
            if (elementTokenizer.countTokens() != 8) {
                invalidRows.add(i);
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidRow", i), NetworkIpAddressRange.class, "", (Object)"", null));
                continue;
            }
            NetworkIpAddressRange entry = new NetworkIpAddressRange();
            String temp = "";
            try {
                temp = (String)elementTokenizer.nextElement();
                entry.setType(Integer.parseInt(temp));
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidType", i, temp), NetworkIpAddressRange.class, "", (Object)"", null));
            }
            entry.setStartIp((String)elementTokenizer.nextElement());
            entry.setEndIp((String)elementTokenizer.nextElement());
            entry.setEnableDiscovery(Boolean.parseBoolean((String)elementTokenizer.nextElement()));
            entry.setEnableAutoDiscovery(Boolean.parseBoolean((String)elementTokenizer.nextElement()));
            entry.setReadCommunity((String)elementTokenizer.nextElement());
            entry.setWriteCommunity((String)elementTokenizer.nextElement());
            String locationName = (String)elementTokenizer.nextElement();
            if (!locationName.equals("_")) {
                LightQuery<Location> query = new LightQuery<Location>(Location.class);
                query.addParameter("name", locationName);
                try {
                    LocationMapAssembly assembly;
                    List<Assembly<Location>> locations = ServiceRegistry.getEntityManagerService().retrieveByQuery(query, "Editor");
                    if (!locations.isEmpty() && (assembly = (LocationMapAssembly)locations.get(0)) != null) {
                        entry.setLocation((Location)assembly.getEntity());
                    }
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            list.add(entry);
        }
        return list;
    }

    public static void exportToFile() {
        HashMap<Serializable, Boolean> map = new HashMap<Serializable, Boolean>();
        if (ManagedNetworkApplication.save(map, false)) {
            ManagedNetworkApplication.clearErrors();
            String content = ManagedNetworkApplication.exportToString(map);
            JFileChooser chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new PrivateFileFilter());
            int returnVal = chooser.showSaveDialog(frame);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                boolean overwrite = false;
                boolean cancel = false;
                while (file.exists() && !overwrite && !cancel) {
                    if (MessageBox.Confirm.showResult(frame, i18n.translateString("OverwriteFile"))) {
                        overwrite = true;
                        continue;
                    }
                    chooser.setSelectedFile(file);
                    returnVal = chooser.showSaveDialog(frame);
                    if (returnVal != 0) {
                        cancel = true;
                        continue;
                    }
                    file = chooser.getSelectedFile();
                }
                if (!cancel) {
                    if (ManagedNetworkApplication.getExtension(file) == null) {
                        file = new File(file.getPath() + "." + "nar");
                    }
                    try {
                        PrintWriter pw = new PrintWriter(file);
                        pw.print(content);
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException e) {
                        log.debug((Object)"", (Throwable)e);
                        String message = ExceptionUtil.getMessage(e);
                        message = message == null ? i18n.translateString("ExportError", file.getAbsolutePath()) : i18n.translateString("IOError", message);
                        MessageBox.Error.quickShow(frame, message);
                        return;
                    }
                }
            }
            try {
                ServiceRegistry.getEntityManagerService().saveOrDeleteAll(map);
                ManagedNetworkApplication.updateRanges();
            }
            catch (ServiceException e) {
                log.error((Object)"Failed to save or delete all.", (Throwable)e);
            }
        }
    }

    private static String exportToString(Map map) {
        StringBuffer buffer = new StringBuffer();
        EntityManagerTableModel<NetworkIpAddressRange> model = ((NetworkIpAddressRangesPanel)rangesView.getUI()).getTableModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            buffer.append(model.getColumnName(i));
            if (i >= model.getColumnCount() - 1) continue;
            buffer.append(',');
        }
        buffer.append('\n');
        int[] selectedRows = ((NetworkIpAddressRangesPanel)rangesView.getUI()).getTable().getSelectedRows();
        boolean noRows = selectedRows == null || selectedRows.length == 0;
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getRowState(i) == 1 || !noRows && !ManagedNetworkApplication.contains(selectedRows, i)) continue;
            for (int j = 0; j < model.getColumnCount(); ++j) {
                if (model.getColumnClass(j).equals(Location.class)) {
                    Location location = (Location)model.getValueAt(i, j);
                    if (location != null) {
                        buffer.append(location.getName());
                    } else {
                        buffer.append("_");
                    }
                } else {
                    buffer.append(model.getValueAt(i, j));
                }
                if (j >= model.getColumnCount() - 1) continue;
                buffer.append(',');
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private static boolean contains(int[] selectedRows, int i) {
        for (int cnt = 0; cnt < selectedRows.length; ++cnt) {
            if (selectedRows[cnt] != i) continue;
            return true;
        }
        return false;
    }

    static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private static void validateNetworkIpAddressRange(NetworkIpAddressRange range, List<InvalidValue> invalidValues, int index) {
        IpAddressRange ipRange;
        boolean validRange = true;
        if (range.getStartIp() == null || !range.getStartIp().matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidStartAddress", index), NetworkIpAddressRange.class, "", (Object)ManagedNetworkApplication.notNull(range.getStartIp()), (Object)range));
            validRange = false;
        }
        if (range.getType() == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("SelectType", index), NetworkIpAddressRange.class, "", (Object)"", (Object)range));
        } else {
            if (!(range.getType() != 0 || range.getEndIp() != null && range.getEndIp().matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$"))) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidEndAddress", index), NetworkIpAddressRange.class, "", (Object)ManagedNetworkApplication.notNull(range.getEndIp()), (Object)range));
                validRange = false;
            }
            if (!(range.getType() != 1 || range.getEndIp() != null && range.getEndIp().matches("^255\\.255\\.255\\.(?:255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(?:254|252|248|240|224|192|128|0)\\.0$|^255\\.(?:254|252|248|240|224|192|128|0)\\.0\\.0$|^(?:254|252|248|240|224|192|128|0)\\.0\\.0\\.0$"))) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnet", index), NetworkIpAddressRange.class, "", (Object)ManagedNetworkApplication.notNull(range.getEndIp()), (Object)range));
                validRange = false;
            }
        }
        if (range.getReadCommunity() == null || range.getReadCommunity().trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidReadCommunity", index), NetworkIpAddressRange.class, "", (Object)"", (Object)range));
        }
        if (range.getWriteCommunity() == null || range.getWriteCommunity().trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidWriteCommunity", index), NetworkIpAddressRange.class, "", (Object)"", (Object)range));
        }
        if (validRange && range.getType() != null && (ipRange = range.toIpAddressRange()) != null) {
            if (ipRange.size() > 65535) {
                IpAddress rangeStartIpAddress = new IpAddress(range.getStartIp());
                long maxIpAddressLong = new IpAddress("255.255.255.255").getIpAddress();
                long maxRangeIpAddressLong = rangeStartIpAddress.getIpAddress() + 65535L - 1L;
                IpAddress maxRangeIpAddress = new IpAddress(maxRangeIpAddressLong < maxIpAddressLong ? maxRangeIpAddressLong : maxIpAddressLong);
                invalidValues.add(new InvalidValue(i18n.translateString("RangeTooBig", rangeStartIpAddress.toString(), maxRangeIpAddress.toString()), NetworkIpAddressRange.class, "", (Object)"", NetworkIpAddressRange.class));
            } else if (ipRange.size() <= 0) {
                invalidValues.add(new InvalidValue(i18n.translateString("RangeNegative"), NetworkIpAddressRange.class, "", (Object)"", (Object)ipRange));
            }
        }
    }

    private static void validateNetworkSNMPCommunity(NetworkSNMPCommunity community, List<InvalidValue> invalidValues, int index) {
        if (community.getReadCommunity() == null || community.getReadCommunity().trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("NoReadCommunity", index), NetworkSNMPCommunity.class, "", (Object)"", (Object)community));
        }
        if (community.getWriteCommunity() == null || community.getWriteCommunity().trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("NoWriteCommunity", index), NetworkSNMPCommunity.class, "", (Object)"", (Object)community));
        }
    }

    private static String notNull(String val) {
        return val != null ? val : "";
    }

    public static void importData(String string) {
        List<NetworkIpAddressRange> list = ManagedNetworkApplication.importFromString(string);
        ManagedNetworkApplication.importRanges(list);
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return i18n.translateString("DiscoverySettings");
    }

    public String getHelpTopic() {
        return "managed_network";
    }

    static {
        frame = null;
        rangesView = new NetworkIpAddressRangesView();
        communitiesView = new NetworkCommunitiesView();
        invalidValuesUtil = new InvalidValuesUtil();
        invalidValues = new ArrayList<InvalidValue>();
        invalidRows = new HashSet<Integer>();
    }

    public static class PrivateFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = ManagedNetworkApplication.getExtension(f);
            return extension != null && extension.equals("nar");
        }

        public String getDescription() {
            return "nar";
        }
    }
}

