/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.longoperation.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationMonitor;
import com.bwanms.gui.longoperation.LongOperationMonitorView;
import com.bwanms.gui.longoperation.LongOperationMonitorViewContext;
import com.bwanms.gui.longoperation.impl.SimpleLongOperationMonitorPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SimpleLongOperationMonitorView
implements LongOperationMonitor,
LongOperationMonitorView {
    private static final Logger logger = Logger.getLogger(SimpleLongOperationMonitorView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SimpleLongOperationMonitorView.class);
    private LongOperation operation;
    private SimpleLongOperationMonitorPanel ui;
    private ActionListener cancelActionListener;
    LongOperationMonitorViewContext context;
    private boolean finished;

    public SimpleLongOperationMonitorView(LongOperation operation) {
        this.operation = operation;
        operation.setLongOperationMonitor(this);
    }

    public void updateProgress(long progress, String message) {
        this.ui.getProgressProgress().setValue((int)(100L * progress / this.operation.getMaxProgress()));
        this.ui.getLblMessage().setText(message);
    }

    public void operationCompleted(boolean close) {
        this.finished = true;
        this.ui.getLblMessage().setText("");
        if (close) {
            this.context.close();
        } else {
            this.context.enableClose();
            this.ui.getBtnCancel().setText(i18n.translateString("Close"));
            this.ui.getBtnCancel().removeActionListener(this.cancelActionListener);
            this.ui.getBtnCancel().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimpleLongOperationMonitorView.this.context.close();
                }
            });
        }
    }

    public void setLongOperationMonitorViewContext(LongOperationMonitorViewContext context) {
        this.context = context;
    }

    public JComponent getUI() {
        if (null == this.ui) {
            this.ui = new SimpleLongOperationMonitorPanel();
            i18n.getSwingInternationalizer().translateComponent(this.ui);
            this.ui.getBtnCancel().setEnabled(this.operation.isCancelable());
            this.cancelActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimpleLongOperationMonitorView.this.operation.cancel();
                }
            };
            this.ui.getBtnCancel().addActionListener(this.cancelActionListener);
            this.ui.getProgressProgress().setMinimum(0);
            this.ui.getProgressProgress().setMaximum(100);
            this.ui.getLblMessage().setText("");
        }
        return this.ui;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return this.operation.getTitle();
    }

    public void logMessage(String message) {
        logger.debug((Object)message);
    }

    public boolean isFinished() {
        return this.finished;
    }
}

