/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.longoperation.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationMonitor;
import com.bwanms.gui.longoperation.LongOperationMonitorView;
import com.bwanms.gui.longoperation.LongOperationMonitorViewContext;
import com.bwanms.gui.longoperation.impl.DetailLongOperationMonitorPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DetailLongOperationMonitorView
implements LongOperationMonitor,
LongOperationMonitorView {
    private static final Logger logger = Logger.getLogger(DetailLongOperationMonitorView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(DetailLongOperationMonitorView.class);
    private static DateFormat hourFormat = new SimpleDateFormat("hh:mm:ss");
    private LongOperation operation;
    private DetailLongOperationMonitorPanel ui;
    LongOperationMonitorViewContext context;
    private ActionListener cancelActionListener;
    private boolean finished;

    public DetailLongOperationMonitorView(LongOperation operation) {
        this.operation = operation;
        operation.setLongOperationMonitor(this);
    }

    public void updateProgress(long progress, String message) {
        this.ui.getProgressProgress().setValue((int)(100L * progress / this.operation.getMaxProgress()));
        this.ui.getLblMessage().setText(message);
    }

    public void operationCompleted(boolean close) {
        this.finished = true;
        this.ui.getLblMessage().setText("");
        if (close) {
            this.context.close();
        } else {
            this.context.enableClose();
            this.ui.getBtnCancel().setText(i18n.translateString("Close"));
            this.ui.getBtnCancel().removeActionListener(this.cancelActionListener);
            this.ui.getBtnCancel().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailLongOperationMonitorView.this.context.close();
                }
            });
        }
    }

    public void setLongOperationMonitorViewContext(LongOperationMonitorViewContext context) {
        this.context = context;
    }

    public JComponent getUI() {
        if (null == this.ui) {
            this.ui = new DetailLongOperationMonitorPanel();
            i18n.getSwingInternationalizer().translateComponent(this.ui);
            this.ui.getBtnCancel().setEnabled(this.operation.isCancelable());
            this.cancelActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailLongOperationMonitorView.this.operation.cancel();
                }
            };
            this.ui.getBtnCancel().addActionListener(this.cancelActionListener);
            this.ui.getProgressProgress().setMinimum(0);
            this.ui.getProgressProgress().setMaximum(100);
            this.ui.getLblMessage().setText("");
        }
        return this.ui;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return this.operation.getTitle();
    }

    public void logMessage(String message) {
        this.ui.getTxtAreaDetails().setText(this.ui.getTxtAreaDetails().getText() + "\n" + hourFormat.format(new Date()) + ": " + message);
    }

    public boolean isFinished() {
        return this.finished;
    }
}

