/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.longoperation;

import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationMonitorDialog;
import com.bwanms.gui.longoperation.LongOperationMonitorView;
import com.bwanms.gui.longoperation.impl.DetailLongOperationMonitorView;
import com.bwanms.gui.longoperation.impl.SimpleLongOperationMonitorView;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.util.FrameUtil;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LongOperationUtil {
    private static final Logger logger = Logger.getLogger(LongOperationUtil.class);

    public static void startLongOperationDialog(JComponent parent, final LongOperation operation, LongOperationMonitorView view) {
        Window windowOwner = SwingUtilities.getWindowAncestor(parent);
        LongOperationMonitorDialog dialog = null;
        dialog = windowOwner instanceof JFrame ? new LongOperationMonitorDialog((JFrame)windowOwner) : new LongOperationMonitorDialog((JDialog)windowOwner);
        dialog.setView(view);
        dialog.setModal(true);
        dialog.pack();
        FrameUtil.centerWindow(dialog);
        new UIBackgroundJob(){

            public void run() {
                try {
                    operation.run();
                }
                catch (Throwable t) {
                    logger.error((Object)t, t);
                }
            }
        }.schedule();
        dialog.setVisible(true);
    }

    public static void startLongOperationDialog(JComponent parent, LongOperation longOperation) {
        SimpleLongOperationMonitorView monitorView = new SimpleLongOperationMonitorView(longOperation);
        LongOperationUtil.startLongOperationDialog(parent, longOperation, monitorView);
    }

    public static void startDetailLongOperationDialog(JComponent parent, LongOperation longOperation) {
        DetailLongOperationMonitorView monitorView = new DetailLongOperationMonitorView(longOperation);
        LongOperationUtil.startLongOperationDialog(parent, longOperation, monitorView);
    }
}

