/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.util.EquipmentUIIconFactory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.topology.Node;
import com.bwanms.util.fault.EventUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TopologyNodeUIIconFactory
extends UIIconFactory {
    private ImageIcon unreachableOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("error_co.gif"));
    private ImageIcon unlicensedOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("warning_co.gif"));

    public Icon getIconForClassImpl(Class target) {
        return null;
    }

    public final Icon getIconImpl(Object target, int flags) {
        Node location = (Node)target;
        return new NodeIcon(this.getPlainIcon(location), location, flags);
    }

    public ImageIcon getPlainIcon(Node location) {
        if (location.getIconName() != null) {
            return new ImageIcon(this.getClass().getResource(location.getIconName()));
        }
        return new ImageIcon();
    }

    class NodeIcon
    implements Icon {
        private ImageIcon delegate;
        private int flags;
        private Node location;

        public NodeIcon(ImageIcon delegate, Node location, int flags) {
            this.delegate = delegate;
            this.location = location;
            this.flags = flags;
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            boolean licensed = LicenseClient.getInstance().isLicensed(this.location);
            if ((this.flags & 2) != 0) {
                if (licensed && (this.location.getState() == 0 || this.location.getState() == 1)) {
                    if (this.location.getState() == 1) {
                        g.setColor(EventUtil.getSeverityColor(Severity.Critical));
                    } else {
                        g.setColor(EventUtil.getSeverityColor(Severity.fromValue(Math.max(this.location.getAlarmState(), Severity.Cleared.value()))));
                    }
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                } else {
                    grayed = true;
                }
            }
            if (grayed |= (this.flags & 1) != 0) {
                if (licensed && this.location.getState() != -3) {
                    g.setColor(EventUtil.getSeverityColor(Severity.Critical));
                    g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                }
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.drawImage(this.delegate.getImage(), x, y, c);
                g2d.setComposite(originalComposite);
                if (licensed) {
                    g2d.drawImage(TopologyNodeUIIconFactory.this.unreachableOverlay.getImage(), x + this.getIconWidth() - TopologyNodeUIIconFactory.this.unreachableOverlay.getIconWidth(), y + this.getIconHeight() - TopologyNodeUIIconFactory.this.unreachableOverlay.getIconHeight(), c);
                } else {
                    g2d.drawImage(TopologyNodeUIIconFactory.this.unlicensedOverlay.getImage(), x + this.getIconWidth() - TopologyNodeUIIconFactory.this.unlicensedOverlay.getIconWidth(), y + this.getIconHeight() - TopologyNodeUIIconFactory.this.unreachableOverlay.getIconHeight(), c);
                }
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }
    }
}

