/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextAreaBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.locationmanager.LocationEditorPanel;
import com.bwanms.gui.locationmanager.MapPreviewContainer;
import com.bwanms.model.Location;
import com.bwanms.model.LocationMap;
import com.bwanms.security.Security;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.util.FormUtil;
import com.bwanms.util.IOUtil;
import com.bwanms.util.MessageBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationView
extends AbstractBindedEditorView<Location> {
    private static Logger logger = Logger.getLogger(LocationView.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(LocationView.class);
    private LocationEditorPanel panel = new LocationEditorPanel();
    private byte[] imgData;
    private String origFileName;

    public LocationView() {
        this.registerListeners();
    }

    private void registerListeners() {
        this.panel.getBtnClear().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocationView.access$002(LocationView.this, null);
                LocationView.this.origFileName = "";
                LocationView.this.updateBtnPreview();
                LocationView.this.updateSmallImg();
            }
        });
        this.panel.getBtnBrowse().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JFileChooser jfc = new JFileChooser();
                ExtensionFileFilter filter = new ExtensionFileFilter();
                filter.addExtension("jpg");
                filter.addExtension("gif");
                filter.addExtension("png");
                filter.addExtension("bmp");
                filter.setDescription(i18n.translateString("PictureFiles"));
                jfc.addChoosableFileFilter(filter);
                int retVal = jfc.showOpenDialog(LocationView.this.panel);
                if (retVal == 0) {
                    File selFile = jfc.getSelectedFile();
                    LocationView.this.origFileName = selFile.getAbsolutePath();
                    if (selFile == null) {
                        MessageBox.Alert.quickShow(LocationView.this.panel, i18n.translateString("noFileSelected"));
                        return;
                    }
                    if (!selFile.exists()) {
                        MessageBox.Alert.quickShow(LocationView.this.panel, i18n.translateString("fileNotFound"));
                        return;
                    }
                    if (selFile.length() > 524288L) {
                        MessageBox.Alert.quickShow(LocationView.this.panel, i18n.translateString("fileTooBig", 512));
                        return;
                    }
                    byte[] tempBuf = null;
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(selFile));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtil.copyStream(in, out, 1024);
                        tempBuf = out.toByteArray();
                        in.close();
                        out.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        MessageBox.Alert.quickShow(LocationView.this.panel, i18n.translateString("IOError"));
                        return;
                    }
                    ImageIcon imgIcon = new ImageIcon(tempBuf);
                    if (imgIcon.getIconHeight() == -1 || imgIcon.getIconWidth() == -1) {
                        MessageBox.Alert.quickShow(LocationView.this.panel, i18n.translateString("fileNotValid"));
                        return;
                    }
                    LocationView.access$002(LocationView.this, tempBuf);
                    tempBuf = null;
                    LocationView.this.updateBtnPreview();
                    LocationView.this.updateSmallImg();
                }
            }
        });
        this.panel.getBtnPreview().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocationMap justForPreview = new LocationMap();
                justForPreview.setImgData(LocationView.this.imgData);
                new MapPreviewContainer(justForPreview);
            }
        });
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("Location");
    }

    @Override
    public void fillUI(Location entity) {
        LocationMap map;
        this.panel.setSelectionData(entity.getId());
        this.panel.getSelectorParent().setValue(entity.getParent());
        if (entity.getId() > 0L) {
            FormUtil.setSelectedValue(this.panel.getComboCoordinateType(), entity.getCoordinateType());
            FormUtil.setSelectedValue(this.panel.getComboIcon(), entity.getIconName());
        }
        if ((map = entity.getSingleLocationMap()) != null) {
            this.imgData = map.getImgData();
        }
        this.updateSmallImg();
        this.updateBtnPreview();
        if (!Security.getSecurity().checkPermissions("Av:Topology", "add")) {
            this.panel.getBtnBrowse().setEnabled(false);
        }
        if (!Security.getSecurity().checkPermissions("Av:Topology", "delete")) {
            this.panel.getBtnClear().setEnabled(false);
        }
    }

    @Override
    public List<InvalidValue> configureEntity(Location entity) {
        entity.setCoordinateType((Integer)FormUtil.getSelectedValue(this.panel.getComboCoordinateType()));
        entity.setIconName((String)FormUtil.getSelectedValue(this.panel.getComboIcon()));
        entity.setParent((Location)this.panel.getSelectorParent().getValue());
        LocationMap map = entity.getSingleLocationMap();
        map.setOrigFilename(this.origFileName);
        map.setImgData(this.imgData);
        map.setLocation(entity);
        return super.configureEntity(entity);
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtName", "name", i18n.translateString("Name"))).add(new JTextFieldBinding("txtCoordinates", "coordinates")).add(new JTextAreaBinding("txtAreaPostalAddress", "postalAddress")).add(new JTextAreaBinding("textAreaLocationDetails", "details")));
        return binders;
    }

    private boolean isPicLoaded() {
        return this.imgData != null && this.imgData.length > 0;
    }

    private void updateBtnPreview() {
        this.panel.getBtnPreview().setEnabled(this.isPicLoaded());
    }

    private void updateSmallImg() {
        if (this.imgData != null) {
            this.panel.getLabelDisplImg().setText(i18n.translateString("ImageAssigned"));
        } else {
            this.panel.getLabelDisplImg().setText(i18n.translateString("NoImageAssigned"));
        }
    }

    @Override
    public String getApplicationPermission() {
        return "Av:ConfigureLocations";
    }

    @Override
    public String getHelpTopic() {
        return "adding_locations";
    }

    static /* synthetic */ byte[] access$002(LocationView x0, byte[] x1) {
        x0.imgData = x1;
        return x1;
    }
}

