/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.util.EquipmentUIIconFactory;
import com.bwanms.model.Location;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LocationUIIconFactory
extends UIIconFactory {
    private ImageIcon unlicensedOverlay = new ImageIcon(EquipmentUIIconFactory.class.getResource("warning_co.gif"));

    public Icon getIconForClassImpl(Class target) {
        return null;
    }

    public final Icon getIconImpl(Object target, int flags) {
        Location location = (Location)target;
        return new LocationIcon(this.getPlainIcon(location), location, flags);
    }

    public ImageIcon getPlainIcon(Location location) {
        if (location.getIconName() != null) {
            return new ImageIcon(this.getClass().getResource(location.getIconName()));
        }
        return new ImageIcon();
    }

    class LocationIcon
    implements Icon {
        private ImageIcon delegate;
        private int flags;
        private Location location;

        public LocationIcon(ImageIcon delegate, Location location, int flags) {
            this.delegate = delegate;
            this.location = location;
            this.flags = flags;
        }

        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }

        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean grayed = false;
            boolean licensed = LicenseClient.getInstance().isLicensed(this.location);
            if ((this.flags & 2) != 0 && !licensed) {
                grayed = true;
            }
            if (grayed |= (this.flags & 1) != 0) {
                Graphics2D g2d = (Graphics2D)g;
                Composite originalComposite = g2d.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2d.setComposite(alpha);
                g2d.drawImage(this.delegate.getImage(), x, y, c);
                g2d.setComposite(originalComposite);
                if (!licensed) {
                    g2d.drawImage(LocationUIIconFactory.this.unlicensedOverlay.getImage(), x + this.getIconWidth() - LocationUIIconFactory.this.unlicensedOverlay.getIconWidth(), y + this.getIconHeight() - LocationUIIconFactory.this.unlicensedOverlay.getIconHeight(), c);
                }
            } else {
                g.drawImage(this.delegate.getImage(), x, y, c);
            }
        }
    }
}

