/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.gui.UIIconFactory;
import com.bwanms.model.Location;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class LocationTreeCellRenderer
extends JComponent
implements TreeCellRenderer {
    private static final long serialVersionUID = 204343864476254411L;
    private String name;
    private Icon icon;
    private boolean selected;
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private static final int iconTextGap = 3;

    public void paint(Graphics g) {
        Color foreground;
        Color background;
        if (this.icon != null) {
            this.icon.paintIcon(this, g, LocationTreeCellRenderer.insets.left, LocationTreeCellRenderer.insets.top);
        }
        if (this.selected) {
            background = new Color(10, 36, 106);
            foreground = new Color(255, 255, 255);
        } else {
            background = new Color(255, 255, 255);
            foreground = new Color(0, 0, 0);
        }
        g.setColor(background);
        Dimension d = this.getNameSize(g, this.name);
        int x = LocationTreeCellRenderer.insets.left + (this.icon != null ? this.icon.getIconWidth() : 0) + 3;
        g.fillRect(x, LocationTreeCellRenderer.insets.top, d.width, d.height);
        g.setColor(foreground);
        if (this.name != null) {
            FontMetrics fm = g.getFontMetrics(this.getFont());
            int descendent = fm.getDescent();
            g.drawString(this.name, x, LocationTreeCellRenderer.insets.top + d.height - descendent);
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Location location = (Location)node.getUserObject();
        this.icon = UIIconFactory.getIcon(location, 2);
        this.name = location.getName();
        this.selected = selected;
        return this;
    }

    public Dimension getPreferredSize() {
        int compWidth = LocationTreeCellRenderer.insets.left + 3 + LocationTreeCellRenderer.insets.right;
        int compHeight = LocationTreeCellRenderer.insets.top + LocationTreeCellRenderer.insets.bottom;
        Dimension d = this.getNameSize(this.getGraphics(), this.name);
        compWidth += d.width;
        if (this.icon != null) {
            compWidth += this.icon.getIconWidth();
            compHeight += Math.max(this.icon.getIconHeight(), d.height);
        } else {
            compHeight += d.height;
        }
        return new Dimension(compWidth, compHeight);
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private Dimension getNameSize(Graphics g, String name) {
        if (name == null || g == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fm = g.getFontMetrics(this.getFont());
        int width = (int)fm.getStringBounds(name, g).getWidth();
        int height = fm.getHeight();
        return new Dimension(width, height);
    }
}

