/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.client.gui.fault.events.OpenAlarmsView;
import com.bwanms.ddi.ConfigLaunchNotSupportedException;
import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.EditorViewContext;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.locationmanager.LocationMapAssembly;
import com.bwanms.gui.locationmanager.LocationMapEditorContainer;
import com.bwanms.gui.locationmanager.LocationMapEditorPanel;
import com.bwanms.gui.visualization.jgraph.JGraphTopologyVisualizationAdapter;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.LocationMap;
import com.bwanms.model.LocationMapNodePosition;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.Link;
import com.bwanms.model.topology.Node;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.TopologyManagerService;
import com.bwanms.services.UnsupportedTopologyVertex;
import com.bwanms.services.impl.TopologyChangeEvent;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.ConfigLauncherPluginUtil;
import com.bwanms.util.CutThroughPluginUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMapEditorView
implements EditorView<Location> {
    private static final Logger log = Logger.getLogger(LocationMapEditorView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LocationMapEditorView.class);
    private LocationMapEditorPanel panel;
    private JGraphTopologyVisualizationAdapter adapter;
    private TopologyChangeListener listener;
    private boolean shouldStop = false;
    private LocationMap locationMap;
    private HashMap<ObjectID, LinkEndPointWrapper> wrappers;
    private LocationMapEditorContainer container;
    private boolean blockUserInteraction = false;
    private boolean dirty = false;

    public LocationMapEditorView(LocationMapEditorContainer container) {
        this.container = container;
        this.panel = new LocationMapEditorPanel();
        this.wrappers = new HashMap();
        this.adapter = new JGraphTopologyVisualizationAdapter(this.panel.getJGraph());
        this.registerListeners();
    }

    private void registerListeners() {
        this.panel.getJGraph().addGraphSelectionListener(new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent event) {
                LocationMapEditorView.this.actionSelectionChanges();
            }
        });
        this.listener = new TopologyChangeListener();
        PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/TopologyChange", this.listener);
        this.panel.getBtnLevelUp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocationMapEditorView.this.actionLevelUp();
            }
        });
        this.panel.getJGraph().addMouseListener((MouseListener)new TopologyUserInputMouseListener());
        this.panel.getJGraph().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){
            Node lastLinkEnd = null;

            public void mouseMoved(MouseEvent e) {
                Node newLinkEnd = LocationMapEditorView.this.adapter.isLinkEndPointCellAt(e.getX(), e.getY());
                if (newLinkEnd == null) {
                    if (this.lastLinkEnd != null) {
                        LocationMapEditorView.this.adapter.hideLegend();
                        this.lastLinkEnd = null;
                    }
                } else {
                    if (this.lastLinkEnd == null || !this.lastLinkEnd.getObjectID().equals(newLinkEnd.getObjectID())) {
                        LocationMapEditorView.this.adapter.initializeObjectDetails(e.getX(), e.getY(), 10, 10, newLinkEnd);
                    }
                    this.lastLinkEnd = newLinkEnd;
                }
            }
        });
        this.panel.setFilterAreaListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocationMapEditorView.this.filtersChanged();
            }
        });
    }

    @Override
    public void setEntity(Location entity) {
        this.locationMap = entity.getSingleLocationMap();
        if (this.locationMap == null) {
            throw new AssertionError((Object)"Location map should not be null");
        }
        this.adapter.clearTopology();
        this.wrappers.clear();
        this.panel.getBtnLevelUp().setEnabled(this.hasParent());
        String display = this.locationMap.getDisplay();
        List<String> selFilters = null;
        selFilters = display != null && !"".equals(display) ? Arrays.asList(display.split(";")) : new ArrayList<String>();
        this.panel.setSelectedFilters(selFilters);
        if (this.locationMap.hasImageAssigned()) {
            Image imageMap = Toolkit.getDefaultToolkit().createImage(this.locationMap.getImgData());
            this.panel.getImagePanel().setBackgroundImage(imageMap);
        } else {
            this.panel.getImagePanel().setBackgroundImage(null);
            this.panel.validate();
            this.panel.getImagePanel().repaint();
        }
        Map<ObjectID, LocationMapNodePosition> initPositions = this.locationMap.getAsocNodePosition();
        Node rootNode = null;
        try {
            TopologyManagerService topoService = ServiceRegistry.getTopologyManagerService();
            rootNode = topoService.expandLinkEndPoint(new ObjectID(Location.class.getName(), Long.valueOf(entity.getId())));
            int x = 30;
            int y = 30;
            int noOfCols = 6;
            for (Link link : rootNode.getInboundLinks()) {
                Node childNode = topoService.expandLinkEndPoint(link.getAEndPoint());
                LinkEndPointWrapper childWrapper = new LinkEndPointWrapper(childNode, this.locationMap);
                this.wrappers.put(childNode.getObjectID(), childWrapper);
                LocationMapNodePosition initPosition = initPositions.get(childNode.getObjectID());
                if (initPosition != null) {
                    childWrapper.lmEndPoint.setX(initPosition.getX());
                    childWrapper.lmEndPoint.setY(initPosition.getY());
                    childWrapper.lmEndPoint.setWidht(initPosition.getWidht());
                    childWrapper.lmEndPoint.setHeight(initPosition.getHeight());
                } else {
                    if (x > 50 * noOfCols) {
                        x = 30;
                        y += 50;
                    } else {
                        x += 50;
                    }
                    childWrapper.lmEndPoint.setX(x);
                    childWrapper.lmEndPoint.setY(y);
                    childWrapper.lmEndPoint.setWidht(40.0);
                    childWrapper.lmEndPoint.setHeight(32.0);
                }
                childWrapper.setVisible(true);
            }
        }
        catch (UnsupportedTopologyVertex e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<InvalidValue> configureEntity(Location entity) {
        for (LinkEndPointWrapper wrapper : this.wrappers.values()) {
            wrapper.updatePosition();
        }
        this.locationMap.getNodePosition().clear();
        for (LinkEndPointWrapper wrapper : this.wrappers.values()) {
            this.locationMap.getNodePosition().add(wrapper.getLmEndPoint());
        }
        StringBuffer bufDisplay = new StringBuffer();
        Set<String> selFilters = this.panel.getSelectedFilters();
        for (String filter : selFilters) {
            bufDisplay.append(filter);
            bufDisplay.append(";");
        }
        this.locationMap.setDisplay(bufDisplay.toString());
        return new ArrayList<InvalidValue>();
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public boolean close() {
        if (this.dirty) {
            return false;
        }
        for (LinkEndPointWrapper wrapper : this.wrappers.values()) {
            Rectangle2D bounds;
            if (!this.adapter.containsEndPoint(wrapper.lmEndPoint.getObjectID()) || (bounds = this.adapter.getLinkEndPointBounds(wrapper.lmEndPoint.getObjectID())).getX() == wrapper.lmEndPoint.getX() && bounds.getY() == wrapper.lmEndPoint.getY()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cleanup() {
        this.locationMap = null;
        this.panel = null;
        this.container = null;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("CurrentMap", this.locationMap.getLocation().getName());
    }

    @Override
    public void processExternalInvalidValues(List<InvalidValue> invalidValues) {
    }

    @Override
    public void setEntityContext(EditorViewContext ctx) {
    }

    @Override
    public String getApplicationPermission() {
        return "Av:Topology";
    }

    private static Location loadLocation(long locationId) {
        try {
            LocationMapAssembly assembly = (LocationMapAssembly)ServiceRegistry.getEntityManagerService().get(Location.class, locationId, "Editor");
            if (assembly != null) {
                return (Location)assembly.getEntity();
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return null;
    }

    private void actionDrillDown(ObjectID linkEndPointId) {
        int userChoice = 1;
        if (!this.close() && Security.getSecurity().checkPermissions(this.getApplicationPermission(), "write")) {
            userChoice = MessageBox.ConfirmWithCancel.showOption(this.getUI(), i18n.translateString("SaveConfirmation", this.locationMap.getLocation().getName()));
        }
        if (userChoice == 2) {
            return;
        }
        if (userChoice == 0) {
            this.container.save();
            this.setDirty(false);
        } else if (userChoice == 1) {
            this.setDirty(false);
        }
        Location newLocation = LocationMapEditorView.loadLocation((Long)linkEndPointId.getIdentifier());
        if (newLocation != null) {
            LocationMap newMap = newLocation.getSingleLocationMap();
            if (newMap != null) {
                this.container.changeEntity(newLocation);
            }
        } else {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("LocationNotFound"));
        }
    }

    private void actionConfigureEquipment(ObjectID linkEndPointId) {
        Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, (Long)linkEndPointId.getIdentifier());
        if (equipment == null) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentNotFound"));
            return;
        }
        if (equipment.getState() == -1) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentUnreachable"));
            return;
        }
        if (equipment.getState() == -3) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentUnknownState"));
            return;
        }
        if (equipment.getState() == 1) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentDownState"));
            return;
        }
        if (!LicenseClient.getInstance().isLicensed(equipment)) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentUnlicensed"));
            return;
        }
        ConfigApplicationView configAppView = new ConfigApplicationView(equipment);
        try {
            ConfigLauncherPluginUtil.performConfigLaunch(equipment);
        }
        catch (ConfigLaunchNotSupportedException e) {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("EquipmentConfigLaunchError"));
            log.error((Object)("Failed to launch equuipment editor for equipment " + equipment.getEUID()), (Throwable)e);
        }
    }

    private void actionLevelUp() {
        int userChoice = 1;
        if (!this.close() && Security.getSecurity().checkPermissions(this.getApplicationPermission(), "write")) {
            userChoice = MessageBox.ConfirmWithCancel.showOption(this.getUI(), i18n.translateString("SaveConfirmation", this.locationMap.getLocation().getName()));
        }
        if (userChoice == 2) {
            return;
        }
        if (userChoice == 0) {
            this.container.save();
            this.setDirty(false);
        } else if (userChoice == 1) {
            this.setDirty(false);
        }
        Location entity = this.locationMap.getLocation();
        Location pLocation = entity.getParent();
        pLocation = LocationMapEditorView.loadLocation(pLocation.getId());
        if (pLocation != null) {
            this.container.changeEntity(pLocation);
        } else {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("LocationNotFound"));
        }
    }

    private void actionSelectionChanges() {
        Node selected = this.adapter.getSelectedEndPoint();
        if (selected == null) {
            return;
        }
        this.adapter.setLegend(selected);
    }

    private void actionShowCtxMenu(Node selected, MouseEvent ev) {
        this.panel.getCtxMenu().removeAll();
        if (selected == null) {
            log.debug((Object)"Build ctx menu for map");
            JMenuItem levelUpItem = new JMenuItem(new LevelUpAction(i18n.translateString("LevelUp")));
            levelUpItem.setEnabled(this.hasParent());
            this.panel.getCtxMenu().add(levelUpItem);
        } else if (selected.getObjectID().getClassName().equals(Location.class.getName())) {
            log.debug((Object)"Build ctx menu for location");
            this.panel.getCtxMenu().add(new JMenuItem(new DrillDownAction(selected.getObjectID(), i18n.translateString("DrillDown"))));
        } else {
            log.debug((Object)"Build ctx menu for equipment");
            this.panel.getCtxMenu().add(new JMenuItem(new ConfigureEquipmentAction(selected.getObjectID(), i18n.translateString("Configure"))));
            this.panel.getCtxMenu().add(new JMenuItem(new CutThroughAction(selected.getObjectID(), i18n.translateString("CutThrough"))));
            JMenuItem openAlarms = new JMenuItem(new OpenAlarmsAction(selected.getObjectID(), i18n.translateString("OpenAlarms")));
            this.panel.getCtxMenu().add(openAlarms);
        }
        this.panel.getCtxMenu().show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private void actionCutThrogh(ObjectID selectedEndPointID) {
        Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, (Long)selectedEndPointID.getIdentifier());
        if (equipment != null) {
            try {
                CutThroughPluginUtil.performCutThrough(equipment);
            }
            catch (CutThroughNotSupportedException e) {
                MessageBox.Alert.quickShow(i18n.translateString("CutThroughNotSupportedError", equipment.getName()));
            }
            catch (Exception e) {
                MessageBox.Error.quickShow(i18n.translateString("CutThroughFailedError"));
            }
        } else {
            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("ErrorEquipmentNotFound"));
        }
    }

    private void actionOpenAlarms(ObjectID selectedEndPointID) {
        Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, (Long)selectedEndPointID.getIdentifier());
        if (equipment != null) {
            try {
                FrameUtil.runView(new OpenAlarmsView(equipment), 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void refreshVertex(Node vertex) {
        log.debug((Object)("refreshVertex[ " + vertex.getName() + " " + vertex.getObjectID().getClassName() + " ]"));
        if (this.locationMap != null) {
            Long locationID = this.locationMap.getLocation().getId();
            if (vertex.getObjectID().getClassName().equals(Location.class.getName()) && ((Long)vertex.getObjectID().getIdentifier()).equals(locationID)) {
                log.debug((Object)("initWrappers Vertex[ " + vertex.getName() + " " + vertex.getObjectID().getClassName() + " ]"));
                this.initWrappers(vertex);
            } else {
                LinkEndPointWrapper wrapper = this.wrappers.get(vertex.getObjectID());
                if (wrapper != null) {
                    log.debug((Object)("refreshVertex Vertex[ " + vertex.getName() + " " + vertex.getObjectID().getClassName() + " ]"));
                    wrapper.refreshVertex(vertex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            this.debugMemUsage();
        }
    }

    private boolean hasParent() {
        return this.locationMap.getLocation().getParent() != null;
    }

    @Override
    public void setClientData(Object data) {
    }

    private void filtersChanged() {
        Set<String> filterClasses = this.panel.getFilterClasses();
        Set<String> selectedFilters = this.panel.getSelectedFilters();
        for (LinkEndPointWrapper wrapper : this.wrappers.values()) {
            String wrapperClassName = wrapper.vertex.getObjectID().getClassName();
            if (!filterClasses.contains(wrapperClassName)) continue;
            if (!selectedFilters.contains(wrapperClassName) && wrapper.isVisible()) {
                wrapper.updatePosition();
                wrapper.setVisible(false);
            }
            if (!selectedFilters.contains(wrapperClassName) || wrapper.isVisible()) continue;
            wrapper.setVisible(true);
        }
        this.setDirty(true);
    }

    private boolean shouldDisplayVertex(LinkEndPointWrapper wrapper) {
        Set<String> filterClasses = this.panel.getFilterClasses();
        Set<String> selectedFilters = this.panel.getSelectedFilters();
        String className = wrapper.vertex.getObjectID().getClassName();
        if (filterClasses.contains(className)) {
            return selectedFilters.contains(className);
        }
        return true;
    }

    private synchronized void initWrappers(Node rootNode) {
        log.debug((Object)("initWrappers[ " + rootNode.getName() + " ]"));
        HashMap<ObjectID, LinkEndPointWrapper> newWrappers = new HashMap<ObjectID, LinkEndPointWrapper>();
        try {
            int x = 30;
            int y = 30;
            int noOfCols = 6;
            for (Link link : rootNode.getInboundLinks()) {
                Node childNode = ServiceRegistry.getTopologyManagerService().expandLinkEndPoint(link.getAEndPoint());
                if (childNode == null) continue;
                LinkEndPointWrapper childWrapper = this.wrappers.get(childNode.getObjectID());
                if (childWrapper == null) {
                    log.debug((Object)"Node not found in wrappers");
                    childWrapper = new LinkEndPointWrapper(childNode, this.locationMap);
                    newWrappers.put(childNode.getObjectID(), childWrapper);
                    if (x > 50 * noOfCols) {
                        x = 30;
                        y += 50;
                    } else {
                        x += 50;
                    }
                    childWrapper.lmEndPoint.setX(x);
                    childWrapper.lmEndPoint.setY(y);
                    childWrapper.lmEndPoint.setWidht(40.0);
                    childWrapper.lmEndPoint.setHeight(32.0);
                    childWrapper.setVisible(true);
                    continue;
                }
                log.debug((Object)("Node " + childNode.getName() + " found in wrappers"));
                childWrapper.updatePosition();
                childWrapper.vertex = childNode;
                newWrappers.put(childNode.getObjectID(), childWrapper);
            }
            this.wrappers.clear();
            this.wrappers.putAll(newWrappers);
            this.adapter.clearTopology();
            for (LinkEndPointWrapper linkEndPoint : this.wrappers.values()) {
                linkEndPoint.refreshVisual();
            }
        }
        catch (UnsupportedTopologyVertex e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getHelpTopic() {
        return "location_map";
    }

    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    private void debugMemUsage() {
        log.info((Object)("Wrappers: " + this.wrappers.size()));
        int numLinks = 0;
        for (LinkEndPointWrapper wrapper : this.wrappers.values()) {
            numLinks += wrapper.vertex.getInboundLinks().size() + wrapper.vertex.getInboundLinks().size();
        }
        log.info((Object)("Links   : " + numLinks));
    }

    private class OpenAlarmsAction
    extends AbstractAction {
        private ObjectID selectedEndPointID;

        public OpenAlarmsAction() {
        }

        public OpenAlarmsAction(ObjectID selectedEndPointID, String name) {
            super(name);
            this.selectedEndPointID = selectedEndPointID;
        }

        public void actionPerformed(ActionEvent e) {
            LocationMapEditorView.this.actionOpenAlarms(this.selectedEndPointID);
        }

        public void setSelectedEndPointID(ObjectID selectedEndPointID) {
            this.selectedEndPointID = selectedEndPointID;
        }
    }

    private class CutThroughAction
    extends AbstractAction {
        private ObjectID selectedEndPointID;

        public CutThroughAction() {
        }

        public CutThroughAction(ObjectID selectedEndPointID, String name) {
            super(name);
            this.selectedEndPointID = selectedEndPointID;
        }

        public void actionPerformed(ActionEvent e) {
            LocationMapEditorView.this.actionCutThrogh(this.selectedEndPointID);
        }

        public void setSelectedEndPointID(ObjectID selectedEndPointID) {
            this.selectedEndPointID = selectedEndPointID;
        }
    }

    private class ConfigureEquipmentAction
    extends AbstractAction {
        private ObjectID selectedEndPointID;

        public ConfigureEquipmentAction() {
        }

        public ConfigureEquipmentAction(ObjectID selectedEndPointID, String name) {
            super(name);
            this.selectedEndPointID = selectedEndPointID;
        }

        public void actionPerformed(ActionEvent e) {
            LocationMapEditorView.this.actionConfigureEquipment(this.selectedEndPointID);
        }

        public void setSelectedEndPointID(ObjectID selectedEndPointID) {
            this.selectedEndPointID = selectedEndPointID;
        }
    }

    private class LevelUpAction
    extends AbstractAction {
        public LevelUpAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            LocationMapEditorView.this.actionLevelUp();
        }
    }

    private class DrillDownAction
    extends AbstractAction {
        private ObjectID selectedEndPointID;

        public DrillDownAction() {
        }

        public DrillDownAction(ObjectID selectedEndPointID, String name) {
            super(name);
            this.selectedEndPointID = selectedEndPointID;
        }

        public void actionPerformed(ActionEvent e) {
            LocationMapEditorView.this.actionDrillDown(this.selectedEndPointID);
        }

        public void setSelectedEndPointID(ObjectID selectedEndPointID) {
            this.selectedEndPointID = selectedEndPointID;
        }
    }

    private class TopologyUserInputMouseListener
    extends MouseAdapter {
        private TopologyUserInputMouseListener() {
        }

        public void mouseClicked(MouseEvent ev) {
            if (LocationMapEditorView.this.blockUserInteraction) {
                return;
            }
            Node selected = LocationMapEditorView.this.adapter.getSelectedEndPoint();
            log.debug((Object)("Caught mouseClicked event. No of clicks : " + ev.getClickCount()));
            log.debug((Object)("Selected node : " + selected));
            if (selected != null && ev.getClickCount() == 2) {
                ObjectID linkEndPointId = selected.getObjectID();
                if (linkEndPointId.getClassName().equals(Location.class.getName())) {
                    LocationMapEditorView.this.actionDrillDown(linkEndPointId);
                } else {
                    LocationMapEditorView.this.actionConfigureEquipment(linkEndPointId);
                }
            }
        }

        public void mousePressed(MouseEvent ev) {
            log.debug((Object)("Caught mousePressed event. isPopupTrigger=" + ev.isPopupTrigger()));
            if (LocationMapEditorView.this.blockUserInteraction) {
                return;
            }
            if (ev.isPopupTrigger()) {
                Node selected = LocationMapEditorView.this.adapter.getSelectedEndPoint();
                LocationMapEditorView.this.actionShowCtxMenu(selected, ev);
            }
        }

        public void mouseReleased(MouseEvent ev) {
            log.debug((Object)("Caught mouseReleased event. isPopupTrigger=" + ev.isPopupTrigger()));
            if (LocationMapEditorView.this.blockUserInteraction) {
                return;
            }
            if (ev.isPopupTrigger()) {
                Node selected = LocationMapEditorView.this.adapter.getSelectedEndPoint();
                LocationMapEditorView.this.actionShowCtxMenu(selected, ev);
            }
        }
    }

    private class TopologyChangeListener
    implements MessageListener {
        private TopologyChangeListener() {
        }

        public void onMessage(Message msg) {
            try {
                if (LocationMapEditorView.this.shouldStop) {
                    return;
                }
                ObjectMessage objMsg = (ObjectMessage)msg;
                final TopologyChangeEvent evt = (TopologyChangeEvent)objMsg.getObject();
                UIEventThread.asyncExec(new Runnable(){

                    public void run() {
                        LocationMapEditorView.this.refreshVertex(evt.getVertex());
                    }
                });
            }
            catch (JMSException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkEndPointWrapper {
        Node vertex;
        LocationMapNodePosition lmEndPoint;
        boolean visible = false;

        public LinkEndPointWrapper(Node linkEndPoint, LocationMap map) {
            this.vertex = linkEndPoint;
            this.lmEndPoint = new LocationMapNodePosition();
            this.lmEndPoint.setObjectID(linkEndPoint.getObjectID());
            this.lmEndPoint.setX(100.0);
            this.lmEndPoint.setY(100.0);
            this.lmEndPoint.setHeight(20.0);
            this.lmEndPoint.setWidht(43.0);
            this.lmEndPoint.setLocationMap(map);
        }

        public void refreshVertex(Node vertex) {
            LinkEndPointWrapper other;
            ArrayList<Link> linksToRemove = new ArrayList<Link>();
            HashSet<Link> oldInbound = new HashSet<Link>(this.vertex.getInboundLinks());
            oldInbound.removeAll(vertex.getInboundLinks());
            for (Link link : oldInbound) {
                LinkEndPointWrapper wrapper = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(link.getAEndPoint());
                if (wrapper == null) continue;
                wrapper.getVertex().getOutboundLinks().remove(link);
            }
            HashSet<Link> oldOutbound = new HashSet<Link>(this.vertex.getOutboundLinks());
            oldInbound.removeAll(vertex.getOutboundLinks());
            for (Link link : oldOutbound) {
                LinkEndPointWrapper wrapper = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(link.getZEndPoint());
                if (wrapper == null) continue;
                wrapper.getVertex().getInboundLinks().remove(link);
            }
            linksToRemove.addAll(oldInbound);
            linksToRemove.addAll(oldOutbound);
            for (Link link : linksToRemove) {
                if (!LocationMapEditorView.this.adapter.containsLink(link.getLinkId())) continue;
                LocationMapEditorView.this.adapter.removeLink(link.getLinkId());
            }
            this.vertex = vertex;
            ArrayList<LinkEndPointWrapper> neighbours = new ArrayList<LinkEndPointWrapper>();
            for (Link link : vertex.getInboundLinks()) {
                other = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(link.getAEndPoint());
                if (other == null) continue;
                other.vertex.getOutboundLinks().add(link);
                neighbours.add(other);
            }
            for (Link link : vertex.getOutboundLinks()) {
                other = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(link.getZEndPoint());
                if (other == null) continue;
                other.vertex.getInboundLinks().add(link);
                neighbours.add(other);
            }
            this.vertex = vertex;
            if (this.isVisible()) {
                LocationMapEditorView.this.adapter.linkEndPointChanged(this.vertex);
            }
            neighbours.add(this);
            for (LinkEndPointWrapper wrapper : neighbours) {
                wrapper.refreshVisual();
            }
        }

        public void refreshVisual() {
            LinkEndPointWrapper other;
            ObjectID otherSide;
            if (!this.visible) {
                for (Link link : this.getAllLinks()) {
                    if (!LocationMapEditorView.this.adapter.containsLink(link.getLinkId())) continue;
                    LocationMapEditorView.this.adapter.removeLink(link.getLinkId());
                }
                if (LocationMapEditorView.this.adapter.containsEndPoint(this.vertex.getObjectID())) {
                    LocationMapEditorView.this.adapter.removeLinkEndPoint(this.vertex);
                }
                return;
            }
            if (!LocationMapEditorView.this.adapter.containsEndPoint(this.vertex.getObjectID())) {
                LocationMapEditorView.this.adapter.addLinkEndPoint(this.vertex, this.lmEndPoint.getX(), this.lmEndPoint.getY(), this.lmEndPoint.getWidht(), this.lmEndPoint.getHeight());
            }
            for (Link link : this.vertex.getInboundLinks()) {
                otherSide = link.getAEndPoint();
                other = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(otherSide);
                if (other == null || !other.isVisible()) continue;
                LocationMapEditorView.this.adapter.updateLink(link);
            }
            for (Link link : this.vertex.getOutboundLinks()) {
                otherSide = link.getAEndPoint();
                other = (LinkEndPointWrapper)LocationMapEditorView.this.wrappers.get(otherSide);
                if (other == null || !other.isVisible()) continue;
                LocationMapEditorView.this.adapter.updateLink(link);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            boolean refresh = (visible && LocationMapEditorView.this.shouldDisplayVertex(this)) != this.visible;
            boolean bl = this.visible = visible && LocationMapEditorView.this.shouldDisplayVertex(this);
            if (refresh) {
                this.refreshVisual();
            }
        }

        private List<Link> getAllLinks() {
            ArrayList<Link> links = new ArrayList<Link>();
            links.addAll(this.vertex.getOutboundLinks());
            links.addAll(this.vertex.getInboundLinks());
            return links;
        }

        public boolean updatePosition() {
            boolean cellMoved = false;
            if (LocationMapEditorView.this.adapter.containsEndPoint(this.lmEndPoint.getObjectID())) {
                Rectangle2D bounds = LocationMapEditorView.this.adapter.getLinkEndPointBounds(this.lmEndPoint.getObjectID());
                if (bounds.getX() != this.lmEndPoint.getX() || bounds.getY() != this.lmEndPoint.getY()) {
                    cellMoved = true;
                }
                this.lmEndPoint.setX(bounds.getX());
                this.lmEndPoint.setY(bounds.getY());
                this.lmEndPoint.setWidht(bounds.getWidth());
                this.lmEndPoint.setHeight(bounds.getHeight());
            }
            log.debug((Object)("updatePosition.cellMoved=" + cellMoved));
            return cellMoved;
        }

        public LocationMapNodePosition getLmEndPoint() {
            return this.lmEndPoint;
        }

        public Node getVertex() {
            return this.vertex;
        }
    }
}

