/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.locationmanager.LocationMapPluginUtil;
import com.bwanms.ui.components.ImagePanel;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jgraph.JGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMapEditorPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LocationMapEditorPanel.class);
    private JScrollPane jGraphScrollPane;
    private ImagePanel imagePanel;
    private JGraph jGraph;
    private JButton btnLevelUp;
    private JPanel panelFilters;
    private JLabel refreshLabel;
    private JPopupMenu ctxMenu;
    private HashSet<String> selectedFilters = new HashSet();
    private HashSet<String> filterClasses = new HashSet();
    private HashMap<String, JCheckBox> filterCheckBoxes = new HashMap();
    private ActionListener filterAreaListener;

    public LocationMapEditorPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.jGraphScrollPane = new JScrollPane();
        this.imagePanel = new ImagePanel();
        this.jGraph = new JGraph();
        this.btnLevelUp = new JButton();
        this.panelFilters = new JPanel();
        this.refreshLabel = new JLabel();
        this.ctxMenu = new JPopupMenu();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.PREF_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.imagePanel.setBackground(Color.white);
        this.imagePanel.setSizeToImage(true);
        this.imagePanel.setLayout(new BorderLayout());
        this.jGraph.setOpaque(false);
        this.jGraph.setComponentPopupMenu(null);
        this.jGraph.setMinimumSize(new Dimension(10, 10));
        this.imagePanel.add((Component)this.jGraph, "Center");
        this.jGraphScrollPane.setViewportView(this.imagePanel);
        this.add((Component)this.jGraphScrollPane, cc.xywh(1, 1, 1, 5));
        this.btnLevelUp.setText("LevelUp");
        this.add((Component)this.btnLevelUp, cc.xy(3, 1));
        this.panelFilters.setBorder(new TitledBorder("Display"));
        this.panelFilters.setLayout(new GridLayout(1, 1));
        this.add((Component)this.panelFilters, cc.xy(3, 5));
        this.refreshLabel.setText("RefreshingMap");
        this.refreshLabel.setForeground(Color.red);
        this.add((Component)this.refreshLabel, cc.xywh(1, 7, 2, 1));
    }

    private void postInitComponents() {
        this.refreshLabel.setVisible(false);
        i18n.getSwingInternationalizer().translateComponent(this);
        List<String> filter = LocationMapPluginUtil.getFilterClassNames();
        if (filter != null && filter.size() > 0) {
            this.panelFilters.setVisible(true);
            this.initializeFilterArea();
        } else {
            this.panelFilters.setVisible(false);
        }
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public JGraph getJGraph() {
        return this.jGraph;
    }

    public JButton getBtnLevelUp() {
        return this.btnLevelUp;
    }

    public JPopupMenu getCtxMenu() {
        return this.ctxMenu;
    }

    public JPanel getPanelFilters() {
        return this.panelFilters;
    }

    public JLabel getRefreshLabel() {
        return this.refreshLabel;
    }

    public Set<String> getSelectedFilters() {
        return (Set)this.selectedFilters.clone();
    }

    public void setSelectedFilters(Collection<String> selectedFilters) {
        this.selectedFilters.clear();
        this.selectedFilters.addAll(selectedFilters);
        for (String filterClass : this.filterCheckBoxes.keySet()) {
            JCheckBox filterCheckBox = this.filterCheckBoxes.get(filterClass);
            filterCheckBox.setSelected(selectedFilters.contains(filterClass));
        }
    }

    private void initializeFilterArea() {
        Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
        this.filterClasses.clear();
        this.filterClasses.addAll(LocationMapPluginUtil.getFilterClassNames());
        this.getPanelFilters().setLayout(new GridLayout(this.filterClasses.size(), 1, 5, 5));
        for (final String filterClass : this.filterClasses) {
            final JCheckBox filterCheckBox = new JCheckBox(i18n.translateString(filterClass));
            this.filterCheckBoxes.put(filterClass, filterCheckBox);
            filterCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (filterCheckBox.isSelected()) {
                        LocationMapEditorPanel.this.selectedFilters.add(filterClass);
                    } else {
                        LocationMapEditorPanel.this.selectedFilters.remove(filterClass);
                    }
                    if (LocationMapEditorPanel.this.filterAreaListener != null) {
                        LocationMapEditorPanel.this.filterAreaListener.actionPerformed(actionEvent);
                    }
                }
            });
            this.getPanelFilters().add(filterCheckBox);
        }
    }

    public void setFilterAreaListener(ActionListener filterAreaListener) {
        this.filterAreaListener = filterAreaListener;
    }

    public Set<String> getFilterClasses() {
        return this.filterClasses;
    }
}

