/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.locationmanager.LocationMapAssembly;
import com.bwanms.gui.locationmanager.LocationMapEditorView;
import com.bwanms.model.Location;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMapEditorContainer
extends EntityEditorContainer<Location> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LocationMapEditorContainer.class);
    private static final Logger log = Logger.getLogger(LocationMapEditorContainer.class);
    private IOWFormLauncher formLauncher;

    public LocationMapEditorContainer(Location entity) throws ServiceException {
        super(entity);
        this.form.getDefaultButton().setText(i18n.translateString("Save"));
        super.getFrame().setDefaultCloseOperation(0);
        WindowListener[] windowListeners = super.getFrame().getWindowListeners();
        for (int i = 0; i < windowListeners.length; ++i) {
            super.getFrame().removeWindowListener(windowListeners[i]);
        }
        super.getFrame().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                LocationMapEditorContainer.this.closeFrame();
            }
        });
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Location)this.getEntity()).getId()) + "MAP";
    }

    @Override
    public EditorView<Location> initView() {
        return new LocationMapEditorView(this);
    }

    @Override
    public String getTitle() {
        return i18n.translateString("LocationMap");
    }

    void changeEntity(Location entity) {
        super.setEntity(entity);
        if (this.view != null) {
            this.view.setEntity(entity);
            this.form.getErrorReportEditorPane1().setTitle(i18n.translateString("CurrentMap", entity.getName()));
        }
    }

    @Override
    protected void saveEntity() throws ServiceException {
        Location savedLocation = (Location)ServiceRegistry.getEntityManagerService().save(this.getEntity());
        super.setEntity(savedLocation);
        LocationMapEditorView mapView = (LocationMapEditorView)this.view;
        mapView.setEntity(savedLocation);
    }

    @Override
    protected Location loadEntity(Location entity) throws ServiceException {
        LocationMapAssembly assembly;
        if (null != entity && entity.getId() > 0L && (assembly = (LocationMapAssembly)ServiceRegistry.getEntityManagerService().get(Location.class, entity.getId(), "Editor")) != null) {
            return (Location)assembly.getEntity();
        }
        return entity;
    }

    @Override
    public void actionOKPerformed() {
        LocationMapEditorView mapView = (LocationMapEditorView)this.view;
        mapView.setDirty(false);
        if (this.save() != null) {
            MessageBox.Info.quickShow(i18n.translateString("MapSavedMessage"));
        }
    }

    @Override
    public void actionCancelPerformed() {
        this.closeFrame();
    }

    @Override
    public void closeFrame() {
        if (!this.view.close() && Security.getSecurity().checkPermissions(this.view.getApplicationPermission(), "write")) {
            int result = MessageBox.ConfirmWithCancel.showOption(this.form, i18n.translateString("SaveConfirmation", ((Location)this.getEntity()).getName()));
            if (result == 2) {
                return;
            }
            if (result == 0) {
                LocationMapEditorView mapView = (LocationMapEditorView)this.view;
                mapView.setDirty(false);
                if (this.save() == null) {
                    log.debug((Object)"Error saving map before closing");
                }
            }
        }
        this.cleanup();
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Location.class.getName());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Location)this.getEntity()).getName() : "";
    }

    public IOWFormLauncher getFormLauncher() {
        return this.formLauncher;
    }

    public void setFormLauncher(IOWFormLauncher formLauncher) {
        this.formLauncher = formLauncher;
    }
}

