/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.configuration.ItemFormatter;
import com.bwanms.gui.locationmanager.LocationManagerResultsTreeForm;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.model.Location;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManagerResultsTreeView
implements ManagerResultsView {
    private static final Logger log = Logger.getLogger(LocationManagerResultsTreeView.class);
    private LocationManagerResultsTreeForm form;
    private Vector<ResultsViewListener> listeners = new Vector();
    private List<EntityManagerRow> displayData;
    private Action defaultActionListener;
    private Location rootLocation;
    private String filter;
    private long pariaId;
    private Map<Location, EntityManagerRow> rowMap = new HashMap<Location, EntityManagerRow>();
    FilteredTreeModel treeModel;

    public LocationManagerResultsTreeView(long pariaId) {
        this.pariaId = pariaId;
        this.rootLocation = new Location();
        this.rootLocation.setName("root");
        this.form = new LocationManagerResultsTreeForm(this);
        this.initForm();
        this.updateTree();
    }

    public int getPageSize() {
        return 0;
    }

    @Override
    public EntityQuerySort getEntityQuerySort() {
        return null;
    }

    @Override
    public void setEntityQueryResults(EntityQueryResults data) {
        if (null == data) {
            this.displayData = new Vector<EntityManagerRow>();
            this.rowMap.clear();
        } else {
            this.displayData = data.getData();
        }
        this.updateTableData();
        this.resultListSelectionChanged(null);
    }

    private void updateTableData() {
        LinkedHashSet<Location> rootChildren = new LinkedHashSet<Location>();
        for (EntityManagerRow data : this.displayData) {
            Location location = (Location)data.getEntity();
            this.rowMap.put(location, data);
            if (location.getParent() != null) continue;
            rootChildren.add(location);
            log.debug((Object)("[TREE]-" + location.getName()));
            log.debug((Object)("[TREE]  +-" + location.getChildren().size() + "children"));
        }
        this.rootLocation.setChildren(rootChildren);
        this.updateTree();
    }

    private void updateTree() {
        LocationTreeNode rootNode = new LocationTreeNode(this.rootLocation);
        this.treeModel = new FilteredTreeModel(rootNode, this.filter, this.pariaId);
        this.form.getTree().setModel(this.treeModel);
        this.expandAll();
    }

    private void expandAll() {
        if (this.filter != null && !this.filter.equals("")) {
            int rc;
            do {
                for (int x = rc = this.form.getTree().getRowCount(); x >= 0; --x) {
                    this.form.getTree().expandRow(x);
                }
            } while (rc < this.form.getTree().getRowCount());
        }
    }

    @Override
    public List<EntityManagerRow> getSelection() {
        TreePath[] selectedPaths;
        int[] selectedRows = this.form.getTree().getSelectionRows();
        if (null == selectedRows) {
            return null;
        }
        if (selectedRows.length == 1) {
            Location loc = ((LocationTreeNode)this.form.getTree().getLastSelectedPathComponent()).getLocation();
            EntityManagerRow row = this.rowMap.get(loc);
            if (row != null) {
                ArrayList<EntityManagerRow> result = new ArrayList<EntityManagerRow>(1);
                result.add(row);
                log.debug((Object)("--SELECTED-- " + loc.getName()));
                return result;
            }
            return null;
        }
        Vector<EntityManagerRow> selection = new Vector<EntityManagerRow>(selectedRows.length);
        for (TreePath selectedPath : selectedPaths = this.form.getTree().getSelectionPaths()) {
            Location loc = ((LocationTreeNode)selectedPath.getLastPathComponent()).getLocation();
            EntityManagerRow row = this.rowMap.get(loc);
            if (row == null) continue;
            selection.add(this.rowMap.get(loc));
            log.debug((Object)("--SELECTED-- " + loc.getName()));
        }
        return selection;
    }

    @Override
    public void addResultsAreaListener(ResultsViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeResultsAreaListener(ResultsViewListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public JComponent getUI() {
        this.resultListSelectionChanged(null);
        return this.form;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return "Results";
    }

    @Override
    public void entityChanged(EntityManagerRow row) {
        Location location = (Location)row.getEntity();
        this.displayData.add(row);
        this.rowMap.put(location, row);
        this.updateRootTree(row, 1);
    }

    @Override
    public void entityAdded(EntityManagerRow row) {
        Location addedLocation = (Location)row.getEntity();
        if (null == this.displayData) {
            this.displayData = new Vector<EntityManagerRow>(1);
        }
        this.displayData.add(row);
        this.rowMap.put(addedLocation, row);
        LocationTreeNode parentNode = addedLocation.getParent() != null ? this.treeModel.findNode(addedLocation.getParent().getId()) : (LocationTreeNode)this.treeModel.getRoot();
        if (parentNode == null) {
            throw new IllegalArgumentException("Missing parent node.");
        }
        LocationTreeNode newNode = new LocationTreeNode(addedLocation);
        this.treeModel.insertNewNode(newNode, parentNode);
        TreePath newPath = new TreePath(this.treeModel.getPathToRoot(newNode));
        this.form.getTree().scrollPathToVisible(newPath);
        this.updateRootTree(row, 0);
    }

    @Override
    public void entityRemoved(Serializable entity) {
        Location location = (Location)entity;
        if (null != this.displayData) {
            for (EntityManagerRow row : this.displayData) {
                TreePath[] paths;
                Location loc = (Location)row.getEntity();
                if (loc.getId() != location.getId()) continue;
                this.displayData.remove(row);
                this.rowMap.remove(location);
                this.deleteFromParent(loc);
                LocationTreeNode node = null;
                for (TreePath path : paths = this.form.getTree().getSelectionPaths()) {
                    LocationTreeNode treeNode = (LocationTreeNode)path.getLastPathComponent();
                    if (treeNode.getLocation() != location) continue;
                    node = treeNode;
                }
                this.treeModel.removeNodeFromParent(node);
                this.rootLocation.getChildren().remove(location);
                break;
            }
        }
    }

    private void initForm() {
        this.form.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                LocationManagerResultsTreeView.this.resultListSelectionChanged(e);
            }
        });
        this.form.getTree().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (2 == arg0.getClickCount() && LocationManagerResultsTreeView.this.form.getTree().getPathForLocation(arg0.getX(), arg0.getY()) != null) {
                    LocationManagerResultsTreeView.this.defaultActionListener.actionPerformed(new ActionEvent(arg0.getSource(), arg0.getID(), null));
                }
            }
        });
        this.form.setItemFormatter(new ItemFormatter(){

            public String format(Object value) {
                return ((LocationTreeNode)value).getText();
            }
        });
    }

    private void deleteFromParent(Location location) {
        Location parent = location.getParent();
        if (parent == null) {
            return;
        }
        for (EntityManagerRow row : this.displayData) {
            Location crtLocation = (Location)row.getEntity();
            if (crtLocation.getId() != parent.getId()) continue;
            crtLocation.getChildren().remove(location);
            location.setParent(null);
            return;
        }
    }

    private void updateRootTree(EntityManagerRow row, int updateType) {
        if (row == null) {
            return;
        }
        Location location = (Location)row.getEntity();
        Location root = null;
        for (Location parent = location; parent != null; parent = parent.getParent()) {
            root = parent;
        }
        if (root.getId() != this.rootLocation.getId()) {
            switch (updateType) {
                case 0: {
                    if (location.getParent() == null) {
                        this.rootLocation.getChildren().add(location);
                        break;
                    }
                    long parentId = location.getParent().getId();
                    Location newParent = this.rootLocation.findLocation(parentId);
                    location.setParent(newParent);
                    if (newParent == null) break;
                    newParent.getChildren().add(location);
                    break;
                }
                case 1: {
                    LocationTreeNode changedNode;
                    Location oldLocation = this.rootLocation.findLocation(location.getId());
                    Location oldParent = oldLocation.getParent();
                    Location parent = location.getParent();
                    if (oldParent == null) {
                        oldParent = this.rootLocation;
                    }
                    oldParent.getChildren().remove(oldLocation);
                    location.setChildren(oldLocation.getChildren());
                    if (oldParent == this.rootLocation && parent == null || parent != null && oldParent.getId() == parent.getId()) {
                        location.setParent(oldParent);
                        oldParent.getChildren().add(location);
                        changedNode = this.treeModel.findNode(location.getId());
                        this.treeModel.changeNode(changedNode, location);
                    } else if (oldParent != parent) {
                        LocationTreeNode oldParentNode;
                        Location newParent = parent != null ? this.rootLocation.findLocation(parent.getId()) : this.rootLocation;
                        location.setParent(newParent);
                        newParent.getChildren().add(location);
                        this.updateTree();
                        if (oldParent != null && (oldParentNode = this.treeModel.findNode(oldParent.getId())) != null) {
                            TreePath oldParentPath = new TreePath(this.treeModel.getPathToRoot(oldParentNode));
                            this.form.getTree().scrollPathToVisible(oldParentPath);
                            this.form.getTree().expandPath(oldParentPath);
                        }
                    }
                    changedNode = this.treeModel.findNode(location.getId());
                    if (changedNode != null) {
                        this.form.getTree().scrollPathToVisible(new TreePath(this.treeModel.getPathToRoot(changedNode)));
                    }
                    this.displayData.remove(this.rowMap.get(oldLocation));
                }
            }
        }
    }

    private void resultListSelectionChanged(TreeSelectionEvent arg0) {
        for (ResultsViewListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    @Override
    public void updateContextMenu(List<JMenuItem> menuItems) {
        this.form.getPopup().removeAll();
        for (JMenuItem item : menuItems) {
            if (null != item) {
                this.form.getPopup().add(item);
                continue;
            }
            this.form.getPopup().addSeparator();
        }
    }

    @Override
    public void setDefaultActionListener(Action listener) {
        this.defaultActionListener = listener;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        if (this.treeModel != null) {
            this.treeModel.setFilter(filter);
        }
        this.expandAll();
    }

    public void filter(String filter) {
        this.setFilter(filter);
    }

    @Override
    public List<EntityManagerRow> getData() {
        ArrayList<EntityManagerRow> rows = new ArrayList<EntityManagerRow>(this.rowMap.size());
        rows.addAll(this.rowMap.values());
        return rows;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocationTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<LocationTreeNode> {
        private static final long serialVersionUID = 8485865259102758319L;

        public LocationTreeNode(Location location) {
            this.setLocation(location);
        }

        @Override
        public LocationTreeNode getParent() {
            return (LocationTreeNode)super.getParent();
        }

        @Override
        public Location getUserObject() {
            return (Location)super.getUserObject();
        }

        public void setUserObject(Location location) {
            super.setUserObject(location);
        }

        public Location getLocation() {
            return this.getUserObject();
        }

        public void setLocation(Location location) {
            this.setUserObject(location);
        }

        public long getLocationId() {
            Location location = this.getLocation();
            if (location != null) {
                return location.getId();
            }
            return -1L;
        }

        public String getText() {
            Location location = this.getLocation();
            if (location != null) {
                return location.getName();
            }
            return "";
        }

        @Override
        public int compareTo(LocationTreeNode o) {
            return this.getText().compareTo(o.getText());
        }
    }

    private class FilteredTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 4403810002203381497L;
        private String filter;
        private boolean sortAscending;
        private long pariaId;

        public FilteredTreeModel(LocationTreeNode rootNode, String filter, long pariaId) {
            this(rootNode, filter, pariaId, true);
        }

        public FilteredTreeModel(LocationTreeNode rootNode, String filter, long pariaId, boolean sortAscending) {
            super(rootNode);
            this.filter = filter;
            this.pariaId = pariaId;
            this.sortAscending = sortAscending;
            this.root = this.newNodeFrom(rootNode.getLocation());
        }

        private LocationTreeNode newNodeFrom(Location location) {
            LocationTreeNode newChild = new LocationTreeNode(location);
            if (location != null && location.getChildren().size() > 0) {
                for (Location locationChild : location.getChildren()) {
                    if (locationChild.getId() == this.pariaId) continue;
                    LocationTreeNode newGrandChild = this.newNodeFrom(locationChild);
                    this.addChildInOrder(newGrandChild, newChild);
                }
            }
            return newChild;
        }

        public void insertNewNode(LocationTreeNode newChild, LocationTreeNode parent) {
            if (newChild == null) {
                throw new IllegalArgumentException("new child is null");
            }
            if (parent != null) {
                this.addChildInOrder(newChild, parent);
            }
        }

        public void changeNode(LocationTreeNode node, Location newLocation) {
            if (node == null) {
                return;
            }
            LocationTreeNode parentNode = node.getParent();
            Location parentLocation = newLocation.getParent();
            String oldText = node.getText();
            node.setLocation(newLocation);
            if (parentNode == null && parentLocation == null || parentNode.getLocationId() == parentLocation.getId()) {
                boolean sort;
                boolean bl = sort = !oldText.equals(node.getText());
                if (sort && parentNode != null) {
                    this.removeNodeFromParent(node);
                    this.addChildInOrder(node, parentNode);
                }
            }
        }

        public LocationTreeNode findNode(long locationId) {
            LocationTreeNode rootNode = (LocationTreeNode)this.getRoot();
            if (rootNode == null) {
                return null;
            }
            Enumeration<TreeNode> nodes = rootNode.breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                LocationTreeNode node = (LocationTreeNode)nodes.nextElement();
                if (locationId != node.getLocationId()) continue;
                return node;
            }
            return null;
        }

        public boolean isNodeValid(LocationTreeNode node) {
            return node.getChildCount() > 0 || this.filter == null || this.filter.equals("") || node.getText().indexOf(this.filter) >= 0;
        }

        public void removeNodeFromParent(LocationTreeNode node) {
            LocationTreeNode parentNode = node.getParent();
            super.removeNodeFromParent(node);
            this.removeInvalidBranchNodes(parentNode);
        }

        private void removeInvalidBranchNodes(LocationTreeNode node) {
            if (node == null) {
                return;
            }
            LocationTreeNode parentNode = node.getParent();
            while (!this.isNodeValid(node)) {
                if (parentNode == null) {
                    this.setRoot(null);
                    return;
                }
                this.removeNodeFromParent(node);
                node = parentNode;
                parentNode = node.getParent();
            }
        }

        public void setFilter(String filter) {
            if (this.root != null && this.filter != filter) {
                this.filter = filter;
                this.setRoot(this.newNodeFrom(((LocationTreeNode)this.root).getLocation()));
            }
        }

        private void addChildInOrder(LocationTreeNode newChild, LocationTreeNode parent) {
            if (!this.isNodeValid(newChild) || parent == null) {
                return;
            }
            boolean indexFound = false;
            int index = -1;
            for (int i = 0; i < parent.getChildCount() && !indexFound; ++i) {
                int compare = newChild.compareTo((LocationTreeNode)parent.getChildAt(i));
                if ((!this.sortAscending || compare >= 0) && (this.sortAscending || compare <= 0)) continue;
                index = i;
                indexFound = true;
            }
            if (!indexFound) {
                index = parent.getChildCount();
            }
            super.insertNodeInto(newChild, parent, index);
        }
    }
}

