/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.locationmanager.LocationEditorContainer;
import com.bwanms.gui.locationmanager.LocationManagerResultsTreeView;
import com.bwanms.gui.locationmanager.LocationMapEditorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.EntityQueryStrategyBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.NullNavigatorView;
import com.bwanms.legacy.OwareUIUtil;
import com.bwanms.model.Location;
import com.bwanms.model.ObjectID;
import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.Assembly;
import com.bwanms.persistence.Datastore;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(LocationManagerConfig.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(LocationManagerConfig.class);
    private static String[] columnNames = new String[]{"Name"};
    private static String[] columnAttribNames = new String[]{"Name"};
    private List<EntityManagerColumn> columns;
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private long pariaId;
    private boolean isMultipleSelect = false;

    public LocationManagerConfig() {
        this(null);
    }

    public LocationManagerConfig(String userData) {
        if (userData != null) {
            if (userData.equals("multipleSelect")) {
                this.isMultipleSelect = true;
                this.pariaId = 0L;
            } else {
                try {
                    this.pariaId = Long.parseLong(userData);
                }
                catch (Exception ex) {
                    throw new RuntimeException("INVALID USER DATA", ex);
                }
            }
        }
        this.columns = new Vector<EntityManagerColumn>();
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), null));
        this.entityRowProvider = new LocationRowCreator();
        this.filterCriteria = new Vector();
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new LocationManagerAction("New", 1));
        this.defaultAction = new LocationManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new LocationManagerAction("Delete", 1));
        this.declaredActions.add(new LocationManagerAction("AddChild", 1));
        this.declaredActions.add(new LocationManagerAction("OpenMap", 1));
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new LocationQueryStrategy();
    }

    @Override
    public ManagerResultsView getResultsView() {
        return new LocationManagerResultsTreeView(this.pariaId);
    }

    @Override
    public NavigatorView getNavigatorView() {
        return new NullNavigatorView();
    }

    @Override
    protected String getBaseName() {
        return Location.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(4);
            this.declaredActions.remove(3);
            this.declaredActions.remove(2);
            this.declaredActions.remove(0);
        }
        this.defaultAction = new LocationManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    @Override
    public String getTitle() {
        return i18n.translateString("LocationManager");
    }

    @Override
    public String getHelpTopic() {
        return "location_manager";
    }

    private static class LocationQueryStrategy
    extends EntityQueryStrategyBase {
        private static final long serialVersionUID = -848805700744947973L;

        private LocationQueryStrategy() {
        }

        public EntityQueryResults performQuery(EntityQueryFilter filter, EntityQuerySort sort, int pageSize, int pageNumber) {
            List queryResult = Datastore.session().createQuery("from " + Location.class.getName()).list();
            log.debug((Object)("--LOCATION-- queryResultSize: " + queryResult.size()));
            ArrayList<EntityManagerRow> result = new ArrayList<EntityManagerRow>();
            this.rowCreator = filter.getEntityRowCreator();
            for (Location res : queryResult) {
                if (res.getParent() == null) {
                    this.fillChildren(res);
                }
                result.add(this.rowCreator.createRow(res));
            }
            return new EntityQueryResults(result);
        }

        public EntityQueryResults getPage(int pageNumber) {
            return null;
        }

        public void closeQuery() {
        }

        private void fillChildren(Location res) {
            for (Location location : res.getChildren()) {
                this.fillChildren(location);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocationRowCreator
    extends EntityManagerRowProviderBase
    implements Assembler<Location> {
        private static final long serialVersionUID = -171076222124137930L;
        private static List<String> colAttrNames = new ArrayList<String>(LocationManagerConfig.access$300().length);

        public LocationRowCreator() {
            super(new ArrayList<String>(colAttrNames));
        }

        @Override
        protected List<Serializable> readAttributeValues(Serializable entity) {
            List<Serializable> ret = super.readAttributeValues(entity);
            return ret;
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((Location)entity).getId());
        }

        @Override
        public Assembly<Location> getAssembly(Location entity) throws ServiceException {
            return this.createRow(entity);
        }

        @Override
        public EntityManagerRow createRow(Serializable entity) {
            Location loc;
            for (Location parent = loc = (Location)entity; parent != null; parent = parent.getParent()) {
                parent.getName();
                if (loc.getId() != parent.getId()) continue;
                parent.getChildren().size();
            }
            return super.createRow(entity);
        }

        static {
            for (String attrName : columnAttribNames) {
                colAttrNames.add(attrName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocationManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public LocationManagerAction(String name, int category) {
            this(name, category, null);
        }

        public LocationManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            List<Serializable> selection = manager.getSelection();
            EntityChangeListener listener = null;
            if (manager instanceof EntityChangeListener) {
                listener = (EntityChangeListener)((Object)manager);
            }
            if ("New".equals(this.name)) {
                try {
                    new LocationEditorContainer(new Location(), listener, 0);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(LocationManagerConfig.this.getNavigatorView().getUI(), ex.getMessage());
                }
            } else if ("Open".equals(this.name) && selection.size() == 1) {
                try {
                    new LocationEditorContainer((Location)selection.get(0), listener, 1);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(LocationManagerConfig.this.getNavigatorView().getUI(), ex.getMessage());
                }
            } else if ("AddChild".equals(this.name) && selection.size() == 1) {
                Location loc = (Location)selection.get(0);
                Location child = new Location();
                child.setParent(loc);
                try {
                    new LocationEditorContainer(child, listener, 0);
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(LocationManagerConfig.this.getNavigatorView().getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (FrameUtil.showConfirmation(manager.getUI())) {
                    final LinkedHashSet<Location> locations = new LinkedHashSet<Location>();
                    for (Serializable loc : selection) {
                        locations.add((Location)loc);
                    }
                    Iterator it = locations.iterator();
                    block9: while (it.hasNext()) {
                        Serializable loc;
                        Serializable parent = loc = (Location)it.next();
                        while ((parent = ((Location)parent).getParent()) != null) {
                            if (!locations.contains(parent)) continue;
                            it.remove();
                            continue block9;
                        }
                    }
                    AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                        public String getTitle() {
                            return i18n.translateString("LongOpTitle");
                        }

                        public boolean isCancelable() {
                            return true;
                        }

                        public long getMaxProgress() {
                            return locations.size();
                        }

                        public void run() {
                            long progress = 0L;
                            EntityChangeListener listener = null;
                            if (manager instanceof EntityChangeListener) {
                                listener = (EntityChangeListener)((Object)manager);
                            }
                            for (Location loc : locations) {
                                if (this.shouldCancel) {
                                    this.monitor.logMessage(i18n.translateString("Canceled"));
                                    break;
                                }
                                Object[] locationName = new Object[]{loc.getName()};
                                String message = i18n.translateString("DeletingLocation", locationName);
                                this.monitor.updateProgress(progress, message);
                                try {
                                    ServiceRegistry.getEntityManagerService().delete(loc.getClass(), Long.valueOf(loc.getId()));
                                    if (loc.getParent() != null) {
                                        ServiceRegistry.getTopologyManagerService().topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(loc.getParent().getId())));
                                    }
                                    if (listener != null) {
                                        listener.entityRemoved(loc);
                                    }
                                    this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", locationName));
                                    log.debug((Object)("Deleted location: " + loc.getName()));
                                }
                                catch (ServerValidationException e) {
                                    this.monitor.logMessage(i18n.translateString("DeletingError", loc.getName(), e.getInvalidValues().get(0).getMessage()));
                                    log.debug((Object)e, (Throwable)e);
                                }
                                catch (Exception e) {
                                    this.monitor.logMessage(i18n.translateString("DeletingError", loc.getName(), e.getMessage()));
                                    log.debug((Object)e, (Throwable)e);
                                }
                                this.monitor.updateProgress(++progress, message);
                            }
                            this.monitor.operationCompleted(false);
                        }
                    };
                    LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
                }
            } else if ("Select".equals(this.name) && LocationManagerConfig.this.isMultipleSelect) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            } else if ("OpenMap".equals(this.name)) {
                Location location = (Location)selection.get(0);
                try {
                    LocationMapEditorContainer container = new LocationMapEditorContainer(location);
                    container.setFormLauncher(OwareUIUtil.getCurrentFormLauncher(manager.getUI()));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(null, ex.getMessage());
                }
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureLocations", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    return selectionSize == 1;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureLocations", "delete")) {
                        return false;
                    }
                    return selectionSize > 0;
                }
                if (this.name.equals("Select")) {
                    if (LocationManagerConfig.this.isMultipleSelect) {
                        return selectionSize > 0;
                    }
                    return selectionSize == 1;
                }
                if (this.name.equals("AddChild")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureLocations", "add")) {
                        return false;
                    }
                    return selectionSize == 1;
                }
                if (this.name.equals("OpenMap")) {
                    if (!Security.getSecurity().checkPermissions("Av:Topology", "execute")) {
                        return false;
                    }
                    return selectionSize == 1;
                }
            }
            return true;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }
    }
}

