/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.locationmanager;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.locationmanager.LocationMapAssembly;
import com.bwanms.gui.locationmanager.LocationView;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.Location;
import com.bwanms.model.ObjectID;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationEditorContainer
extends EntityEditorContainer<Location> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LocationEditorContainer.class);
    private EntityChangeListener<Serializable> changeListener;
    private int changeMode;
    private Location oldParent;

    public LocationEditorContainer(Location location) throws ServiceException {
        this(location, null, -1);
    }

    public LocationEditorContainer(Location location, EntityChangeListener<Serializable> listener, int changeMode) throws ServiceException {
        super(location);
        this.changeListener = listener;
        this.changeMode = changeMode;
        this.oldParent = location.getParent();
    }

    @Override
    protected Location loadEntity(Location entity) throws ServiceException {
        LocationMapAssembly assembly;
        if (null != entity && entity.getId() > 0L && (assembly = (LocationMapAssembly)ServiceRegistry.getEntityManagerService().get(Location.class, entity.getId(), "Editor")) != null) {
            return (Location)assembly.getEntity();
        }
        return entity;
    }

    @Override
    protected void saveEntity() throws ServiceException {
        Location savedLocation = (Location)ServiceRegistry.getEntityManagerService().save(this.getEntity());
        if (this.changeListener != null) {
            if (this.changeMode == 0) {
                this.changeListener.entityAdded(savedLocation);
            } else if (this.changeMode == 1) {
                this.changeListener.entityChanged(savedLocation);
            }
        }
        if (((Location)this.getEntity()).getParent() != null) {
            ServiceRegistry.getTopologyManagerService().topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(((Location)this.getEntity()).getParent().getId())));
        }
        if (this.oldParent != null) {
            ServiceRegistry.getTopologyManagerService().topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(this.oldParent.getId())));
        }
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Location)this.getEntity()).getId());
    }

    @Override
    protected EditorView<Location> initView() {
        return new LocationView();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("LocationEditor");
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Location)this.getEntity()).getName() : "null";
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Location.class.getName());
    }

    public void setEntityChangeListener(EntityChangeListener<Serializable> listener, int changeMode) {
        this.changeListener = listener;
        this.changeMode = changeMode;
    }
}

