/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.licensemanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.model.license.License;
import com.bwanms.model.license.LicenseFeature;
import com.bwanms.model.license.LicenseFeatureNodeLock;
import com.bwanms.model.license.LicenseFeatureTimed;
import com.bwanms.model.license.LicenseFeatureUsable;
import com.bwanms.model.license.LicenseStateEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class LicenseTreeCellRenderer
implements TreeCellRenderer {
    private Internationalizer ddiI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LicenseTreeCellRenderer.class);
    private Icon licenseOk = new ImageIcon(this.getClass().getResource("license_ok.gif"));
    private Icon licenseWithExpiration = new ImageIcon(this.getClass().getResource("license_with_expiration.gif"));
    private Icon licenseInvalid = new ImageIcon(this.getClass().getResource("license_invalid.gif"));
    private Icon featureRegular = new ImageIcon(this.getClass().getResource("regular_feature.gif"));
    private Icon featureUsable = new ImageIcon(this.getClass().getResource("usable_feature.gif"));
    private Icon featureTimed = new ImageIcon(this.getClass().getResource("timed_feature.gif"));
    private Icon featureNodeLock = new ImageIcon(this.getClass().getResource("nodelock_feature.gif"));
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    private LicenseRenderer licenseRenderer = new LicenseRenderer();

    public LicenseTreeCellRenderer() {
        this.ddiI18n = this.ddiI18n;
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        value = UIManager.get("Tree.drawDashedFocusIndicator");
        this.drawDashedFocusIndicator = value != null && (Boolean)value != false;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.licenseRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private class LicenseRenderer
    extends JLabel
    implements TreeCellRenderer {
        public LicenseRenderer() {
            super.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setFont(tree.getFont());
            this.setForeground(selected ? LicenseTreeCellRenderer.this.textSelectionColor : LicenseTreeCellRenderer.this.textNonSelectionColor);
            this.setBackground(selected ? LicenseTreeCellRenderer.this.backgroundSelectionColor : LicenseTreeCellRenderer.this.backgroundNonSelectionColor);
            String text = null;
            Icon icon = null;
            if (value instanceof LicenseFeatureUsable) {
                LicenseFeatureUsable lfu = (LicenseFeatureUsable)value;
                text = LicenseTreeCellRenderer.this.ddiI18n.translateString(lfu.getName()) + " (" + lfu.getQuantity() + ") " + i18n.translateString("Usage", lfu.getUsageCount());
                icon = UIIconFactory.getIconForClass(lfu.getName());
            } else if (value instanceof LicenseFeatureNodeLock) {
                LicenseFeatureNodeLock lf = (LicenseFeatureNodeLock)value;
                text = "Node Lock: " + lf.getMacAddressList().toString() + ", " + lf.getIpAddressList().toString();
                icon = LicenseTreeCellRenderer.this.featureNodeLock;
            } else if (value instanceof LicenseFeatureTimed) {
                LicenseFeatureTimed lf = (LicenseFeatureTimed)value;
                text = i18n.translateString("Expires", new Date(lf.getLicense().getInstallDate() + lf.getExpiration()));
                icon = LicenseTreeCellRenderer.this.featureTimed;
            } else if (value instanceof LicenseFeature) {
                LicenseFeature lf = (LicenseFeature)value;
                text = lf.getName();
                icon = LicenseTreeCellRenderer.this.featureRegular;
            } else if (value instanceof License) {
                License lic = (License)value;
                text = i18n.translateString("License", lic.getCustomerName(), new Date(lic.getInstallDate()), LicenseStateEnum.toString(lic.getState())) + " " + i18n.translateString(lic.isActive() ? "active" : "inactive");
                switch (lic.getState()) {
                    case 1: 
                    case 2: {
                        icon = LicenseTreeCellRenderer.this.licenseInvalid;
                        break;
                    }
                    case 0: {
                        icon = LicenseTreeCellRenderer.this.licenseOk;
                        for (LicenseFeature feature : lic.getLicenseFeatures()) {
                            if (!(feature instanceof LicenseFeatureTimed)) continue;
                            icon = LicenseTreeCellRenderer.this.licenseWithExpiration;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid license state: " + lic.getState()));
                    }
                }
            }
            this.setIcon(icon);
            this.setText(text);
            return this;
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        public void repaint() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

