/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.licensemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.licensemanager.LicenseManagerResultViewTreeModel;
import com.bwanms.gui.licensemanager.LicenseManagerResultsPanel;
import com.bwanms.gui.licensemanager.LicenseTreeCellRenderer;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.model.license.License;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseManagerResultsView
implements ManagerResultsView {
    private LicenseManagerResultsPanel ui;
    private LicenseManagerResultViewTreeModel model;
    private ArrayList<ResultsViewListener> listeners = new ArrayList();
    private HashMap<License, EntityManagerRow> rowMap = new HashMap();

    @Override
    public EntityQuerySort getEntityQuerySort() {
        return null;
    }

    @Override
    public void setEntityQueryResults(EntityQueryResults data) {
        ArrayList<License> licenses = new ArrayList<License>();
        this.rowMap.clear();
        for (EntityManagerRow row : data.getData()) {
            License license = (License)row.getEntity();
            if (license.getState() == 3) continue;
            licenses.add((License)row.getEntity());
            this.rowMap.put((License)row.getEntity(), row);
        }
        this.model.setLicenses(licenses);
        this.fireSelectionChanged();
    }

    @Override
    public List<EntityManagerRow> getSelection() {
        ArrayList<EntityManagerRow> selection = new ArrayList<EntityManagerRow>(5);
        TreePath[] selectionPaths = this.ui.getLicenseTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return selection;
        }
        TreePath[] arr$ = selectionPaths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EntityManagerRow row;
            TreePath selectionPath;
            for (selectionPath = arr$[i$]; selectionPath != null && !(selectionPath.getLastPathComponent() instanceof License); selectionPath = selectionPath.getParentPath()) {
            }
            if (selectionPath == null || selection.contains(row = this.rowMap.get((License)selectionPath.getLastPathComponent()))) continue;
            selection.add(row);
        }
        return selection;
    }

    @Override
    public void addResultsAreaListener(ResultsViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeResultsAreaListener(ResultsViewListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public JComponent getUI() {
        this.model = new LicenseManagerResultViewTreeModel();
        this.ui = new LicenseManagerResultsPanel();
        this.ui.getLicenseTree().setCellRenderer(new LicenseTreeCellRenderer());
        this.ui.getLicenseTree().setModel(this.model);
        this.fireSelectionChanged();
        return this.ui;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void updateContextMenu(List<JMenuItem> menuItems) {
        this.ui.getPopup().removeAll();
        for (JMenuItem item : menuItems) {
            if (null != item) {
                this.ui.getPopup().add(item);
                continue;
            }
            this.ui.getPopup().addSeparator();
        }
    }

    @Override
    public void setDefaultActionListener(Action listener) {
    }

    @Override
    public void entityChanged(EntityManagerRow row) {
    }

    @Override
    public void entityAdded(EntityManagerRow row) {
        this.model.addLicense((License)row.getEntity());
        this.rowMap.put((License)row.getEntity(), row);
    }

    @Override
    public void entityRemoved(Serializable entity) {
        this.model.removeLicense((License)entity);
        this.rowMap.remove((License)entity);
    }

    private void fireSelectionChanged() {
        for (ResultsViewListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    @Override
    public List<EntityManagerRow> getData() {
        ArrayList<EntityManagerRow> rows = new ArrayList<EntityManagerRow>(this.rowMap.size());
        rows.addAll(this.rowMap.values());
        return rows;
    }

    public Set<License> getRowSet() {
        return this.rowMap.keySet();
    }
}

