/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.licensemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.licensemanager.LicenseManagerResultsView;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.model.license.License;
import com.bwanms.model.license.LicenseFeatureTimed;
import com.bwanms.model.license.LicensingInfo;
import com.bwanms.security.Security;
import com.bwanms.services.InvalidLicenseFileException;
import com.bwanms.services.LicenseAlreadyImportedException;
import com.bwanms.services.LicenseManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IOUtil;
import com.bwanms.util.MessageBox;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(LicenseManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(LicenseManagerConfig.class);
    private EntityManagerRowProvider entityRowProvider;
    private String[] columnNames = new String[]{"CustomerName", "InstallDate"};
    private String[] columnAttribNames = new String[]{"CustomerName", "InstallDate"};
    List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private LicenseManagerResultsView licenseManagerResultsView;

    public LicenseManagerConfig() {
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), null));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), null));
        this.entityRowProvider = new LicenseRowCreator(LicenseManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new LicenseManagerAction("Add", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new LicenseManagerAction("Activate", 1));
        this.declaredActions.add(new LicenseManagerAction("LicensingInformation", 1));
    }

    @Override
    protected String getBaseName() {
        return License.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public ManagerResultsView getResultsView() {
        this.licenseManagerResultsView = new LicenseManagerResultsView();
        return this.licenseManagerResultsView;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("LicenseManager");
    }

    @Override
    public String getHelpTopic() {
        return "ngnms.help.license";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LicenseRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -788838584578897504L;

        public LicenseRowCreator(List<String> attributes) {
            super(attributes);
        }

        public EntityManagerRow createNewRow(Serializable entity) {
            return super.createRow(entity);
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((License)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LicenseManagerAction
    extends ManagerAction {
        public LicenseManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public void performAction(ManagerView manager) {
            List<Serializable> selection = manager.getSelection();
            if ("Delete".equals(this.name) && !selection.isEmpty() && MessageBox.Confirm.showResult(manager.getUI(), i18n.translateString("AreYouSure"))) {
                LicenseManagerService licSvc = ServiceRegistry.getLicenseManagerService();
                for (Serializable row : selection) {
                    License license = (License)row;
                    try {
                        licSvc.deleteLicense(license.getId());
                        if (manager instanceof EntityChangeListener) {
                            EntityChangeListener listener = (EntityChangeListener)((Object)manager);
                            listener.entityRemoved(row);
                        }
                        log.info((Object)i18n.translateString("SuccessfullyDeleted", license.getCustomerName()));
                    }
                    catch (ServiceException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if ("Add".equals(this.name)) {
                JFileChooser selectFile = new JFileChooser();
                selectFile.setMultiSelectionEnabled(false);
                String KEY_EXT = "key";
                ExtensionFileFilter fileFilter = new ExtensionFileFilter();
                fileFilter.addExtension("key");
                fileFilter.setDescription(i18n.translateString("LicenseFiles", "*.key"));
                selectFile.setFileFilter(fileFilter);
                int ret = selectFile.showOpenDialog(manager.getUI());
                if (ret == 0) {
                    File selectedFile = selectFile.getSelectedFile();
                    int MAX_FILE_LENGTH = 10240;
                    if (selectedFile.length() > 10240L) {
                        String message = i18n.translateString("FileLengthError", 10240, selectedFile.length());
                        String title = i18n.translateString("ImportFileError", selectedFile.getName());
                        this.showMessage(manager.getUI(), message, title, null, 0);
                        return;
                    }
                    LicenseManagerService licSvc = ServiceRegistry.getLicenseManagerService();
                    License license = null;
                    try {
                        FileInputStream in = new FileInputStream(selectedFile);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtil.copyStream(in, out, 2048);
                        ((InputStream)in).close();
                        out.close();
                        license = licSvc.addLicense(out.toByteArray());
                        log.info((Object)i18n.translateString("SuccessfullyImported", selectedFile.getAbsolutePath()));
                    }
                    catch (ServiceException e) {
                        boolean error = true;
                        String message = e.getMessage();
                        if (message == null) {
                            if (e instanceof InvalidLicenseFileException) {
                                message = i18n.translateString("InvalidLicenseFileException", selectedFile.getName());
                            } else if (e instanceof LicenseAlreadyImportedException) {
                                message = i18n.translateString("LicenseAlreadyImportedException");
                                error = false;
                            } else {
                                message = e.getClass().getName();
                            }
                        }
                        if (error) {
                            String title = i18n.translateString("ImportingFileError", selectedFile.getName());
                            this.showMessage(manager.getUI(), message, title, e, 0);
                        } else {
                            String title = i18n.translateString("ImportFileError", selectedFile.getName());
                            this.showMessage(manager.getUI(), message, title, e, 2);
                        }
                        return;
                    }
                    catch (IOException e) {
                        String title = i18n.translateString("ImportingFileError", selectedFile.getName());
                        String message = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
                        this.showMessage(manager.getUI(), message, title, e, 0);
                        return;
                    }
                    ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "LicenseImported", "License", license.getCustomerName(), "License");
                    if (manager instanceof EntityChangeListener) {
                        EntityChangeListener listener = (EntityChangeListener)((Object)manager);
                        listener.entityAdded(((LicenseRowCreator)LicenseManagerConfig.this.entityRowProvider).createNewRow(license).getEntity());
                    }
                }
            } else if ("Activate".equals(this.name)) {
                if (!selection.isEmpty()) {
                    License lastSelectedLicense = (License)selection.get(selection.size() - 1);
                    if (!lastSelectedLicense.isActive()) {
                        License currentActiveNonAditiveLicense = null;
                        LicenseFeatureTimed currentExpirationFeature = null;
                        for (License lic : LicenseManagerConfig.this.licenseManagerResultsView.getRowSet()) {
                            if (!lic.isActive() || lic.isAdditive()) continue;
                            currentActiveNonAditiveLicense = lic;
                        }
                        if (currentActiveNonAditiveLicense != null) {
                            for (String key : currentActiveNonAditiveLicense.getLicenseFeaturesMap().keySet()) {
                                if (!key.startsWith("Duration")) continue;
                                currentExpirationFeature = (LicenseFeatureTimed)currentActiveNonAditiveLicense.getLicenseFeaturesMap().get(key);
                            }
                        }
                        LicenseFeatureTimed lastSelectedExpirationFeature = null;
                        for (String key : lastSelectedLicense.getLicenseFeaturesMap().keySet()) {
                            if (!key.startsWith("Duration")) continue;
                            lastSelectedExpirationFeature = (LicenseFeatureTimed)lastSelectedLicense.getLicenseFeaturesMap().get(key);
                        }
                        if (lastSelectedLicense.isAdditive()) {
                            this.activateLicense(lastSelectedLicense.getId(), manager);
                        } else {
                            String message = i18n.translateString("ActivatingALicenseWillDeactivateAllOtherLicenses");
                            if (lastSelectedExpirationFeature != null && currentActiveNonAditiveLicense != null && (currentExpirationFeature == null || lastSelectedLicense.getInstallDate() + lastSelectedExpirationFeature.getExpiration() < currentActiveNonAditiveLicense.getInstallDate() + currentExpirationFeature.getExpiration())) {
                                message = message + "\n" + i18n.translateString("YouAreAboutToActivateAnOlderLicense");
                            }
                            if (MessageBox.Confirm.showResult(manager.getUI(), message)) {
                                this.activateLicense(lastSelectedLicense.getId(), manager);
                            }
                        }
                        ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "LicenseActivated", "License", lastSelectedLicense.getCustomerName(), "License");
                    }
                } else {
                    MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("PleaseSelectALicense"));
                }
            } else if ("LicensingInformation".equals(this.name)) {
                LicensingInfo licensingInfo = null;
                try {
                    licensingInfo = ServiceRegistry.getLicenseManagerService().getLicensingInfo();
                }
                catch (ServiceException e) {
                    // empty catch block
                }
                if (licensingInfo != null) {
                    String ipList = new String("");
                    for (String ip : licensingInfo.getServerIpAddress()) {
                        ipList = ipList + ip + "; ";
                    }
                    String macList = new String("");
                    for (String mac : licensingInfo.getServerMacAddress()) {
                        macList = macList + mac + "; ";
                    }
                    FrameUtil.showConfirmation(manager.getUI(), i18n.translateString("ServerIpMac", ipList, macList), i18n.translateString("ServerInfo"));
                } else {
                    FrameUtil.showConfirmation(manager.getUI(), i18n.translateString("Error"));
                }
            }
        }

        private void activateLicense(long licenseId, ManagerView manager) {
            LicenseManagerService licSvc = ServiceRegistry.getLicenseManagerService();
            try {
                licSvc.activateLicense(licenseId);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
            finally {
                manager.performQuery();
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Add")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureLicenses", "add")) {
                    return false;
                }
            } else if (this.name.equals("Activate")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureLicenses", "write")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    return 0 < selectionSize;
                }
            }
            return true;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }

        private void showMessage(JComponent parentComponent, String message, String title, Throwable t, int messageType) {
            MessageBox box;
            log.debug((Object)(title + ": " + message), t);
            if (t != null && ExceptionUtil.getMessage(t) != null) {
                message = ExceptionUtil.getMessage(t);
            }
            switch (messageType) {
                case 0: {
                    box = MessageBox.Error;
                    break;
                }
                case 2: {
                    box = MessageBox.WarnConfirm;
                    break;
                }
                case 1: {
                    box = MessageBox.Info;
                    break;
                }
                default: {
                    box = MessageBox.Alert;
                }
            }
            box.showOption(parentComponent, message, title);
        }
    }
}

