/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.inventory;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.gui.inventory.EquipmentEditor;
import com.bwanms.util.FrameUtil;
import com.dorado.common.widget.components.OWFCParentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NewEquipmentTypeSelectorForm
extends JPanel {
    Logger log = Logger.getLogger(this.getClass());
    private Map<String, Object> optionsMap = new TreeMap<String, Object>();
    JList equipmentTypeList = new JList();
    JButton btnOK = new JButton("OK");
    JButton btnCancel = new JButton("Cancel");

    public NewEquipmentTypeSelectorForm() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.equipmentTypeList, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(4));
        buttonsPanel.add(this.btnOK);
        buttonsPanel.add(this.btnCancel);
        this.add((Component)buttonsPanel, "South");
        List<String> topLevelEquipmentClsNames = DDRegistry.getInstance().getTopLevelEquipmentClassNames();
        for (String equipmentClassName : topLevelEquipmentClsNames) {
            String equipmentDisplayName = equipmentClassName.substring(equipmentClassName.lastIndexOf(46) + 1);
            this.optionsMap.put(equipmentDisplayName, equipmentClassName);
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String key : this.optionsMap.keySet()) {
            model.addElement(key);
        }
        this.equipmentTypeList.setModel(model);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewEquipmentTypeSelectorForm.this.btnOKAction();
            }
        });
        this.equipmentTypeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    NewEquipmentTypeSelectorForm.this.btnOKAction();
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewEquipmentTypeSelectorForm.this.btnCancelAction();
            }
        });
    }

    public static void showDialog(JComponent parent) {
        Window parentWin = SwingUtilities.getWindowAncestor(parent);
        JDialog dialog = parentWin instanceof Frame ? new JDialog((Frame)parentWin, "Equipment Type") : new JDialog((Dialog)parentWin, "Equipment Type");
        dialog.setLayout(new BorderLayout());
        dialog.add(new NewEquipmentTypeSelectorForm());
        dialog.setSize(140, 200);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    private void btnOKAction() {
        String selection = (String)this.equipmentTypeList.getSelectedValue();
        if (null != selection) {
            String selectedEquipmentClassName = (String)this.optionsMap.get(selection);
            try {
                EquipmentEditor equipmentCreateDialog = (EquipmentEditor)Class.forName("com.bwanms.rb.gui.inventory.NewRbEquipmentEditor").newInstance();
                equipmentCreateDialog.setSelectedEquipmentClass(selectedEquipmentClassName);
                equipmentCreateDialog.launchEditor(SwingUtilities.getWindowAncestor(this.getRootPane()));
                this.doClose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void btnCancelAction() {
        this.doClose();
    }

    private void doClose() {
        if (this.getParent() instanceof OWFCParentPanel) {
            ((OWFCParentPanel)this.getParent()).getFormLauncher().removeSelectedPanel();
        } else {
            ((Dialog)SwingUtilities.getWindowAncestor(this.getParent())).setVisible(false);
        }
    }

    public static void main(String[] args) {
        NewEquipmentTypeSelectorForm panel = new NewEquipmentTypeSelectorForm();
        JFrame frame = FrameUtil.createFrame();
        frame.setSize(400, 400);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
    }
}

