/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.help.local;

import com.bwanms.gui.help.HelpUtil;
import com.bwanms.util.Settings;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import org.apache.log4j.Logger;

public class HelpUtilLocal
extends HelpUtil {
    private static final Logger log = Logger.getLogger(HelpUtilLocal.class);
    private Help help = null;

    private void configure() throws Exception {
        Class<?> htmlBrowserClass = null;
        try {
            htmlBrowserClass = Class.forName("oracle.help.htmlBrowser.ICEBrowser");
        }
        catch (Exception e) {
            htmlBrowserClass = null;
            log.error((Object)"ChoiceDemo : Failed to load ICEBrowser");
        }
        this.help = new Help(htmlBrowserClass, false, true, false, true);
        String homeDir = Settings.instance().getApplicationDir();
        File helpDir = new File(homeDir, "help");
        for (File dir : helpDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            File[] hsFiles = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().toLowerCase().endsWith(".hs");
                }
            });
            for (int i = 0; i < hsFiles.length; ++i) {
                log.info((Object)("Adding [" + hsFiles[i].getAbsolutePath() + "]"));
                URL helpHsUrl = hsFiles[i].toURL();
                HelpSet helpSet = new HelpSet(helpHsUrl);
                this.help.addBook((Book)helpSet);
            }
        }
    }

    public void showHelpImpl(String helpTopic) {
        if (this.help == null) {
            try {
                this.configure();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        log.info((Object)("Show help [" + helpTopic + "]"));
        this.help.showTopic(null, helpTopic, false);
    }

    public void showHelp() {
        this.help.showNavigatorWindow();
    }
}

