/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.help;

import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.PlatformConfiguration;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class HelpUtil {
    private static final Logger log = Logger.getLogger(HelpUtil.class);
    private static final String DEFAULT_TOPIC = "NgnmsGeneralHelp";
    private static Properties helpTopics;
    private static HelpUtil instance;

    public static HelpUtil getInstance() {
        if (instance == null) {
            try {
                instance = (HelpUtil)PlatformConfiguration.instance().getHelpUtilImpl().newInstance();
                HelpUtil.configure();
            }
            catch (Exception e) {
                log.error((Object)"Could not initialize help", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    private static void configure() {
        helpTopics = new Properties();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.help");
        for (IConfigurationElement configElement : extensionPoint.getConfigurationElements()) {
            try {
                Properties props = new Properties();
                String bundle = configElement.getAttribute("lookupFile").replace('.', '/') + ".properties";
                log.debug((Object)("Loading [" + bundle + "]"));
                props.load(HelpUtil.class.getClassLoader().getResourceAsStream(bundle));
                for (Object key : props.keySet()) {
                    String keyStr = (String)key;
                    helpTopics.setProperty(keyStr, props.getProperty(keyStr));
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void showHelp(String helpTopic) {
        log.debug((Object)("showHelp [" + helpTopic + "]"));
        helpTopic = helpTopics.getProperty(helpTopic, DEFAULT_TOPIC);
        this.showHelpImpl(helpTopic);
    }

    public abstract void showHelpImpl(String var1);

    public abstract void showHelp();

    static {
        instance = null;
    }
}

