/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.AllEquipmentManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentStateEnum;
import com.bwanms.model.Location;
import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentRowProvider
extends EntityManagerRowProviderBase {
    public static Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentRowProvider.class);

    @Override
    protected List<Serializable> readAttributeValues(Serializable entity) {
        List<Serializable> ret = super.readAttributeValues(entity);
        ret.set(1, (Serializable)((Object)entity.getClass().getName()));
        ret.set(3, null != ret.get(3) ? new IpAddress((String)((Object)ret.get(3))) : null);
        ret.set(4, (Serializable)((Object)(null != ret.get(4) ? ((Location)ret.get(4)).getName() : null)));
        boolean licensed = LicenseHelper.isLicensed(entity);
        if (!licensed) {
            ret.set(5, null);
        }
        return ret;
    }

    public EquipmentRowProvider(List<String> attributes) {
        super(attributes);
    }

    @Override
    public List<String> getDisplayValues(EntityManagerRow entityRow) {
        List<String> ret = super.getDisplayValues(entityRow);
        ret.set(1, AllEquipmentManagerConfig.ddI18N.translateString(ret.get(1)));
        Integer state = (Integer)entityRow.getAttributeValue(5);
        if (null == state) {
            ret.set(5, i18n.translateString("Unlicensed"));
        } else {
            ret.set(5, i18n.translateString(EquipmentStateEnum.toString(state)));
        }
        return ret;
    }

    @Override
    protected String readEntityId(Serializable entity) {
        return String.valueOf(((Equipment)entity).getId());
    }
}

