/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.Manageable;
import com.bwanms.model.ObjectID;
import com.bwanms.security.Security;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import java.awt.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentEditorContainer
extends EntityEditorContainer<Equipment> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentEditorContainer.class);
    private Equipment addedEquipment = null;
    private Location oldLocation = null;
    private EntityChangeListener<Equipment> entityChangeCallback;

    public EquipmentEditorContainer(Equipment equipment) throws ServiceException {
        this(equipment, null, null);
    }

    public EquipmentEditorContainer(Window owner, Equipment equipment) throws ServiceException {
        this(equipment, owner, null);
    }

    public EquipmentEditorContainer(Window owner, Equipment equipment, EntityChangeListener<Equipment> entityChangeCallback) throws ServiceException {
        this(equipment, owner, entityChangeCallback);
    }

    public EquipmentEditorContainer(Equipment equipment, EntityChangeListener<Equipment> entityChangeCallback) throws ServiceException {
        this(equipment, null, entityChangeCallback);
    }

    public EquipmentEditorContainer(Equipment equipment, Window owner, EntityChangeListener<Equipment> entityChangeCallback) throws ServiceException {
        super(equipment, owner);
        this.entityChangeCallback = entityChangeCallback;
        this.oldLocation = equipment != null ? equipment.getLocation() : null;
    }

    @Override
    protected void saveEntity() throws ServiceException {
        if (((Equipment)this.getEntity()).getId() != 0L) {
            Equipment equip = (Equipment)ServiceRegistry.getEntityManagerService().save(this.getEntity());
            if (equip != null && this.entityChangeCallback != null) {
                this.entityChangeCallback.entityChanged(equip);
            }
        } else {
            this.addedEquipment = DDRegistry.getInstance().createEquipment(((Manageable)this.getEntity()).getManagementInterface(), ((Equipment)this.getEntity()).getClass().getName(), ((Equipment)this.getEntity()).getName());
            this.addedEquipment.setLocation(((Equipment)this.getEntity()).getLocation());
            this.addedEquipment.setContact(((Equipment)this.getEntity()).getContact());
            Equipment equip = null;
            try {
                equip = ServiceRegistry.getEntityManagerService().save(this.addedEquipment);
            }
            catch (EntityAlreadyExistsException e) {
                MessageBox.Error.quickShow(this.getForm(), i18n.translateString("BsWithThatIpAddressAlreadyDefined"));
            }
            if (equip != null) {
                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EquipmentCreate", "EquipmentManagement", equip.getName(), equip.getClass().getName());
            }
            if (this.entityChangeCallback != null) {
                this.entityChangeCallback.entityAdded(equip);
            }
        }
        if (this.oldLocation != null) {
            ServiceRegistry.getTopologyManagerService().topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(this.oldLocation.getId())));
        }
    }

    @Override
    public void actionCancelPerformed() {
        this.closeFrame();
    }

    public void onSaveErrors() {
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Equipment)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Equipment)this.getEntity()).getName() : "null";
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Equipment.class.getName());
    }

    @Override
    protected EditorView<Equipment> initView() {
        return EditorPluginUtil.getViewForClass(((Equipment)this.getEntity()).getClass());
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EquipmentEditor");
    }

    public Equipment getAddedEquipment() {
        return this.addedEquipment;
    }
}

