/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.gui.equipmentmanager.CraftConnectivityTest;
import com.bwanms.gui.equipmentmanager.CraftConnectivityTestPanel;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.ui.platform.UIBackgroundJob;
import java.util.List;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftSnmpConnectivityTestJob
extends UIBackgroundJob {
    List<SNMPManagementInterface> managementInterfaces;
    List<String> names;
    CraftConnectivityTestPanel cctp;
    boolean toClose;

    public CraftSnmpConnectivityTestJob(List<SNMPManagementInterface> managementInterfaces, List<String> names, CraftConnectivityTestPanel cctp) {
        this.managementInterfaces = managementInterfaces;
        this.names = names;
        this.cctp = cctp;
        this.toClose = false;
    }

    public CraftSnmpConnectivityTestJob(List<SNMPManagementInterface> managementInterfaces, List<String> names) {
        this.managementInterfaces = managementInterfaces;
        this.names = names;
        this.cctp = null;
        this.toClose = false;
    }

    @Override
    public void run() {
        int i = 0;
        DefaultTableModel tblModel = (DefaultTableModel)this.cctp.getTable1().getModel();
        for (SNMPManagementInterface managementInterface : this.managementInterfaces) {
            if (this.toClose) {
                tblModel.setValueAt((Object)Result.Skipped, i, 2);
                tblModel.setValueAt((Object)Result.Skipped, i, 3);
                ++i;
                continue;
            }
            CraftConnectivityTest test = new CraftConnectivityTest(managementInterface);
            int testResult = test.runTest();
            if (testResult == 0) {
                tblModel.setValueAt((Object)Result.OK, i, 2);
                tblModel.setValueAt((Object)Result.OK, i, 3);
            } else if (testResult == 1) {
                tblModel.setValueAt((Object)Result.TimedOut, i, 2);
                tblModel.setValueAt((Object)Result.Skipped, i, 3);
            } else if (testResult == 2) {
                tblModel.setValueAt((Object)Result.OK, i, 2);
                tblModel.setValueAt((Object)Result.Failed, i, 3);
            }
            ++i;
        }
    }

    public void setCctp(CraftConnectivityTestPanel cctp) {
        this.cctp = cctp;
    }

    public void close() {
        this.toClose = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        OK,
        Failed,
        TimedOut,
        Skipped;


        public String toString() {
            return "Result." + this.name();
        }
    }
}

