/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.craft.CraftMain2;
import com.bwanms.gui.Application;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.equipmentmanager.EquipmentManagerApplication;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerForm;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.TypeManagerView;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.ui.platform.UIBackgroundJob;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CraftEquipmentManagerApplication
implements Application {
    private static Logger logger = Logger.getLogger(TypeManagerView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentManagerApplication.class);
    EntityManagerView view;
    Class<? extends EntityManagerConfig> entityConfigClass;

    public View createView() {
        this.initEntities();
        try {
            this.view = new EntityManagerView(this.entityConfigClass.newInstance()){
                UIBackgroundJob performQuery;
                {
                    this.performQuery = new UIBackgroundJob(){

                        public void run() {
                            try {
                                Thread.sleep(5000L);
                                while (form.isShowing() || CraftMain2.mainFrame != null && CraftMain2.mainFrame.isMadeInvisible()) {
                                    this.performQuery();
                                    Thread.sleep(5000L);
                                }
                            }
                            catch (InterruptedException ie) {
                                logger.info((Object)"Retrive interrupted", (Throwable)ie);
                            }
                            catch (Exception e) {
                                logger.info((Object)"Retrive quited", (Throwable)e);
                            }
                        }
                    };
                }

                public JComponent getUI() {
                    this.form = (EntityManagerForm)super.getUI();
                    this.form.getBtnRefresh().setVisible(false);
                    if (!this.performQuery.isScheduled() && !this.performQuery.isAlive()) {
                        this.performQuery.schedule();
                    }
                    return this.form;
                }

                public void performQuery() {
                    this.saveSettings();
                    if (null != this.filterView) {
                        try {
                            this.filterView.prepareFilter();
                        }
                        catch (InvalidFilterValueException ifve) {
                            logger.error((Object)ifve, (Throwable)ifve);
                            return;
                        }
                    }
                    try {
                        this.mediator.performQuery();
                    }
                    catch (Throwable t) {
                        logger.error((Object)t, t);
                    }
                }
            };
        }
        catch (NullPointerException e) {
            logger.error((Object)"Plugin Error!", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            logger.error((Object)"Plugin Error!", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Plugin Error!", (Throwable)e);
            return null;
        }
        return this.view;
    }

    public void initEntities() {
        block3: {
            try {
                IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
                IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.managerTypes");
                if (null == extensionPoint) break block3;
                for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                    String crtManagerName = element.getAttribute("managerName");
                    if (!crtManagerName.startsWith("CraftEquipment")) continue;
                    String entityConfigClass = element.getAttribute("entityConfigClass");
                    this.entityConfigClass = Class.forName(entityConfigClass);
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                return;
            }
        }
    }

    public KeyStroke getAccelerator() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public int getMnemonic() {
        return 0;
    }

    public String getName() {
        return i18n.translateString("CraftEquipmentManagerApplication");
    }

    public String getTitle() {
        return i18n.translateString("CraftEquipmentManager");
    }

    public boolean isCraftAllowed() {
        return true;
    }

    public boolean isEnterpriseAllowed() {
        return false;
    }

    public boolean isMultiInstance() {
        return false;
    }
}

