/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.model.SNMPManagementInterface;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class CraftConnectivityTest {
    private static final Logger log = Logger.getLogger(CraftConnectivityTest.class);
    public static final int NO_ERROR = 0;
    public static final int READ_ERROR = 1;
    public static final int WRITE_ERROR = 2;
    private Snmp snmp;
    Address targetAddress;
    CommunityTarget target;
    private String ip;
    private String writeCommunity;
    private String readCommunity;
    private int port;
    private Long timeout;
    private Integer retries;
    private int version;

    public CraftConnectivityTest() {
        this.ip = "0.0.0.0";
        this.readCommunity = "public";
        this.writeCommunity = "private";
        this.port = 161;
        this.timeout = 5000L;
        this.retries = 2;
        this.version = 0;
    }

    public CraftConnectivityTest(SNMPManagementInterface managementInterface) {
        this.ip = managementInterface.getIp();
        this.readCommunity = managementInterface.getReadCommunity();
        this.writeCommunity = managementInterface.getWriteCommunity();
        this.port = managementInterface.getPort();
        this.timeout = managementInterface.getTimeout();
        this.retries = managementInterface.getRetries();
        this.version = managementInterface.getVersion();
    }

    public CraftConnectivityTest(String IpAddress2, String readCommunity, String writeCommunity, Long timeout, Integer retries, int version) {
        this.ip = IpAddress2;
        this.readCommunity = readCommunity;
        this.writeCommunity = writeCommunity;
        this.timeout = timeout;
        this.retries = retries;
        this.version = version;
    }

    private void initializeSession(String address) throws IOException {
        this.targetAddress = GenericAddress.parse((String)address);
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp((TransportMapping)transport);
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        transport.listen();
    }

    private void setCommunity(String community) {
        this.target.setCommunity(new OctetString(community));
    }

    private void setParams() {
        this.target = new CommunityTarget();
        this.target.setCommunity(new OctetString("public"));
        this.target.setAddress(this.targetAddress);
        this.target.setRetries(this.retries.intValue());
        this.target.setTimeout(this.timeout.longValue());
        this.target.setVersion(this.version);
    }

    private VariableBinding sendAndGet(String community) throws IOException {
        this.setCommunity(community);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 5, 0})));
        pdu.setType(-96);
        ResponseEvent response = this.snmp.send(pdu, (Target)this.target);
        PDU responsePDU = response.getResponse();
        if (responsePDU == null) {
            return null;
        }
        if (responsePDU.getErrorStatus() != 0) {
            return null;
        }
        VariableBinding varBind = responsePDU.get(0);
        return varBind;
    }

    private boolean sendAndSet(VariableBinding varBind, String community) throws IOException {
        PDU pdu = new PDU();
        this.setCommunity(community);
        pdu.add(varBind);
        pdu.setType(-93);
        ResponseEvent response = this.snmp.set(pdu, (Target)this.target);
        PDU responsePDU = response.getResponse();
        if (responsePDU == null) {
            return false;
        }
        return responsePDU.getErrorStatus() == 0;
    }

    public int runTest() {
        boolean write = false;
        try {
            this.initializeSession("udp:" + this.ip + "/" + this.port);
            this.setParams();
            VariableBinding varBind = this.sendAndGet(this.readCommunity);
            if (varBind == null) {
                return 1;
            }
            write = this.sendAndSet(varBind, this.writeCommunity);
            if (!write) {
                return 2;
            }
            return 0;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 1;
        }
    }

    public static void main(String[] args) {
        CraftConnectivityTest test = new CraftConnectivityTest();
        boolean write = false;
        try {
            test.initializeSession("udp:192.168.200.4/161");
            test.setParams();
            VariableBinding varBind = test.sendAndGet("public");
            if (varBind == null) {
                log.info((Object)"Error reading or device unreachable");
                return;
            }
            write = test.sendAndSet(varBind, "private");
            if (!write) {
                log.info((Object)"Error writing, but reading ok");
                return;
            }
            log.info((Object)"\nReading and writing communities are OK!\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

