/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import au.com.bytecode.opencsv.CSVReader;
import com.bwanms.craft.CraftFrame;
import com.bwanms.craft.CraftMain2;
import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.AllEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.EquipmentEditorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.EntityManagerSortByIdNoUI;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.IconEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.NullNavigatorView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentStateEnum;
import com.bwanms.model.Task;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.CutThroughPluginUtil;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MessageBox;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CraftBaseStationManagerConfig
extends AbstractEquipmentManagerConfig {
    private static final Logger logger = Logger.getLogger(CraftBaseStationManagerConfig.class);
    private static final Internationalizer i18nCraft = Internationalizer.getInternationalizer(CraftFrame.class);
    private JFrame frame = FrameUtil.createFrame();
    protected List<ManagerAction> declaredActions;
    protected ManagerAction defaultAction;
    protected KeyAdapter theListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JComponent comp = (JComponent)e.getComponent();
                if (comp.getTopLevelAncestor() instanceof JFrame) {
                    JFrame frame = (JFrame)comp.getTopLevelAncestor();
                    frame.dispose();
                } else if (comp.getTopLevelAncestor() instanceof JDialog) {
                    JDialog dialog = (JDialog)comp.getTopLevelAncestor();
                    dialog.dispose();
                }
                CraftMain2.mainFrame.setVisible(true);
            }
        }
    };

    public CraftBaseStationManagerConfig(int maxSelection) {
        super(maxSelection);
        this.updateActions();
        this.Columns();
        this.initEntityRowProvider();
        this.filterCriteria = null;
    }

    public CraftBaseStationManagerConfig() {
        this.updateActions();
        this.Columns();
        this.initEntityRowProvider();
        this.filterCriteria = null;
    }

    public int getMaxDevices() {
        return 1000;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    protected void updateActions() {
        this.declaredActions = new ArrayList<ManagerAction>();
        this.declaredActions.add(new CraftEquipmentManagerAction("New", 1));
        this.defaultAction = new CraftEquipmentManagerAction("Configure", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new CraftEquipmentManagerAction("Edit", 1));
        this.declaredActions.add(new CraftEquipmentManagerAction("Delete", 1));
        this.declaredActions.add(new CraftEquipmentManagerAction("TelnetCutThrough", 1));
        this.declaredActions.add(new CraftEquipmentManagerAction("Export", 1));
        this.declaredActions.add(new CraftEquipmentManagerAction("Import", 1));
    }

    protected abstract void performActionNew(ManagerView var1);

    protected void performActionConfigure(ManagerView manager) {
        List<Serializable> selection = manager.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Equipment equipment = (Equipment)selection.get(0);
        ConfigApplicationView configAppView = new ConfigApplicationView(equipment);
        if (null == configAppView.getConfiguration()) {
            throw new RuntimeException("Configuration does not exist for equipment with euid = " + equipment.getEUID());
        }
        this.initConfigureContainer(equipment, configAppView, manager, null, null);
        FrameUtil.addKeyListenerRecursively(this.frame, this.theListener);
    }

    protected abstract void performActionAutoDiscovery(ManagerView var1);

    protected abstract void performActionTestConnectivity(ManagerView var1);

    protected void performActionEdit(ManagerView manager) {
        List<Serializable> selection = manager.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            if (selection.size() == 1) {
                EquipmentEditorContainer editorContainer;
                if (manager instanceof EntityChangeListener) {
                    editorContainer = new EquipmentEditorContainer((JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), (Equipment)selection.get(0), (EntityChangeListener<Equipment>)((EntityChangeListener)((Object)manager)));
                    this.removeFromEditorPanel(editorContainer);
                } else {
                    editorContainer = new EquipmentEditorContainer((JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), (Equipment)selection.get(0));
                    this.removeFromEditorPanel(editorContainer);
                }
                FrameUtil.addKeyListenerRecursively(editorContainer.getFrame(), this.theListener);
            }
        }
        catch (ServiceException ex) {
            MessageBox.Error.quickShow(null, ex.getMessage());
        }
    }

    protected abstract void removeFromEditorPanel(EquipmentEditorContainer var1);

    protected void performActionDelete(final ManagerView manager) {
        final List<Serializable> selection = manager.getSelection();
        if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
            return;
        }
        final EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
        AbstractLongOperation deleteOperation = new AbstractLongOperation(){

            public String getTitle() {
                return AbstractEquipmentManagerConfig.i18n.translateString("DeleteEquipment");
            }

            public boolean isCancelable() {
                return true;
            }

            public long getMaxProgress() {
                return selection.size();
            }

            public void run() {
                long progress = 0L;
                for (Serializable row : selection) {
                    if (this.shouldCancel) {
                        this.monitor.logMessage(AbstractEquipmentManagerConfig.i18n.translateString("Canceled"));
                        break;
                    }
                    Equipment eq = (Equipment)row;
                    this.monitor.updateProgress(progress, AbstractEquipmentManagerConfig.i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                    try {
                        try {
                            String ip = new IpAddress(eq.getIpAddr()).toString();
                            entityService.delete(eq);
                            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EquipmentDelete", "EquipmentManagement", eq.getName(), eq.getClass().getName());
                            List<Task> tasks = ServiceRegistry.getTaskManagerService().retrieveTasks();
                            for (Task task : tasks) {
                                if (!task.getName().equalsIgnoreCase(ip)) continue;
                                ServiceRegistry.getTaskManagerService().deleteTask(task.getId());
                            }
                        }
                        catch (ServiceException e) {
                            this.monitor.logMessage(AbstractEquipmentManagerConfig.i18n.translateString("ErrorDeleting", eq.getName(), eq.getEUID(), e.getMessage()));
                            logger.debug((Object)e, (Throwable)e);
                            if (++progress != this.getMaxProgress()) continue;
                            this.monitor.updateProgress(progress, AbstractEquipmentManagerConfig.i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                            continue;
                        }
                        if (manager instanceof EntityChangeListener) {
                            manager.performQuery();
                        }
                        this.monitor.logMessage(AbstractEquipmentManagerConfig.i18n.translateString("SuccesfullyDeleted", eq.getName(), eq.getEUID()));
                    }
                    catch (Throwable t) {
                        this.monitor.logMessage(AbstractEquipmentManagerConfig.i18n.translateString("ErrorDeleting", eq.getName(), eq.getEUID(), t.getMessage()));
                        logger.debug((Object)t, t);
                    }
                    this.monitor.updateProgress(++progress, AbstractEquipmentManagerConfig.i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                }
                this.monitor.operationCompleted(false);
            }
        };
        LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
    }

    protected void performActionTelnetCutThrough(ManagerView manager) {
        List<Serializable> selection = manager.getSelection();
        try {
            CutThroughPluginUtil.performCutThrough((Equipment)selection.get(0));
        }
        catch (CutThroughNotSupportedException e) {
            MessageBox.Alert.quickShow(e.getMessage());
        }
        catch (Exception e) {
            MessageBox.Error.quickShow("Failed to launch cut through!");
        }
    }

    protected void performActionExport(ManagerView manager) {
        List<Serializable> selection = manager.getSelection();
        File exportFile = FormUtil.getExportFile("csv", manager.getUI());
        if (exportFile != null) {
            boolean overwriteExistingFile = false;
            if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult(manager.getUI(), i18n.translateString("ExportFileReplacingConfirmation", exportFile.getAbsolutePath()), i18n.translateString("ExportEquipmentTitle")))) {
                logger.info((Object)i18n.translateString("ExportFileReplacingRejected", exportFile.getAbsolutePath()));
                return;
            }
            try {
                this.exportEquipments(((EntityManagerView)manager).getSelectionData(), exportFile);
                logger.info((Object)i18n.translateString("EquipmentExported", selection.size(), exportFile.getAbsolutePath()));
            }
            catch (IOException e) {
                logger.debug((Object)"Export equipments error", (Throwable)e);
                MessageBox.Error.showResult(manager.getUI(), i18n.translateString("ExportEquipmentError", e.getMessage()), i18n.translateString("ExportEquipmentTitle"));
            }
        }
    }

    protected abstract void exportEquipments(List<EntityManagerRow> var1, File var2) throws IOException;

    protected void performActionImport(ManagerView manager) {
        File exportFile = FormUtil.getImportFile("csv", manager.getUI());
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(exportFile));
            EntityChangeListener listener = (EntityChangeListener)((Object)manager);
            if (!this.importEquipments(listener, reader)) {
                MessageBox.Info.showOption(manager.getUI(), i18nCraft.translateString("NoEquipmentFoundInFile"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract boolean importEquipments(EntityChangeListener<Equipment> var1, CSVReader var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigureContainer(Equipment equipment, ConfigApplicationView configAppView, ManagerView manager, Class<? extends Task> clazz, Task task) {
        JFrame jFrame = this.frame;
        synchronized (jFrame) {
            if (!this.frame.isDisplayable()) {
                if (clazz == null) {
                    IpAddress ip = new IpAddress(equipment.getIpAddr());
                    this.frame = FrameUtil.createModalFrame((Window)manager.getUI().getTopLevelAncestor(), true);
                    this.frame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            Frame[] fr = JFrame.getFrames();
                            for (int i = 2; i < fr.length; ++i) {
                                fr[i].dispose();
                            }
                            if (CraftMain2.mainFrame != null) {
                                CraftMain2.mainFrame.setVisible(true);
                            }
                        }
                    });
                    FrameUtil.runFrame(this.frame, i18n.translateString("ConfiguringEquipmentCraft", equipment.getName(), ip.toString()), configAppView, 900, 700, true);
                    if (CraftMain2.mainFrame != null) {
                        CraftMain2.mainFrame.setVisible(false);
                    }
                } else {
                    TaskEditorFormContainer container = new TaskEditorFormContainer(clazz, task, manager);
                    this.frame = container.getFrame();
                }
            }
        }
    }

    @Override
    public SortView getSortView() {
        return new EntityManagerSortByIdNoUI();
    }

    @Override
    public NavigatorView getNavigatorView() {
        return new NullNavigatorView();
    }

    @Override
    public String getHelpTopic() {
        return this.getHelp();
    }

    protected abstract String getHelp();

    protected void Columns() {
        this.columns.remove(4);
    }

    protected void initEntityRowProvider() {
        this.entityRowProvider = new CraftEquipmentRowProvider(CraftBaseStationManagerConfig.getColumnAttributeNames(this.columns));
    }

    @Override
    protected String getManagerName() {
        return this.getManagerNameString();
    }

    protected abstract String getManagerNameString();

    @Override
    protected String getBaseName() {
        return this.getBaseNameString();
    }

    protected abstract String getBaseNameString();

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return super.getEntityRowProvider();
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    @Override
    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView(new IconEntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles()){
            private static final long serialVersionUID = 8621736543199890828L;

            protected Icon getIcon(Serializable entity) {
                return UIIconFactory.getIcon(entity, 2);
            }
        }, this.getColumns()){

            @Override
            protected void replaceData(EntityQueryResults data) {
                List<EntityManagerRow> oldSelection = this.getSelection();
                this.tableModel.replaceData(data.getData());
                if (this.sortedColumn >= 0) {
                    this.sortedAscending = !this.sortedAscending;
                    this.sortByColumn(this.sortedColumn);
                }
                this.updateSelection(oldSelection);
            }

            @Override
            protected void sortData(Comparator<EntityManagerRow> comparator) {
                List<EntityManagerRow> oldSelection = this.getSelection();
                this.tableModel.sortData(comparator);
                this.updateSelection(oldSelection);
            }

            private void updateSelection(List<EntityManagerRow> oldSelection) {
                for (EntityManagerRow oldRow : oldSelection) {
                    int index = 0;
                    for (EntityManagerRow row : this.tableModel.getRows()) {
                        if (((Equipment)row.getEntity()).getId() == ((Equipment)oldRow.getEntity()).getId()) {
                            this.form.getResultTable().getSelectionModel().addSelectionInterval(index, index);
                        }
                        ++index;
                    }
                }
            }

            @Override
            protected void updateResultsDescription(Integer totalResultCount) {
                this.form.getLblResultDescription().setText(i18n.translateString("ResultsDescriptionCurrent", this.tableModel.getRowCount()));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CraftEquipmentRowProvider
    extends EntityManagerRowProviderBase {
        public CraftEquipmentRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            ret.set(1, AllEquipmentManagerConfig.ddI18N.translateString(ret.get(1)));
            Integer state = (Integer)(entityRow == null ? null : entityRow.getAttributeValue(4));
            if (null == state) {
                ret.set(4, AbstractEquipmentManagerConfig.i18n.translateString("Unlicensed"));
            } else {
                ret.set(4, AbstractEquipmentManagerConfig.i18n.translateString(EquipmentStateEnum.toString(state)));
            }
            return ret;
        }

        @Override
        protected List<Serializable> readAttributeValues(Serializable entity) {
            List<Serializable> ret = super.readAttributeValues(entity);
            ret.set(1, (Serializable)((Object)entity.getClass().getName()));
            ret.set(3, null != ret.get(3) ? new IpAddress((String)((Object)ret.get(3))) : null);
            boolean licensed = LicenseHelper.isLicensed(entity);
            if (!licensed) {
                ret.set(4, null);
            }
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((Equipment)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CraftEquipmentManagerAction
    extends ManagerAction {
        public CraftEquipmentManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public void performAction(ManagerView manager) {
            if ("New".equals(this.name)) {
                if (manager.getData().size() >= CraftBaseStationManagerConfig.this.getMaxDevices()) {
                    Object[] options = new String[]{i18nCraft.translateString("New_Device_Warning_OK")};
                    JOptionPane.showOptionDialog(manager.getUI(), i18nCraft.translateString("New_Device_Warning_Reached_Max_Devices", CraftBaseStationManagerConfig.this.getMaxDevices()), i18nCraft.translateString("New_Device_Warning"), -1, 2, null, options, options[0]);
                    return;
                }
                CraftBaseStationManagerConfig.this.performActionNew(manager);
            } else if ("Configure".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionConfigure(manager);
            } else if ("Edit".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionEdit(manager);
            } else if ("Delete".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionDelete(manager);
            } else if ("TelnetCutThrough".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionTelnetCutThrough(manager);
            } else if ("Export".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionExport(manager);
            } else if ("Import".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionImport(manager);
            } else if ("AutoDiscovery".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionAutoDiscovery(manager);
            } else if ("TestConnectivity".equals(this.name)) {
                CraftBaseStationManagerConfig.this.performActionTestConnectivity(manager);
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "add")) {
                    return false;
                }
            } else if (this.name.equals("AutoDiscovery")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("TestConnectivity")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                        return false;
                    }
                    return 0 < selectionSize;
                }
                if (this.name.equals("Edit")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    for (Serializable row : selection) {
                        Equipment eq = (Equipment)row;
                        if (EditorPluginUtil.getViewForClass(eq.getClass()) != null && LicenseClient.getInstance().isLicensed(eq)) continue;
                        return false;
                    }
                    return true;
                }
                if (this.name.equals("Configure")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    Equipment eq = (Equipment)selection.get(0);
                    return null != eq.getFirmwareVersion() && !"".equals(eq.getFirmwareVersion()) && eq != null && eq.getState() == 0 && LicenseClient.getInstance().isLicensed(eq);
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                        return false;
                    }
                    return 0 < selectionSize;
                }
                if (this.name.equals("TelnetCutThrough")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    Equipment eq = (Equipment)selection.get(0);
                    return LicenseClient.getInstance().isLicensed(eq) && CutThroughPluginUtil.isCutThroughSupported(eq.getClass()) && eq.getState() == 0;
                }
                if (this.name.equals("Export")) {
                    return selectionSize > 0;
                }
            }
            return true;
        }

        @Override
        public Internationalizer getI18n() {
            return AbstractEquipmentManagerConfig.i18n;
        }
    }
}

