/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.CraftAutoDiscoveryPanel;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.InvalidNetworkMaskException;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftAutoDiscoveryView
extends AbstractBindedEditorView<NetworkIpAddressRange> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(CraftAutoDiscoveryView.class);
    private CraftAutoDiscoveryPanel panel = new CraftAutoDiscoveryPanel();
    private static final int CRAFT_MAX_RANGE_SIZE = 255;
    private final int RETRIES_MIN_VALUE = 0;
    private final int RETRIES_MAX_VALUE = 255;
    private final long TIMEOUT_MIN_VALUE = 1L;
    private final long TIMEOUT_MAX_VALUE = 3600L;

    public List<InvalidValue> validate() {
        return new ArrayList<InvalidValue>();
    }

    @Override
    public void fillUI(NetworkIpAddressRange temp) {
        if (temp.getType() != null) {
            if (temp.getType() == 0) {
                this.panel.getComboRangeType().setSelectedIndex(0);
            } else {
                this.panel.getComboRangeType().setSelectedIndex(1);
            }
        }
        this.panel.getTxtRangeStart().setText(temp.getStartIp());
        this.panel.getTxtRangeEndSubnetMask().setText(temp.getEndIp());
        this.panel.getTxtReadCommunity().setText(temp.getReadCommunity());
        this.panel.getTxtWriteCommunity().setText(temp.getWriteCommunity());
    }

    @Override
    public List<InvalidValue> configureEntity(NetworkIpAddressRange addressRange) {
        addressRange.setType((Integer)((ComboItem)this.panel.getComboRangeType().getSelectedItem()).getValue());
        addressRange.setStartIp(this.panel.getTxtRangeStart().getText());
        addressRange.setEndIp(this.panel.getTxtRangeEndSubnetMask().getText());
        addressRange.setReadCommunity(this.panel.getTxtReadCommunity().getText());
        addressRange.setWriteCommunity(this.panel.getTxtWriteCommunity().getText());
        List<InvalidValue> invalidValues = super.configureEntity(addressRange);
        this.validate(addressRange, invalidValues);
        if (invalidValues.size() == 0) {
            // empty if block
        }
        return invalidValues;
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("AutoDiscovery");
    }

    @Override
    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.help.tasks.rangescan";
    }

    public void validate(NetworkIpAddressRange addressRange, List<InvalidValue> invalidValues) {
        String rangeStart = addressRange.getStartIp();
        String rangeEnd = addressRange.getEndIp();
        Integer rangeType = addressRange.getType();
        String readCommunity = addressRange.getReadCommunity();
        String writeCommunity = addressRange.getWriteCommunity();
        boolean validRange = true;
        Internationalizer i18n = Internationalizer.getInternationalizer(CraftAutoDiscoveryView.class);
        if (!rangeStart.matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidStartIpAddress"), NetworkIpAddressRange.class, i18n.translateString("IPAddress"), (Object)this.notNull(rangeStart), (Object)this.panel.getTxtRangeStart()));
            validRange = false;
        }
        if (rangeType == 0 && !rangeEnd.matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidEndIpAddress"), NetworkIpAddressRange.class, i18n.translateString("IPAddress"), (Object)this.notNull(rangeEnd), (Object)this.panel.getTxtRangeEndSubnetMask()));
            validRange = false;
        }
        if (rangeType == 1 && !rangeEnd.matches("^255\\.255\\.255\\.(?:255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(?:254|252|248|240|224|192|128|0)\\.0$|^255\\.(?:254|252|248|240|224|192|128|0)\\.0\\.0$|^(?:254|252|248|240|224|192|128|0)\\.0\\.0\\.0$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnet"), NetworkIpAddressRange.class, i18n.translateString("Subnet"), (Object)this.notNull(rangeEnd), (Object)this));
            validRange = false;
        }
        if (readCommunity == null || readCommunity.trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueMustNotBeEmpty"), NetworkIpAddressRange.class, i18n.translateString("ReadCommunity"), (Object)this.notNull(readCommunity), (Object)this.panel.getTxtReadCommunity()));
        }
        if (writeCommunity == null || writeCommunity.trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueMustNotBeEmpty"), NetworkIpAddressRange.class, i18n.translateString("WriteCommunity"), (Object)this.notNull(writeCommunity), (Object)this.panel.getTxtWriteCommunity()));
        }
        if (validRange && rangeType != null) {
            IpAddressRange ipRange = null;
            if (rangeType == 0) {
                IpAddress startAddr = new IpAddress(rangeStart);
                IpAddress endAddr = new IpAddress(rangeEnd);
                if (startAddr.compareTo(endAddr) > 0) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidEndAddress"), NetworkIpAddressRange.class, i18n.translateString("RangeEnd"), (Object)this.notNull(rangeEnd), (Object)this.panel.getTxtRangeEndSubnetMask()));
                } else {
                    ipRange = new IpAddressRange(startAddr, endAddr);
                }
            } else {
                ipRange = this.getRange(rangeStart, rangeEnd);
            }
            if (ipRange != null) {
                int size = ipRange.size();
                if (ipRange != null && (size < 0 || size > 255)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("RangeTooBigMax255"), NetworkIpAddressRange.class, i18n.translateString("Subnet"), (Object)this.notNull(rangeEnd), (Object)this.panel.getTxtRangeEndSubnetMask()));
                }
            }
        }
        Integer retries = (Integer)this.panel.getSpnrRetries().getValue();
        Long timeout = (Long)this.panel.getSpnrTimeout().getValue();
        if (retries < 0 || retries > 255) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueTooBig", 0, 255), NetworkIpAddressRange.class, i18n.translateString("Retries"), (Object)retries, (Object)this.panel.getSpnrRetries()));
        }
        if (timeout < 1L || timeout > 3600L) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueTooBig", 1L, 3600L), NetworkIpAddressRange.class, i18n.translateString("Timeout(s)"), (Object)timeout, (Object)this.panel.getSpnrTimeout()));
        }
    }

    private String notNull(String val) {
        return val != null ? val : "";
    }

    public IpAddressRange getRange(String rangeStart, String rangeEnd) {
        IpAddressRange range;
        IpAddress start = new IpAddress(rangeStart);
        IpAddress end = new IpAddress(rangeEnd);
        try {
            IpAddress temp = IpAddressRange.getSubnetStart(start, end).prevIpAddress();
            range = temp.getIpAddressType(rangeEnd) == IpAddress.IpAddressType.HOST ? new IpAddressRange(start, start) : IpAddressRange.fromSubnet(start, end);
        }
        catch (InvalidNetworkMaskException e) {
            throw new RuntimeException(e);
        }
        return range;
    }
}

