/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationMonitor;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.NetworkScanMediationRequest;
import com.bwanms.mediation.ejb.NetworkScanSessionMessage;
import com.bwanms.model.AgentAuthentication;
import com.bwanms.model.Equipment;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.DDPluginUtil;
import com.bwanms.util.InvalidNetworkMaskException;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.Settings;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class CraftAutoDiscoveryExecutor
extends AbstractLongOperation
implements MessageListener {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(CraftAutoDiscoveryExecutor.class);
    private static final Lock lock = new ReentrantLock();
    private static final Condition finish = lock.newCondition();
    private NetworkIpAddressRange addressRange;
    private IpAddressRange range;
    private String startIpAddress;
    private String endIpAddress;
    private long sessionId;
    private IPScanResult[] results;
    private int nrScanned = 0;
    private int discovered = 0;
    private Integer retries;
    private Long timeout;
    private static final transient Logger log = Logger.getLogger(CraftAutoDiscoveryExecutor.class);

    public CraftAutoDiscoveryExecutor(NetworkIpAddressRange addressRange, Integer retries, Long timeout) {
        this.addressRange = addressRange;
        this.retries = retries;
        this.timeout = timeout;
        this.range = this.getRange();
    }

    public IpAddressRange getRange() {
        if (this.range != null) {
            return this.range;
        }
        IpAddress start = new IpAddress(this.addressRange.getStartIp());
        IpAddress end = new IpAddress(this.addressRange.getEndIp());
        if (this.addressRange.getType() == 0) {
            this.range = new IpAddressRange(start, end);
            this.startIpAddress = start.toString();
            this.endIpAddress = end.toString();
        } else {
            try {
                IpAddress temp = IpAddressRange.getSubnetStart(start, end).prevIpAddress();
                if (temp.getIpAddressType(this.addressRange.getEndIp()) == IpAddress.IpAddressType.HOST) {
                    this.range = new IpAddressRange(start, start);
                    this.startIpAddress = start.toString();
                    this.endIpAddress = start.toString();
                } else {
                    this.range = IpAddressRange.fromSubnet(start, end);
                    this.startIpAddress = IpAddressRange.getSubnetStart(start, end).toString();
                    this.endIpAddress = IpAddressRange.getSubnetEnd(start, end).toString();
                }
            }
            catch (InvalidNetworkMaskException e) {
                throw new RuntimeException(e);
            }
        }
        return this.range;
    }

    public boolean startNetworkScan() {
        if (this.range.size() > 0) {
            ArrayList<AgentAuthentication> agentAutenthications = new ArrayList<AgentAuthentication>();
            agentAutenthications.add(new SNMPAgentAuthentication(this.addressRange.getReadCommunity(), this.addressRange.getWriteCommunity()));
            NetworkScanMediationRequest req1 = new NetworkScanMediationRequest(this.range, agentAutenthications, this.retries, this.timeout);
            this.results = new IPScanResult[this.range.size()];
            this.sessionId = MediationServiceRegistry.getNetworkScanMediationService().createSession();
            MediationServiceRegistry.getNetworkScanMediationService().addRequest(this.sessionId, req1);
            PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/NetworkScanMediationTopic", this);
            MediationServiceRegistry.getNetworkScanMediationService().startSession(this.sessionId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block20: {
            IPScanResult ipScanResult = new IPScanResult();
            try {
                NetworkScanSessionMessage result = (NetworkScanSessionMessage)((ObjectMessage)message).getObject();
                if (result.getSessionId() != this.sessionId) {
                    return;
                }
                ipScanResult.setIpAddress(result.getIpAddress());
                if (result.getStatus() == 3) {
                    String readCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getReadCommunity();
                    String writeCommunity = ((SNMPAgentAuthentication)result.getCredentials()).getWriteCommunity();
                    log.debug((Object)("------------GOT RESULT:" + result.getSysName() + " " + result.getIpAddress() + ":" + result.getPort() + " ---- " + result.getSysObjID() + ", Read community:" + readCommunity + ", Write community:" + writeCommunity));
                    ipScanResult.setResult(IPScanResult.NOT_SUPPORTED_EQUIPMENT_FOUND);
                    ++this.discovered;
                    ipScanResult.setEqName(result.getSysName());
                    try {
                        String className = DDPluginUtil.getClassNameForOId(result.getSysObjID());
                        if (className != null) {
                            log.info((Object)(" ------------------------OID:" + result.getSysObjID() + " IS SUPPORTED WITH CLASS:" + className));
                            ipScanResult.setResult(IPScanResult.SUPPORTED_EQUIPMENT_FOUND);
                            Equipment equipment = DDRegistry.getInstance().createEquipment(new SNMPManagementInterface(result.getIpAddress(), Settings.instance().getSNMPSettingsDefaultPort(), readCommunity, writeCommunity, this.retries, this.timeout), DDPluginUtil.getClassNameForOId(result.getSysObjID()), result.getSysName());
                            try {
                                ServiceRegistry.getEntityManagerService().save(equipment);
                                log.info((Object)"++++++++++++++++++++++++++EQ CREATED++++++++++++++++++++++++++");
                                this.logMessage(i18n.translateString("DiscoveredEquipment", result.getSysName(), result.getIpAddress()));
                            }
                            catch (EntityAlreadyExistsException e) {
                                log.info((Object)"++++++++++++++++EQ WAS ALREADY DISCOVERED+++++++++++");
                                this.logMessage(i18n.translateString("AlreadyDiscovered", result.getSysName(), result.getIpAddress()));
                            }
                        } else {
                            this.logMessage(i18n.translateString("UnsupportedEquipment", result.getSysName(), result.getIpAddress()));
                        }
                    }
                    catch (Exception e) {
                        log.info((Object)"++++++++++++++++EQ TIMEOUT+++++++++++");
                        e.printStackTrace();
                    }
                    this.results[this.nrScanned++] = ipScanResult;
                    this.updateProgress(this.nrScanned);
                    break block20;
                }
                if (result.getStatus() == 5) {
                    log.debug((Object)("------------NO DEVICE AT : " + result.getIpAddress() + "---------------"));
                    this.logMessage(i18n.translateString("EquipmentNotFound", result.getIpAddress()));
                    ipScanResult.setResult(IPScanResult.NO_DEVICE_FOUND);
                    this.results[this.nrScanned++] = ipScanResult;
                    this.updateProgress(this.nrScanned);
                } else if (result.getStatus() == 1) {
                    log.debug((Object)"------------SESSION CLOSED MESSAGE RECEIVED---------------");
                    PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this);
                    this.updateProgress(this.getMaxProgress());
                } else if (result.getStatus() == 2) {
                    log.debug((Object)"------------SESSION ABORTED MESSAGE RECEIVED---------------");
                    this.updateProgress(this.getMaxProgress());
                    this.signalNetworkScanFinish();
                } else if (result.getStatus() == 4) {
                    log.debug((Object)"------------REQUEST COMPLETED MESSAGE RECEIVED---------------");
                    MediationServiceRegistry.getNetworkScanMediationService().closeSession(this.sessionId);
                    this.updateProgress(this.getMaxProgress());
                    this.signalNetworkScanFinish();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public long getMaxProgress() {
        return this.getRange().size();
    }

    public String getTitle() {
        return i18n.translateString("AutoDiscovery");
    }

    public boolean isCancelable() {
        return true;
    }

    public void cancel() {
        MediationServiceRegistry.getNetworkScanMediationService().abortSession(this.sessionId);
        super.cancel();
    }

    public void run() {
        if (this.startNetworkScan()) {
            this.awaitNetworkScanFinish();
        }
        this.monitor.operationCompleted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitNetworkScanFinish() {
        lock.lock();
        try {
            finish.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalNetworkScanFinish() {
        lock.lock();
        try {
            finish.signal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMessage(String message) {
        LongOperationMonitor longOperationMonitor = this.monitor;
        synchronized (longOperationMonitor) {
            this.monitor.logMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgress(long progress) {
        LongOperationMonitor longOperationMonitor = this.monitor;
        synchronized (longOperationMonitor) {
            this.monitor.updateProgress(progress, i18n.translateString("ScanIPRange", this.startIpAddress, this.endIpAddress));
        }
    }
}

