/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.equipmentmanager.CraftAutoDiscoveryExecutor;
import com.bwanms.gui.equipmentmanager.CraftAutoDiscoveryPanel;
import com.bwanms.gui.equipmentmanager.CraftAutoDiscoveryView;
import com.bwanms.gui.equipmentmanager.EquipmentEditorContainer;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.Equipment;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.services.ServiceException;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftAutoDiscoveryEditorContainer
extends EntityEditorContainer<NetworkIpAddressRange> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EquipmentEditorContainer.class);
    private JComponent managerUI;

    public CraftAutoDiscoveryEditorContainer(JComponent owner, NetworkIpAddressRange networkIpAddressRange) throws ServiceException {
        this(networkIpAddressRange, SwingUtilities.getWindowAncestor(owner), null);
        this.managerUI = owner;
    }

    private CraftAutoDiscoveryEditorContainer(NetworkIpAddressRange networkIpAddressRange) throws ServiceException {
        this(networkIpAddressRange, null, null);
    }

    private CraftAutoDiscoveryEditorContainer(Window owner, NetworkIpAddressRange networkIpAddressRange) throws ServiceException {
        this(networkIpAddressRange, owner, null);
    }

    private CraftAutoDiscoveryEditorContainer(Window owner, NetworkIpAddressRange networkIpAddressRange, EntityChangeListener<NetworkIpAddressRange> entityChangeCallback) throws ServiceException {
        this(networkIpAddressRange, owner, entityChangeCallback);
    }

    private CraftAutoDiscoveryEditorContainer(NetworkIpAddressRange networkIpAddressRange, EntityChangeListener<NetworkIpAddressRange> entityChangeCallback) throws ServiceException {
        this(networkIpAddressRange, null, entityChangeCallback);
    }

    private CraftAutoDiscoveryEditorContainer(NetworkIpAddressRange networkIpAddressRange, Window owner, EntityChangeListener<NetworkIpAddressRange> entityChangeCallback) throws ServiceException {
        super(networkIpAddressRange, owner);
    }

    @Override
    public void actionCancelPerformed() {
        this.closeFrame();
    }

    public void onSaveErrors() {
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((NetworkIpAddressRange)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return null;
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Equipment.class.getName());
    }

    @Override
    protected EditorView<NetworkIpAddressRange> initView() {
        return new CraftAutoDiscoveryView();
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ManagedEquipmentSettings");
    }

    @Override
    public void actionOKPerformed() {
        if (this.save() != null) {
            CraftAutoDiscoveryPanel panel = (CraftAutoDiscoveryPanel)this.view.getUI();
            Integer retries = (Integer)panel.getSpnrRetries().getValue();
            Long timeout = (Long)panel.getSpnrTimeout().getValue();
            CraftAutoDiscoveryExecutor longOperation = new CraftAutoDiscoveryExecutor((NetworkIpAddressRange)this.entity, retries, timeout * 1000L);
            this.cleanup();
            LongOperationUtil.startDetailLongOperationDialog(this.managerUI, longOperation);
        }
    }
}

