/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.selectors.SelectorComponent;
import com.bwanms.gui.selectors.SelectorViewValueDisplay;
import com.bwanms.gui.selectors.contact.ContactSelectorView;
import com.bwanms.gui.selectors.location.LocationSelectorView;
import com.bwanms.model.Contact;
import com.bwanms.model.Location;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommonAttributesSelectorPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(CommonAttributesSelectorPanel.class);
    private JLabel lblLocation;
    private SelectorComponent selectorLocation;
    private JCheckBox chkLocation;
    private JLabel lblContact;
    private SelectorComponent selectorContact;
    private JCheckBox chkContact;

    public CommonAttributesSelectorPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.selectorLocation.setDisplay(new SelectorViewValueDisplay(){

            public String toDisplayString(Object value) {
                return ((Location)value).getName();
            }
        });
        this.selectorLocation.setSelectorView(Selectors.getSelectorView(Location.class, "0"));
        this.selectorContact.setDisplay(new SelectorViewValueDisplay(){

            public String toDisplayString(Object value) {
                return ((Contact)value).getContactId();
            }
        });
        this.selectorContact.setSelectorView(Selectors.getSelectorView(Contact.class, null));
        i18n.getSwingInternationalizer().translateComponent(this);
    }

    private void initComponents() {
        this.lblLocation = new JLabel();
        this.selectorLocation = new SelectorComponent();
        this.chkLocation = new JCheckBox();
        this.lblContact = new JLabel();
        this.selectorContact = new SelectorComponent();
        this.chkContact = new JCheckBox();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)60), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)35)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)55)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)25)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(RowSpec.TOP, (Size)Sizes.DLUY5, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.BOTTOM, (Size)Sizes.DLUY5, 0.0)}));
        this.lblLocation.setText("Location");
        this.add((Component)this.lblLocation, cc.xy(3, 3));
        this.selectorLocation.setNullable(true);
        this.add((Component)this.selectorLocation, cc.xywh(5, 3, 5, 1));
        this.chkLocation.setText("Update");
        this.chkLocation.setSelected(true);
        this.chkLocation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CommonAttributesSelectorPanel.this.chkLocationStateChanged(e);
            }
        });
        this.add((Component)this.chkLocation, cc.xy(11, 3));
        this.lblContact.setText("Contact");
        this.add((Component)this.lblContact, cc.xy(3, 5));
        this.selectorContact.setNullable(true);
        this.add((Component)this.selectorContact, cc.xywh(5, 5, 5, 1));
        this.chkContact.setText("Update");
        this.chkContact.setSelected(true);
        this.chkContact.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CommonAttributesSelectorPanel.this.chkContactStateChanged(e);
            }
        });
        this.add((Component)this.chkContact, cc.xy(11, 5));
    }

    public JCheckBox getChkLocation() {
        return this.chkLocation;
    }

    public JCheckBox getChkContact() {
        return this.chkContact;
    }

    private void chkLocationStateChanged(ChangeEvent e) {
        if (this.chkLocation.isSelected()) {
            this.lblLocation.setEnabled(true);
            this.selectorLocation.getBtnClear().setEnabled(true);
            this.selectorLocation.getBtnSearch().setEnabled(true);
            this.selectorLocation.getTxtSelectedValues().setEnabled(true);
        } else {
            this.lblLocation.setEnabled(false);
            this.selectorLocation.getBtnClear().setEnabled(false);
            this.selectorLocation.getBtnSearch().setEnabled(false);
            this.selectorLocation.getTxtSelectedValues().setEnabled(false);
        }
    }

    private void chkContactStateChanged(ChangeEvent e) {
        if (this.chkContact.isSelected()) {
            this.lblContact.setEnabled(true);
            this.selectorContact.getBtnClear().setEnabled(true);
            this.selectorContact.getBtnSearch().setEnabled(true);
            this.selectorContact.getTxtSelectedValues().setEnabled(true);
        } else {
            this.lblContact.setEnabled(false);
            this.selectorContact.getBtnClear().setEnabled(false);
            this.selectorContact.getBtnSearch().setEnabled(false);
            this.selectorContact.getTxtSelectedValues().setEnabled(false);
        }
    }

    public Location getSelectedLocation() {
        List locations = ((LocationSelectorView)this.selectorLocation.getSelectorView()).getSelection();
        if (locations != null && locations.size() > 0) {
            return (Location)locations.get(0);
        }
        return null;
    }

    public Contact getSelectedContact() {
        List contacts = ((ContactSelectorView)this.selectorContact.getSelectorView()).getSelection();
        if (contacts != null && contacts.size() > 0) {
            return (Contact)contacts.get(0);
        }
        return null;
    }
}

